/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.filesys;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.cifs.server.filesys.FileExistsException;
import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.FileOpenParams;
import org.exoplatform.services.cifs.server.filesys.JCRNetworkFile;
import org.exoplatform.services.cifs.server.filesys.NameCoder;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.SearchContext;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.util.WildCard;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;

public class JCRDriver {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.JCRDriver");

    public static NetworkFile createFile(TreeConnection conn, FileOpenParams params) throws FileExistsException, LockException, AccessDeniedException, RepositoryException {
        String path = params.getPath();
        if (conn.getSession().itemExists(path) && !params.isOverwrite()) {
            throw new FileExistsException();
        }
        Session session = conn.getSession();
        Node nodeRef = JCRDriver.createNode(session, path, !params.isDirectory());
        JCRNetworkFile netFile = new JCRNetworkFile();
        netFile.setNodeRef(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created file: \n   path: " + path + "\n" + "   file open parameters: " + params + "\n" + "   node: " + nodeRef + "\n" + "   network file: " + netFile));
        }
        return netFile;
    }

    public static NetworkFile openFile(TreeConnection conn, FileOpenParams params) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        try {
            logger.debug((Object)"openFile");
            String path = params.getPath();
            Session session = conn.getSession();
            Node nodeRef = (Node)session.getItem(path);
            if (params.hasAccessMode(1)) {
                try {
                    session.checkPermission(path, "read");
                }
                catch (AccessControlException e) {
                    throw new AccessDeniedException("No read access to " + params.getFullPath());
                }
            }
            if (params.hasAccessMode(2)) {
                try {
                    session.checkPermission(path, "add_node");
                    session.checkPermission(path, "set_property");
                }
                catch (AccessControlException e) {
                    throw new AccessDeniedException("No write access to " + params.getFullPath());
                }
            }
            if (params.hasAccessMode(65536)) {
                try {
                    session.checkPermission(path, "remove");
                }
                catch (AccessControlException e) {
                    throw new AccessDeniedException("No delete access to " + params.getFullPath());
                }
            }
            if (params.hasAccessMode(2) && nodeRef.isLocked()) {
                throw new AccessDeniedException("File is locked, no write access to " + params.getFullPath());
            }
            JCRNetworkFile netFile = new JCRNetworkFile();
            if (params.isReadOnlyAccess()) {
                netFile.setGrantedAccess(0);
            } else {
                netFile.setGrantedAccess(2);
            }
            FileInfo fileInfo = JCRDriver.getFileInformation(nodeRef);
            netFile.setNodeRef(nodeRef);
            if (fileInfo.isDirectory()) {
                netFile.setAttributes(16);
            } else {
                netFile.setFileSize(fileInfo.getSize());
            }
            if (fileInfo.hasCreationDateTime()) {
                netFile.setCreationDate(fileInfo.getCreationDateTime());
            }
            if (fileInfo.hasModifyDateTime()) {
                netFile.setModifyDate(fileInfo.getModifyDateTime());
            }
            if (fileInfo.hasAccessDateTime()) {
                netFile.setAccessDate(fileInfo.getAccessDateTime());
            }
            netFile.setAttributes(fileInfo.getFileAttributes());
            if (netFile.isReadOnly()) {
                netFile.setGrantedAccess(0);
            }
            if (params.isOverwrite() && netFile != null) {
                netFile.truncateFile(params.getAllocationSize());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened network file: \n   path: " + params.getPath() + "\n" + "   file open parameters: " + params + "\n" + "   network file: " + netFile));
            }
            return netFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException(e.getMessage());
        }
    }

    public static FileInfo getFileInformation(Node nodeRef) throws RepositoryException {
        try {
            int attr;
            FileInfo fileInfo = new FileInfo();
            int fileAttributes = 0;
            fileInfo.setFileAttributes(fileAttributes);
            if (!nodeRef.isNodeType("nt:file")) {
                fileInfo.setFileAttributes(fileAttributes |= 0x10);
                fileInfo.setSize(0L);
            } else {
                boolean lock;
                Node contentNode = nodeRef.getNode("jcr:content");
                Property dataProp = contentNode.getProperty("jcr:data");
                long size = 0L;
                if (dataProp != null) {
                    size = dataProp.getLength();
                }
                fileInfo.setSize(size);
                if (size > 0L) {
                    fileInfo.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
                }
                if (lock = nodeRef.isLocked()) {
                    int attr2 = fileInfo.getFileAttributes();
                    if ((attr2 & 1) == 0) {
                        ++attr2;
                    }
                    fileInfo.setFileAttributes(attr2);
                }
            }
            try {
                Calendar date = nodeRef.getProperty("jcr:created").getDate();
                fileInfo.setCreationDateTime(date.getTimeInMillis());
            }
            catch (PathNotFoundException ex) {
                fileInfo.setCreationDateTime(0L);
            }
            String name = nodeRef.getName();
            if (name != null) {
                String nname = name;
                if (nodeRef.getSession().getRootNode() != nodeRef) {
                    Node parent = nodeRef.getParent();
                    NodeIterator ni = parent.getNodes(name);
                    int i = 0;
                    int el = 0;
                    while (ni.hasNext()) {
                        if (nodeRef == ni.nextNode()) {
                            el = i + 1;
                        }
                        ++i;
                    }
                    if (i > 1) {
                        nname = name + "[" + el + "]";
                    }
                }
                fileInfo.setFileName(NameCoder.EncodeName(nname));
            }
            boolean deniedPermission = false;
            boolean isReadOnly = false;
            if ((isReadOnly || deniedPermission) && ((attr = fileInfo.getFileAttributes()) & 1) == 0) {
                fileInfo.setFileAttributes(++attr);
            }
            if (fileInfo.getFileAttributes() == 0) {
                fileInfo.setFileAttributes(0x8000080);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n Fetched file info: \n   info: " + fileInfo));
            }
            return fileInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    public static FileInfo getFileInformation(JCRNetworkFile file) throws RepositoryException {
        try {
            int attr;
            FileInfo fileInfo = new FileInfo();
            int fileAttributes = 0;
            fileInfo.setFileAttributes(fileAttributes);
            if (!file.getNodeRef().isNodeType("nt:file")) {
                fileInfo.setFileAttributes(fileAttributes |= 0x10);
                fileInfo.setSize(0L);
            } else {
                boolean lock;
                long size = 0L;
                size = file.getLength();
                fileInfo.setSize(size);
                if (size > 0L) {
                    fileInfo.setAllocationSize(size + 512L & 0xFFFFFFFFFFFFFE00L);
                }
                if (lock = file.getNodeRef().isLocked()) {
                    int attr2 = fileInfo.getFileAttributes();
                    if ((attr2 & 1) == 0) {
                        ++attr2;
                    }
                    fileInfo.setFileAttributes(attr2);
                }
            }
            try {
                Calendar date = file.getNodeRef().getProperty("jcr:created").getDate();
                fileInfo.setCreationDateTime(date.getTimeInMillis());
            }
            catch (PathNotFoundException ex) {
                fileInfo.setCreationDateTime(0L);
            }
            String name = file.getNodeRef().getName();
            if (name != null) {
                String nname = name;
                if (file.getNodeRef().getSession().getRootNode() != file.getNodeRef()) {
                    Node parent = file.getNodeRef().getParent();
                    NodeIterator ni = parent.getNodes(name);
                    int i = 0;
                    int el = 0;
                    while (ni.hasNext()) {
                        if (file.getNodeRef() == ni.nextNode()) {
                            el = i + 1;
                        }
                        ++i;
                    }
                    if (i > 1) {
                        nname = name + "[" + el + "]";
                    }
                }
                fileInfo.setFileName(NameCoder.EncodeName(nname));
            }
            boolean deniedPermission = false;
            boolean isReadOnly = false;
            if ((isReadOnly || deniedPermission) && ((attr = fileInfo.getFileAttributes()) & 1) == 0) {
                fileInfo.setFileAttributes(++attr);
            }
            if (fileInfo.getFileAttributes() == 0) {
                fileInfo.setFileAttributes(0x8000080);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n Fetched file info: \n   info: " + fileInfo));
            }
            return fileInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException(e.getMessage());
        }
    }

    public static SearchContext startSearch(TreeConnection conn, String srchPath, int srchAttr) throws FileNotFoundException, RepositoryException {
        logger.debug((Object)("startSearch path [" + srchPath + "]"));
        try {
            List<Object> results;
            Session jcrSess = conn.getSession();
            if (!WildCard.containsWildcards(srchPath)) {
                Node foundNodeRef = (Node)jcrSess.getItem(srchPath);
                results = foundNodeRef == null ? Collections.emptyList() : Collections.singletonList(foundNodeRef);
            } else {
                int i = srchPath.lastIndexOf("/");
                String path = srchPath.substring(0, i);
                if (path.equals("")) {
                    path = "/";
                }
                Node rootNode = (Node)jcrSess.getItem(path);
                NodeIterator ni = rootNode.getNodes("*");
                results = new ArrayList((int)ni.getSize());
                int count = 0;
                while (ni.hasNext()) {
                    results.add(ni.nextNode());
                    ++count;
                }
                logger.debug((Object)("files found " + count));
            }
            SearchContext ctx = new SearchContext(results, srchPath);
            return ctx;
        }
        catch (PathNotFoundException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start search - no such path, " + srchPath));
            }
            throw new FileNotFoundException("Start search " + srchPath);
        }
    }

    public static Node createNode(Session sess, String path, boolean isFile) throws LockException, AccessDeniedException, RepositoryException {
        try {
            JCRPath jcrPath = ((SessionImpl)sess).getLocationFactory().parseJCRPath(path);
            JCRPath.PathElement[] pathEl = jcrPath.getRelPath(jcrPath.getDepth());
            Node parentFolderNodeRef = sess.getRootNode();
            for (int i = 0; i < jcrPath.getDepth() - 1; ++i) {
                Node tempFolderNodeRef = parentFolderNodeRef;
                String nextNodeName = pathEl[i].getAsString();
                parentFolderNodeRef = tempFolderNodeRef.hasNode(nextNodeName) ? tempFolderNodeRef.getNode(nextNodeName) : tempFolderNodeRef.addNode(nextNodeName);
            }
            String type = isFile ? "nt:file" : "nt:folder";
            String name = pathEl[jcrPath.getDepth() - 1].getAsString();
            Node createdNodeRef = parentFolderNodeRef.addNode(name, type);
            if (type == "nt:file") {
                Node dataNode = createdNodeRef.addNode("jcr:content", "nt:resource");
                MimeTypeResolver mimetypeResolver = new MimeTypeResolver();
                mimetypeResolver.setDefaultMimeType("application/zip");
                String mimeType = mimetypeResolver.getMimeType(name);
                dataNode.setProperty("jcr:mimeType", mimeType);
                dataNode.setProperty("jcr:lastModified", Calendar.getInstance());
                dataNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(new byte[0]));
            }
            sess.save();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created node: path [" + path + "] " + (isFile ? "file" : "folder") + "   new node: [" + createdNodeRef.getPath() + "]"));
            }
            return createdNodeRef;
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (VersionException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (ValueFormatException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Deprecated
    public static int readFile(SMBSrvSession m_sess, TreeConnection conn, NetworkFile netFile, byte[] buf, int dataPos, int maxCount, long offset) throws AccessDeniedException, RepositoryException, IOException {
        int count;
        if (netFile.isDirectory()) {
            throw new AccessDeniedException();
        }
        Node n = ((JCRNetworkFile)netFile).getNodeRef();
        InputStream is = n.getNode("jcr:content").getProperty("jcr:data").getStream();
        long skip_count = is.skip(offset);
        if (skip_count < offset || skip_count == -1L) {
            count = 0;
        } else {
            byte[] tmpbuf = new byte[maxCount];
            count = is.read(tmpbuf);
            if (count != -1) {
                System.arraycopy(tmpbuf, 0, buf, dataPos, count);
            } else {
                count = 0;
            }
        }
        is.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read bytes from file: \n   network file: " + netFile + "\n" + "   buffer size: " + buf.length + "\n" + "   buffer pos: " + dataPos + "\n" + "   size: " + maxCount + "\n" + "   file offset: " + offset + "\n" + "   bytes read: " + count));
        }
        return count;
    }

    public static void setFileInformation(SMBSrvSession m_sess, TreeConnection conn, String fileName, FileInfo finfo) throws Exception {
    }
}

