/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb;

import org.exoplatform.services.cifs.smb.InvalidUNCPathException;

public final class PCShare {
    private String m_domain = null;
    private String m_nodename = null;
    private String m_shrname = null;
    private String m_username = null;
    private String m_password = null;
    private String m_path = null;
    private String m_fname = null;
    private int m_primaryProto = 0;
    private int m_secondaryProto = 0;
    private int m_extendedSecFlags;

    public PCShare() {
    }

    public PCShare(String netpath) throws InvalidUNCPathException {
        this.setNetworkPath(netpath);
        if (this.m_username == null) {
            this.setUserName("GUEST");
        }
    }

    public PCShare(String nname, String shr, String uname, String pwd) {
        this.setNodeName(nname);
        this.setShareName(shr);
        this.setUserName(uname);
        this.setPassword(pwd);
    }

    public static String makePath(String workdir, String fname) {
        StringBuffer pathStr = new StringBuffer();
        if (!workdir.startsWith("\\")) {
            pathStr.append("\\");
        }
        pathStr.append(workdir);
        if (pathStr.charAt(pathStr.length() - 1) != '\\') {
            pathStr.append("\\");
        }
        pathStr.append(fname);
        return pathStr.toString();
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final boolean hasExtendedSecurityFlags() {
        return this.m_extendedSecFlags != 0;
    }

    public final int getExtendedSecurityFlags() {
        return this.m_extendedSecFlags;
    }

    public final String getFileName() {
        return this.m_fname;
    }

    public final String getNetworkPath() {
        StringBuffer strBuf = new StringBuffer(128);
        strBuf.append("\\\\");
        strBuf.append(this.getNodeName());
        strBuf.append("\\");
        strBuf.append(this.getShareName());
        if (this.getPath() != null && this.getPath().length() > 0) {
            if (this.getPath().charAt(0) != '\\') {
                strBuf.append("\\");
            }
            strBuf.append(this.getPath());
        }
        if (this.getFileName() != null && this.getFileName().length() > 0) {
            if (strBuf.charAt(strBuf.length() - 1) != '\\') {
                strBuf.append("\\");
            }
            strBuf.append(this.getFileName());
        }
        return strBuf.toString();
    }

    public final String getNodeName() {
        return this.m_nodename;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final String getPath() {
        return this.m_path != null ? this.m_path : "\\";
    }

    public final String getRelativePath() {
        StringBuffer strBuf = new StringBuffer(128);
        if (this.getPath().length() > 0) {
            if (this.getPath().charAt(0) != '\\') {
                strBuf.append("\\");
            }
            strBuf.append(this.getPath());
        }
        if (this.getFileName().length() > 0) {
            if (strBuf.charAt(strBuf.length() - 1) != '\\') {
                strBuf.append("\\");
            }
            strBuf.append(this.getFileName());
        }
        return strBuf.toString();
    }

    public final String getShareName() {
        return this.m_shrname;
    }

    public final String getUserName() {
        return this.m_username != null ? this.m_username : "";
    }

    public final int getPrimaryProtocol() {
        return this.m_primaryProto;
    }

    public final int getSecondaryProtocol() {
        return this.m_secondaryProto;
    }

    public final boolean hasDomain() {
        return this.m_domain != null;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
        if (this.m_domain != null) {
            this.m_domain = this.m_domain.toUpperCase();
        }
    }

    public final void setFileName(String fn) {
        this.m_fname = fn;
    }

    public final void setNetworkPath(String netpath) throws InvalidUNCPathException {
        StringBuffer path = new StringBuffer(netpath);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        String npath = path.toString();
        if (!npath.startsWith("//") || npath.length() < 5) {
            throw new InvalidUNCPathException(npath);
        }
        int pos = 2;
        int endpos = npath.indexOf("/", pos);
        if (endpos == -1) {
            throw new InvalidUNCPathException(npath);
        }
        this.setNodeName(npath.substring(pos, endpos));
        pos = endpos + 1;
        endpos = npath.indexOf("/", pos);
        if (endpos == -1) {
            this.setShareName(npath.substring(pos));
            this.setPath("/");
            this.setFileName("");
        } else {
            this.setShareName(npath.substring(pos, endpos));
            pos = endpos + 1;
            endpos = npath.lastIndexOf("/");
            if (endpos != -1 && endpos > pos) {
                this.setPath(npath.substring(pos, endpos));
                this.setFileName(npath.substring(endpos + 1));
            } else {
                this.setPath("/");
                if (npath.length() > pos) {
                    this.setFileName(npath.substring(pos));
                } else {
                    this.setFileName("");
                }
            }
        }
        pos = this.m_shrname.indexOf("%");
        if (pos != -1) {
            endpos = this.m_shrname.indexOf(":", pos);
            if (endpos != -1) {
                this.setUserName(this.m_shrname.substring(pos + 1, endpos));
                this.setPassword(this.m_shrname.substring(endpos + 1));
            } else {
                this.setUserName(this.m_shrname.substring(pos + 1));
            }
            this.setShareName(this.m_shrname.substring(0, pos));
        }
        if (this.m_path == null || this.m_path.length() == 0) {
            this.m_path = "/";
        }
    }

    public final void setExtendedSecurityFlags(int extFlags) {
        this.m_extendedSecFlags = extFlags;
    }

    public final void setNodeName(String nname) {
        this.m_nodename = nname;
    }

    public final void setPassword(String pwd) {
        this.m_password = pwd;
    }

    public final void setPath(String pth) {
        this.m_path = pth;
    }

    public final void setShareName(String shr) {
        this.m_shrname = shr;
    }

    public final void setUserName(String uname) {
        this.m_username = uname;
    }

    public final void setProtocolOrder(int pri, int sec) {
        this.m_primaryProto = pri;
        this.m_secondaryProto = sec;
    }

    public final String toString() {
        return this.getNetworkPath();
    }
}

