/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.util;

public final class WildCard {
    public static final int MULTICHAR_WILDCARD = 42;
    public static final int SINGLECHAR_WILDCARD = 63;
    public static final int SINGLECHAR_UNICODE_WILDCARD = 62;
    public static final int DOT_UNICODE_WILDCARD = 34;
    public static final int MULTICHAR_UNICODE_WILDCARD = 60;
    public static final int WILDCARD_NONE = 0;
    public static final int WILDCARD_ALL = 1;
    public static final int WILDCARD_NAME = 2;
    public static final int WILDCARD_EXT = 3;
    public static final int WILDCARD_COMPLEX = 4;
    public static final int WILDCARD_INVALID = -1;
    private String m_pattern;
    private int m_type;
    private String m_matchPart;
    private boolean m_caseSensitive;
    private char[] m_patternChars;

    public WildCard() {
        this.setType(-1);
    }

    public WildCard(String pattern, boolean caseSensitive) {
        this.setPattern(pattern, caseSensitive);
    }

    public final int isType() {
        return this.m_type;
    }

    public final boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public final String getPattern() {
        return this.m_pattern;
    }

    public final String getMatchPart() {
        return this.m_matchPart;
    }

    public final boolean matchesPattern(String str) {
        boolean sts = false;
        switch (this.isType()) {
            case 1: {
                sts = true;
                break;
            }
            case 2: {
                if (this.isCaseSensitive()) {
                    sts = str.endsWith(this.m_matchPart);
                    break;
                }
                String upStr = str.toUpperCase();
                sts = upStr.endsWith(this.m_matchPart);
                break;
            }
            case 3: {
                if (this.isCaseSensitive()) {
                    sts = str.startsWith(this.m_matchPart);
                    break;
                }
                String upStr = str.toUpperCase();
                sts = upStr.startsWith(this.m_matchPart);
                break;
            }
            case 4: {
                if (this.isCaseSensitive()) {
                    sts = this.matchComplexWildcard(str);
                    break;
                }
                String upStr = str.toUpperCase();
                sts = this.matchComplexWildcard(upStr);
                break;
            }
            case 0: {
                if (this.isCaseSensitive()) {
                    if (str.compareTo(this.m_pattern) != 0) break;
                    sts = true;
                    break;
                }
                if (!str.equalsIgnoreCase(this.m_pattern)) break;
                sts = true;
            }
        }
        return sts;
    }

    protected final boolean matchComplexWildcard(String str) {
        char[] strChars = str.toCharArray();
        int wpos = 0;
        int wlen = this.m_patternChars.length;
        int spos = 0;
        int slen = strChars.length;
        boolean matchFailed = false;
        block4: while (!matchFailed && wpos < this.m_patternChars.length) {
            char patChar = this.m_patternChars[wpos++];
            switch (patChar) {
                case '?': {
                    if (spos < slen) {
                        ++spos;
                        continue block4;
                    }
                    matchFailed = true;
                    continue block4;
                }
                case '*': {
                    if (wpos < wlen) {
                        patChar = this.m_patternChars[wpos];
                        if (patChar == '?' || patChar == '*') continue block4;
                        while (spos < slen && strChars[spos] != patChar) {
                            ++spos;
                        }
                        if (spos < slen) continue block4;
                        matchFailed = true;
                        continue block4;
                    }
                    spos = slen;
                    continue block4;
                }
            }
            if (spos >= slen || strChars[spos] != patChar) {
                matchFailed = true;
                continue;
            }
            ++spos;
        }
        return !matchFailed && spos == slen;
    }

    public final void setPattern(String pattern, boolean caseSensitive) {
        this.m_pattern = pattern;
        this.m_caseSensitive = caseSensitive;
        this.setType(-1);
        if (pattern == null || pattern.length() == 0) {
            return;
        }
        if (pattern.compareTo("*.*") == 0 || pattern.compareTo("*") == 0) {
            this.setType(1);
            return;
        }
        if (pattern.startsWith("*.")) {
            this.m_matchPart = pattern.length() > 2 ? pattern.substring(1) : "";
            if (!this.isCaseSensitive()) {
                this.m_matchPart = this.m_matchPart.toUpperCase();
            }
            if (!WildCard.containsWildcards(this.m_matchPart)) {
                this.setType(2);
                return;
            }
        }
        if (pattern.endsWith(".*")) {
            this.m_matchPart = pattern.length() > 2 ? pattern.substring(0, pattern.length() - 2) : "";
            if (!this.isCaseSensitive()) {
                this.m_matchPart = this.m_matchPart.toUpperCase();
            }
            if (!WildCard.containsWildcards(this.m_matchPart)) {
                this.setType(3);
                return;
            }
        }
        this.m_patternChars = !this.isCaseSensitive() ? this.m_pattern.toUpperCase().toCharArray() : this.m_pattern.toCharArray();
        this.setType(4);
    }

    private final void setType(int typ) {
        this.m_type = typ;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPattern());
        str.append(",");
        str.append(this.isType());
        str.append(",");
        if (this.m_matchPart != null) {
            str.append(this.m_matchPart);
        }
        if (this.isCaseSensitive()) {
            str.append(",Case");
        } else {
            str.append(",NoCase");
        }
        str.append("]");
        return str.toString();
    }

    public static final boolean containsWildcards(String str) {
        if (str.indexOf(42) != -1) {
            return true;
        }
        return str.indexOf(63) != -1;
    }

    public static final boolean containsUnicodeWildcard(String str) {
        return str.indexOf(62) != -1 || str.indexOf(60) != -1 || str.indexOf(34) != -1;
    }

    public static final String convertUnicodeWildcardToDOS(String str) {
        StringBuffer newStr = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char nextCh;
            int ch = str.charAt(i);
            if (ch == 62) {
                ch = 63;
            } else if (ch == 60) {
                if (i < str.length() - 1 && str.charAt(i + 1) == '.') {
                    ch = 42;
                }
            } else if (ch == 34 && i < str.length() - 1 && ((nextCh = str.charAt(i + 1)) == '?' || nextCh == '*' || nextCh == '>')) {
                ch = 46;
            }
            newStr.append((char)ch);
        }
        return newStr.toString();
    }

    public static final String convertToRegexp(String path) {
        char[] smbPattern = path.toCharArray();
        boolean endsWithQ = smbPattern[smbPattern.length - 1] == '?';
        StringBuffer sb = new StringBuffer();
        sb.append('^');
        block5: for (int i = 0; i < smbPattern.length; ++i) {
            switch (smbPattern[i]) {
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    if (endsWithQ) {
                        boolean restQ = true;
                        for (int j = i + 1; j < smbPattern.length; ++j) {
                            if (smbPattern[j] == '?') continue;
                            restQ = false;
                            break;
                        }
                        if (restQ) {
                            sb.append(".?");
                            continue block5;
                        }
                        sb.append('.');
                        continue block5;
                    }
                    sb.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    sb.append('\\');
                    sb.append(smbPattern[i]);
                    continue block5;
                }
                default: {
                    sb.append(smbPattern[i]);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

