/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.IOException;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;

abstract class ProtocolHandler {
    protected SMBSrvSession m_sess;

    protected ProtocolHandler() {
    }

    protected ProtocolHandler(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    public abstract String getName();

    public abstract boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException;

    protected final SMBSrvSession getSession() {
        return this.m_sess;
    }

    protected final void setSession(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    protected final boolean hasChainedCommand(SMBSrvPacket pkt) {
        int cmd = pkt.getCommand();
        if (cmd == 115 || cmd == 117 || cmd == 45 || cmd == 47 || cmd == 46 || cmd == 116 || cmd == 36 || cmd == 162) {
            return pkt.hasAndXCommand();
        }
        return false;
    }
}

