/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.GroupImpl;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;

public class GroupHandlerImpl
extends CommonHandler
implements GroupHandler {
    public static final String EXO_DESCRIPTION = "exo:description";
    public static final String EXO_GROUP_ID = "exo:groupId";
    public static final String EXO_PARENT_ID = "exo:parentId";
    public static final String EXO_LABEL = "exo:label";
    public static final String STORAGE_EXO_GROUPS = "exo:groups";
    protected final List<GroupEventListener> listeners = new ArrayList<GroupEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.GroupHandlerImpl");

    GroupHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.addChild(session, parent, child, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void addChild(Session session, Group parent, Group child, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addChild started");
        }
        try {
            String parentId = parent == null ? "" : parent.getId();
            String parentPath = this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + parentId;
            Node parentNode = (Node)session.getItem(parentPath);
            Node gNode = parentNode.addNode(child.getGroupName(), "exo:hierarchyGroup");
            GroupImpl group = new GroupImpl(child.getGroupName(), parentId, gNode.getUUID());
            group.setDescription(child.getDescription());
            group.setLabel(child.getLabel() != null ? child.getLabel() : child.getGroupName());
            if (broadcast) {
                this.preSave(child, true);
            }
            this.writeObjectToNode(group, gNode);
            session.save();
            if (broadcast) {
                this.postSave(child, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not add child group with groupId '" + child.getId() + "'", e);
        }
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners.add(listener);
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createGroup method");
        }
        this.addChild(null, group, broadcast);
    }

    public Group createGroupInstance() {
        return new GroupImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findGroupById(String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Group group = this.findGroupById(session, groupId);
            return group;
        }
        finally {
            session.logout();
        }
    }

    Group findGroupById(Session session, String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupById started");
        }
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + groupId);
            return this.readObjectFromNode(gNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group by groupId '" + groupId + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findGroupByMembership(session, userName, membershipType);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findGroupByMembership(Session session, String userName, String membershipType) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupByMembership started");
        }
        try {
            ArrayList<Group> types = new ArrayList<Group>();
            Node user = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + userName);
            NodeIterator memberships = user.getNodes("exo:membership");
            block2: while (memberships.hasNext()) {
                Node membership = memberships.nextNode();
                if (membershipType != null && !membershipType.equals(membership.getProperty("exo:membershipType").getNode().getName())) continue;
                Node group = membership.getProperty("exo:group").getNode();
                for (Group eg : types) {
                    if (!eg.getId().equals(this.readStringProperty(group, EXO_GROUP_ID))) continue;
                    continue block2;
                }
                types.add(this.readObjectFromNode(group));
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find groups", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findGroups(Group parent) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findGroups(session, parent);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findGroups(Session session, Group parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroups started");
        }
        ArrayList<Group> types = new ArrayList<Group>();
        try {
            String gPath = this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS;
            String parentId = parent == null ? "" : parent.getId();
            Node parentNode = (Node)session.getItem(gPath + parentId);
            NodeIterator gNodes = parentNode.getNodes();
            while (gNodes.hasNext()) {
                types.add(this.readObjectFromNode(gNodes.nextNode()));
            }
            return types;
        }
        catch (PathNotFoundException e) {
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find groups", e);
        }
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupsOfUser started");
        }
        return this.findGroupByMembership(user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllGroups() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.getAllGroups(session);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection getAllGroups(Session session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups started");
        }
        try {
            ArrayList<Group> types = new ArrayList<Group>();
            String statement = "select * from exo:group";
            Query query = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult res = query.execute();
            NodeIterator gNodes = res.getNodes();
            while (gNodes.hasNext()) {
                types.add(this.readObjectFromNode(gNodes.nextNode()));
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get all groups ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Group group2 = this.removeGroup(session, group, broadcast);
            return group2;
        }
        finally {
            session.logout();
        }
    }

    private Group removeGroup(Session session, Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeGroup started");
        }
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + group.getId());
            NodeIterator gNodes = gNode.getNodes();
            while (gNodes.hasNext()) {
                this.removeGroup(session, this.readObjectFromNode(gNodes.nextNode()), true);
            }
            String mStatement = "select * from exo:userMembership where exo:group='" + gNode.getUUID() + "'";
            Query mQuery = session.getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                ((MembershipHandlerImpl)this.service.getMembershipHandler()).removeMembership(session, mNode.getUUID(), broadcast);
            }
            Group g = this.readObjectFromNode(gNode);
            if (broadcast) {
                this.preDelete(group);
            }
            gNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(group);
            }
            return g;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove group with groupId '" + group.getId() + "'", e);
        }
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGroup(Group group, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveGroup(session, group, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveGroup(Session session, Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"saveGroup started");
        }
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + group.getId());
            if (broadcast) {
                this.preSave(group, false);
            }
            this.writeObjectToNode(group, gNode);
            session.save();
            if (broadcast) {
                this.postSave(group, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save group '" + group.getId() + "'", e);
        }
    }

    private Group readObjectFromNode(Node node) throws Exception {
        try {
            String groupId = this.readStringProperty(node, EXO_GROUP_ID);
            GroupImpl group = new GroupImpl(node.getName(), groupId.substring(0, groupId.lastIndexOf(47)), node.getUUID());
            group.setDescription(this.readStringProperty(node, EXO_DESCRIPTION));
            group.setLabel(this.readStringProperty(node, EXO_LABEL));
            return group;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read node properties", e);
        }
    }

    private void writeObjectToNode(Group group, Node node) throws Exception {
        try {
            node.setProperty(EXO_LABEL, group.getLabel());
            node.setProperty(EXO_DESCRIPTION, group.getDescription());
            node.setProperty(EXO_GROUP_ID, group.getId());
            node.setProperty(EXO_PARENT_ID, group.getParentId());
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write node properties", e);
        }
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postDelete(group);
        }
    }
}

