/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Date;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

@URITemplate(value="/maven2/")
public class RESTArtifactLoaderService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.ext.RESTArtifactLoaderService");
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private NodeRepresentationService nodeRepresentationService;
    private Session session;
    private String mavenRoot;
    private String repository;
    private String workspace;
    private ThreadLocalSessionProviderService sessionProviderService;
    private RepositoryService repositoryService;

    public RESTArtifactLoaderService(InitParams initParams, ThreadLocalSessionProviderService sessionProviderService, RepositoryService repositoryService, NodeRepresentationService nodeRepresentationService, Authenticator authenticator) throws Exception {
        PropertiesParam props = initParams.getPropertiesParam("artifact.workspace");
        if (props == null) {
            throw new IllegalArgumentException("Properties-param 'artifact.workspace' expected.");
        }
        this.nodeRepresentationService = nodeRepresentationService;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.repository = props.getProperty("repository");
        this.workspace = props.getProperty("workspace");
        this.mavenRoot = props.getProperty("mavenRoot");
        if (this.mavenRoot.startsWith("/")) {
            this.mavenRoot = this.mavenRoot.substring(1);
        }
        if (!this.mavenRoot.endsWith("/")) {
            this.mavenRoot = this.mavenRoot + "/";
        }
        String username = props.getProperty("username");
        String password = props.getProperty("password");
        if (username != null && password != null) {
            String userId = authenticator.validateUser(new Credential[]{new UsernameCredential(username), new PasswordCredential(password)});
            SessionProvider sessionProvider = new SessionProvider(new ConversationState(authenticator.createIdentity(userId)));
            this.session = sessionProvider.getSession(this.workspace, this.repositoryService.getRepository(this.repository));
        } else {
            LOG.info((Object)"Default username and password for access to JCR storage were not specified.");
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/{path}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getResource(@URIParam(value="path") String mavenPath, @ContextParam(value="baseURI") String base, @QueryParam(value="view") String view, @QueryParam(value="gadget") String gadget) {
        String resourcePath = this.mavenRoot + mavenPath;
        String shaResourcePath = mavenPath.endsWith(".sha1") ? this.mavenRoot + mavenPath : this.mavenRoot + mavenPath + ".sha1";
        mavenPath = base + this.getClass().getAnnotation(URITemplate.class).value() + mavenPath;
        Session ses = null;
        try {
            ses = this.getSession(this.sessionProviderService.getSessionProvider(null));
            if (ses == null) {
                throw new RepositoryException("Access to JCR Repository denied. SessionProvider is null and prepared session is null.");
            }
            ExtendedNode node = (ExtendedNode)ses.getRootNode().getNode(resourcePath);
            if (RESTArtifactLoaderService.isFile((Node)node)) {
                if (view != null && view.equalsIgnoreCase("true")) {
                    ExtendedNode shaNode = null;
                    try {
                        shaNode = (ExtendedNode)ses.getRootNode().getNode(shaResourcePath);
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                    return this.getArtifactInfo((Node)node, mavenPath, gadget, (Node)shaNode);
                }
                return this.downloadArtifact((Node)node);
            }
            return this.browseRepository((Node)node, mavenPath, gadget);
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("File not found " + mavenPath));
            }
            LOG.info((Object)("File not found " + mavenPath));
            return Response.Builder.notFound().errorMessage(e.getMessage()).mediaType("text/plain").build();
        }
        catch (AccessDeniedException e) {
            if (ses.getUserID().equals(SystemIdentity.ANONIM)) {
                return Response.Builder.withStatus((int)401).header("WWW-Authenticate", "Basic realm=\"exo-domain\"").build();
            }
            return Response.Builder.forbidden().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).mediaType("text/plain").build();
        }
    }

    @HTTPMethod(value="GET")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getRootNodeList(@ContextParam(value="baseURI") String base, @QueryParam(value="view") String view, @QueryParam(value="gadget") String gadget) {
        return this.getResource("", base, view, gadget);
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        if (sessionProvider == null) {
            return this.session;
        }
        return sessionProvider.getSession(this.workspace, this.repositoryService.getRepository(this.repository));
    }

    private static boolean isFile(Node node) throws RepositoryException {
        if (!node.isNodeType("nt:file")) {
            return false;
        }
        return node.getNode("jcr:content").isNodeType("nt:resource");
    }

    private Response browseRepository(final Node node, final String mavenPath, final String gadget) throws IOException {
        final PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
                    XMLStreamWriter xsw = factory.createXMLStreamWriter(po, "UTF-8");
                    xsw.writeStartDocument("UTF-8", "1.0");
                    xsw.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
                    xsw.writeCharacters("\n");
                    if (gadget == null || !gadget.equalsIgnoreCase("true")) {
                        xsw.writeStartElement("html");
                        xsw.writeDefaultNamespace(RESTArtifactLoaderService.XHTML_NS);
                        xsw.writeStartElement("head");
                        xsw.writeStartElement("style");
                        xsw.writeAttribute("type", "text/css");
                        xsw.writeCharacters("a {text-decoration: none; color: #10409C; }a:hover {text-decoration: underline;}.centered { text-align: center; }.underlined { border-bottom : 1px solid #cccccc;  font-weight: bold;  text-align: center; }\n");
                        xsw.writeEndElement();
                        xsw.writeStartElement("title");
                        xsw.writeCharacters("Maven2 Repository Browser");
                        xsw.writeEndElement();
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("body");
                    xsw.writeStartElement("h2");
                    xsw.writeAttribute("class", "centered");
                    xsw.writeCharacters("Maven2 Repository");
                    xsw.writeEndElement();
                    xsw.writeStartElement("table");
                    xsw.writeAttribute("width", "90%");
                    xsw.writeAttribute("style", "table-layout:fixed;");
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "7%");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeCharacters("name");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "18%");
                    xsw.writeCharacters("media-type");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "15%");
                    xsw.writeCharacters("size");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "underlined");
                    xsw.writeAttribute("width", "18%");
                    xsw.writeCharacters("last modified");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    String parent = mavenPath.substring(0, mavenPath.lastIndexOf(47));
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("class", "parenticon");
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", parent + "?view=true&gadget=" + gadget);
                    xsw.writeCharacters("..");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeEmptyElement("td");
                    xsw.writeEmptyElement("td");
                    xsw.writeEmptyElement("td");
                    NodeIterator iterator = node.getNodes();
                    while (iterator.hasNext()) {
                        Node node2 = iterator.nextNode();
                        xsw.writeStartElement("tr");
                        if (RESTArtifactLoaderService.isFile(node2)) {
                            if (node2.getName().endsWith("sha1")) continue;
                            NodeRepresentation nodeRepresentation = RESTArtifactLoaderService.this.nodeRepresentationService.getNodeRepresentation(node2, null);
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "fileicon");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeStartElement("a");
                            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath + node2.getName() : mavenPath + "/" + node2.getName()) + "?view=true&gadget=" + gadget);
                            xsw.writeCharacters(node2.getName());
                            xsw.writeEndElement();
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters(nodeRepresentation.getMediaType());
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("" + nodeRepresentation.getContentLenght());
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters(new Date(nodeRepresentation.getLastModified()).toString());
                            xsw.writeEndElement();
                        } else {
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "foldericon");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeStartElement("a");
                            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath + node2.getName() : mavenPath + "/" + node2.getName()) + "?view=true&gadget=" + gadget);
                            xsw.writeCharacters(node2.getName());
                            xsw.writeEndElement();
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                            xsw.writeStartElement("td");
                            xsw.writeAttribute("class", "centered");
                            xsw.writeCharacters("-");
                            xsw.writeEndElement();
                        }
                        xsw.writeEndElement();
                    }
                    xsw.writeStartElement("tr");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    if (gadget == null || !gadget.equalsIgnoreCase("true")) {
                        xsw.writeEndElement();
                    }
                    xsw.writeEndDocument();
                }
                catch (XMLStreamException xmle) {
                    xmle.printStackTrace();
                }
                catch (RepositoryException re) {
                    re.printStackTrace();
                }
                finally {
                    try {
                        po.flush();
                        po.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        return Response.Builder.ok().entity((Object)pi, "text/html").build();
    }

    private Response downloadArtifact(Node node) throws Exception {
        NodeRepresentation nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(node, null);
        if (node.canAddMixin("exo:mavencounter")) {
            node.addMixin("exo:mavencounter");
            node.getSession().save();
        }
        node.setProperty("exo:downloadcounter", node.getProperty("exo:downloadcounter").getLong() + 1L);
        node.getSession().save();
        long lastModified = nodeRepresentation.getLastModified();
        String contentType = nodeRepresentation.getMediaType();
        long contentLength = nodeRepresentation.getContentLenght();
        InputStream entity = nodeRepresentation.getInputStream();
        Response response = Response.Builder.ok().contentLenght(contentLength).lastModified(new Date(lastModified)).entity((Object)entity, contentType).header("Content-Disposition", "attachment; filename=" + node.getName()).transformer((OutputEntityTransformer)new PassthroughOutputTransformer()).build();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getArtifactInfo(Node node, String mavenPath, String gadget, Node shaNode) throws Exception {
        NodeRepresentation nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(node, null);
        NodeRepresentation shNodeRepresentation = null;
        if (shaNode != null) {
            shNodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(shaNode, null);
        }
        PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        long lastModified = nodeRepresentation.getLastModified();
        long contentLength = nodeRepresentation.getContentLenght();
        try {
            if (node.canAddMixin("exo:mavencounter")) {
                node.addMixin("exo:mavencounter");
                node.getSession().save();
            }
            int count = (int)node.getProperty("exo:downloadcounter").getLong();
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(po, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            xsw.writeCharacters("\n");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace(XHTML_NS);
            xsw.writeStartElement("head");
            xsw.writeStartElement("style");
            xsw.writeAttribute("type", "text/css");
            xsw.writeCharacters("a {text-decoration: none; color: #10409C;}a:hover {text-decoration: underline;}.centered { text-align: center; }.underlined { border-bottom : 1px solid #cccccc; }\n");
            xsw.writeEndElement();
            xsw.writeStartElement("title");
            xsw.writeCharacters("Maven2 Artifact Information");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("b");
            xsw.writeCharacters("Artifact Information :");
            xsw.writeEndElement();
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Name:  " + node.getName());
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Size:  " + contentLength);
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Last modified:  " + new Date(lastModified).toString());
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Download:  ");
            xsw.writeStartElement("a");
            xsw.writeAttribute("href", mavenPath.endsWith("/") ? mavenPath.substring(0, mavenPath.length() - 1) : mavenPath);
            xsw.writeCharacters("Link");
            xsw.writeEndElement();
            if (shNodeRepresentation != null) {
                xsw.writeEmptyElement("br");
                xsw.writeCharacters("Checksum:  " + this.getStreamAsString(shNodeRepresentation.getInputStream()));
                xsw.writeEmptyElement("br");
            }
            xsw.writeEmptyElement("br");
            xsw.writeCharacters("Downloads count :  " + count);
            xsw.writeEmptyElement("br");
            xsw.writeEmptyElement("br");
            xsw.writeStartElement("a");
            xsw.writeAttribute("href", (mavenPath.endsWith("/") ? mavenPath.substring(0, mavenPath.length() - 1).substring(0, mavenPath.lastIndexOf("/")) : mavenPath.substring(0, mavenPath.lastIndexOf("/"))) + "?view=true&gadget=" + gadget);
            xsw.writeCharacters("Back to browsing");
            xsw.writeEndElement();
            xsw.writeEmptyElement("br");
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            xmle.printStackTrace();
        }
        catch (RepositoryException re) {
            re.printStackTrace();
        }
        finally {
            try {
                po.flush();
                po.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Response.Builder.ok().entity((Object)pi, "text/html").build();
    }

    protected String getStreamAsString(InputStream stream) throws IOException {
        byte[] buff = new byte[stream.available()];
        stream.read(buff);
        return new String(buff);
    }
}

