/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.FileDescriptor;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PendingBinaryFile;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.recovery.FileNameFactory;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryReader;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryWriter;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoverySynchronizer {
    private static Log log = ExoLogger.getLogger((String)"ext.RecoverySynchronizer");
    private File recoveryDir;
    private FileNameFactory fileNameFactory;
    private FileCleaner fileCleaner;
    private ChannelManager channelManager;
    private String ownName;
    private String systemId;
    private RecoveryReader recoveryReader;
    private RecoveryWriter recoveryWriter;
    private HashMap<String, PendingBinaryFile> mapPendingBinaryFile;
    private ItemDataKeeper dataKeeper;
    private List<String> initedParticipantsClusterList;
    private List<String> successfulSynchronizedList;
    private volatile boolean localSynchronization = false;

    public RecoverySynchronizer(File recoveryDir, FileNameFactory fileNameFactory, FileCleaner fileCleaner, ChannelManager channelManager, String ownName, RecoveryWriter recoveryWriter, RecoveryReader recoveryReader, String systemId) {
        this.recoveryDir = recoveryDir;
        this.fileNameFactory = fileNameFactory;
        this.fileCleaner = fileCleaner;
        this.channelManager = channelManager;
        this.ownName = ownName;
        this.systemId = systemId;
        this.recoveryReader = recoveryReader;
        this.recoveryWriter = recoveryWriter;
        this.mapPendingBinaryFile = new HashMap();
        this.successfulSynchronizedList = new ArrayList<String>();
        this.initedParticipantsClusterList = new ArrayList<String>();
    }

    public void synchronizRepository() {
        try {
            if (this.localSynchronization) {
                log.info((Object)"Synchronization init...");
                Packet packet = new Packet(14, IdGenerator.generate(), this.ownName, Calendar.getInstance());
                this.channelManager.sendPacket(packet);
            }
        }
        catch (Exception e) {
            log.error((Object)"Synchronization error", (Throwable)e);
        }
    }

    private void send(Packet packet) throws Exception {
        byte[] buffer = Packet.getAsByteArray(packet);
        if (buffer.length <= 16384) {
            this.channelManager.send(buffer);
        } else {
            this.channelManager.sendBigPacket(buffer, packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processingPacket(Packet packet, int status) throws Exception {
        int stat = status;
        switch (packet.getPacketType()) {
            case 14: {
                this.sendChangesLogUpDate(packet.getTimeStamp(), packet.getOwnerName(), packet.getIdentifier());
                break;
            }
            case 15: {
                PendingBinaryFile container;
                if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) {
                    this.mapPendingBinaryFile.put(packet.getIdentifier(), new PendingBinaryFile());
                }
                PendingBinaryFile pendingBinaryFile = container = this.mapPendingBinaryFile.get(packet.getIdentifier());
                synchronized (pendingBinaryFile) {
                    container.addBinaryFile(packet.getOwnerName(), packet.getFileName(), packet.getSystemId());
                    break;
                }
            }
            case 16: {
                if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) break;
                PendingBinaryFile container = this.mapPendingBinaryFile.get(packet.getIdentifier());
                RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getOwnerName(), packet.getFileName());
                if (randomAccessFile != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Offset : BinaryFile_Middle_Packet :" + packet.getOffset()));
                    }
                    randomAccessFile.seek(packet.getOffset());
                    randomAccessFile.write(packet.getByteArray());
                    break;
                }
                log.warn((Object)("Can't find the RandomAccessFile : \nowner - \t" + packet.getOwnerName() + "\nfile name - \t" + packet.getFileName()));
                break;
            }
            case 17: {
                if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) break;
                PendingBinaryFile container = this.mapPendingBinaryFile.get(packet.getIdentifier());
                RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getOwnerName(), packet.getFileName());
                if (randomAccessFile != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Offset : BinaryFile_Last_Packet :" + packet.getOffset()));
                    }
                    randomAccessFile.seek(packet.getOffset());
                    randomAccessFile.write(packet.getByteArray());
                    randomAccessFile.close();
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Last packet of file has been received : " + packet.getFileName()));
                    break;
                }
                log.warn((Object)("Can't find the RandomAccessFile : \nowner - \t" + packet.getOwnerName() + "\nfile name - \t" + packet.getFileName()));
                break;
            }
            case 18: {
                if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) break;
                PendingBinaryFile pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                pbf.addToSuccessfulTransferCounter(packet.getSize());
                if (!pbf.isSuccessfulTransfer()) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The signal ALL_BinaryFile_transferred_OK has been received  from " + packet.getOwnerName()));
                }
                List<FileDescriptor> fileDescriptorList = pbf.getSortedFilesDescriptorList();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fileDescriptorList.size() == pbf.getNeedTransferCounter() : " + fileDescriptorList.size() + "== " + pbf.getNeedTransferCounter()));
                }
                if ((long)fileDescriptorList.size() == pbf.getNeedTransferCounter()) {
                    ArrayList<String> failList = new ArrayList<String>();
                    for (FileDescriptor fileDescriptor : fileDescriptorList) {
                        try {
                            TransactionChangesLog transactionChangesLog = this.recoveryReader.getChangesLog(fileDescriptor.getFile().getAbsolutePath());
                            transactionChangesLog.setSystemId(fileDescriptor.getSystemId());
                            Calendar cLogTime = this.fileNameFactory.getDateFromFileName(fileDescriptor.getFile().getName());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Save to JCR : " + fileDescriptor.getFile().getAbsolutePath()));
                                log.debug((Object)("SystemID : " + transactionChangesLog.getSystemId()));
                                log.debug((Object)("list size : " + fileDescriptorList.size()));
                            }
                            if (log.isDebugEnabled()) {
                                ChangesLogIterator logIterator = transactionChangesLog.getLogIterator();
                                while (logIterator.hasNextLog()) {
                                    PlainChangesLog pcl = logIterator.nextLog();
                                    log.debug((Object)pcl.dump());
                                }
                            }
                            this.saveChangesLog(this.dataKeeper, transactionChangesLog, cLogTime);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("After save message: the owner systemId --> " + transactionChangesLog.getSystemId()));
                            log.debug((Object)("After save message: --> " + this.systemId));
                        }
                        catch (Exception e) {
                            failList.add(fileDescriptor.getFile().getName());
                            log.error((Object)"Can't save to JCR ", (Throwable)e);
                        }
                    }
                    ArrayList<String> fileNameList = new ArrayList<String>(this.mapPendingBinaryFile.get(packet.getIdentifier()).getFileNameList());
                    if (failList.size() != 0) {
                        fileNameList.removeAll(failList);
                    }
                    Packet packetFileNameList = new Packet(19, packet.getIdentifier(), this.ownName, fileNameList);
                    this.send(packetFileNameList);
                    log.info((Object)("The " + fileDescriptorList.size() + " changeslogs were received and " + fileNameList.size() + " saved"));
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Do not start save : " + fileDescriptorList.size() + " of " + pbf.getNeedTransferCounter()));
                break;
            }
            case 19: {
                long removeCounter = this.recoveryWriter.removeChangesLog(packet.getFileNameList(), packet.getOwnerName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove from file system : " + removeCounter));
                }
                Packet removedOldChangesLogPacket = new Packet(25, packet.getIdentifier(), this.ownName);
                removedOldChangesLogPacket.setSize(removeCounter);
                this.channelManager.sendPacket(removedOldChangesLogPacket);
                break;
            }
            case 25: {
                if (this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) {
                    PendingBinaryFile pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                    pbf.setRemovedOldChangesLogCounter(pbf.getRemovedOldChangesLogCounter() + packet.getSize());
                    if (!pbf.isAllOldChangesLogsRemoved()) break;
                    for (FileDescriptor fd : pbf.getSortedFilesDescriptorList()) {
                        this.fileCleaner.addFile(fd.getFile());
                    }
                    this.mapPendingBinaryFile.remove(packet.getIdentifier());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Next iteration of recovery ...");
                    }
                    this.synchronizRepository();
                    break;
                }
                log.warn((Object)("Can not find the PendingBinaryFile whith id: " + packet.getIdentifier()));
                break;
            }
            case 24: {
                if (!this.mapPendingBinaryFile.containsKey(packet.getIdentifier())) {
                    this.mapPendingBinaryFile.put(packet.getIdentifier(), new PendingBinaryFile());
                }
                PendingBinaryFile pbf = this.mapPendingBinaryFile.get(packet.getIdentifier());
                pbf.setNeedTransferCounter(pbf.getNeedTransferCounter() + packet.getSize());
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("NeedTransferCounter : " + pbf.getNeedTransferCounter()));
                break;
            }
            case 20: {
                if (!this.successfulSynchronizedList.contains(packet.getOwnerName())) {
                    this.successfulSynchronizedList.add(packet.getOwnerName());
                }
                if (this.successfulSynchronizedList.size() == this.initedParticipantsClusterList.size()) {
                    stat = 0;
                }
                this.localSynchronization = false;
                break;
            }
        }
        return stat;
    }

    private void sendChangesLogUpDate(Calendar timeStamp, String ownerName, String identifier) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("+++ sendChangesLogUpDate() +++ : " + Calendar.getInstance().getTime().toGMTString()));
            }
            List<String> filePathList = this.recoveryReader.getFilePathList(timeStamp, ownerName);
            Packet needTransferCounter = new Packet(24, identifier, this.ownName);
            needTransferCounter.setSize(filePathList.size());
            this.channelManager.sendPacket(needTransferCounter);
            if (filePathList.size() > 0) {
                for (String filePath : filePathList) {
                    this.channelManager.sendBinaryFile(filePath, ownerName, identifier, this.systemId, 15, 16, 17);
                }
                Packet endPocket = new Packet(18, identifier);
                endPocket.setOwnName(ownerName);
                endPocket.setSize(filePathList.size());
                this.channelManager.sendPacket(endPocket);
            } else {
                Packet synchronizedOKPacket = new Packet(20, IdGenerator.generate(), ownerName);
                this.channelManager.sendPacket(synchronizedOKPacket);
            }
        }
        catch (Exception e) {
            log.error((Object)"ChangesLogs was send with error", (Throwable)e);
        }
    }

    public void setDataKeeper(ItemDataKeeper dataKeeper) {
        this.dataKeeper = dataKeeper;
    }

    public void updateInitedParticipantsClusterList(Collection<? extends String> list) {
        this.initedParticipantsClusterList = new ArrayList<String>(list);
    }

    private void saveChangesLog(ItemDataKeeper dataManager, TransactionChangesLog changesLog, Calendar cLogTime) throws ReplicationException {
        try {
            try {
                dataManager.save((ItemStateChangesLog)changesLog);
            }
            catch (JCRInvalidItemStateException e) {
                TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
                if (normalizeChangesLog != null) {
                    this.saveChangesLog(dataManager, normalizeChangesLog, cLogTime);
                }
            }
        }
        catch (Throwable t) {
            throw new ReplicationException("Save error. Log time " + cLogTime.getTime(), t);
        }
    }

    private TransactionChangesLog getNormalizedChangesLog(String collisionID, int state, TransactionChangesLog changesLog) {
        ItemState citem = changesLog.getItemState(collisionID);
        if (citem != null) {
            TransactionChangesLog result = new TransactionChangesLog();
            result.setSystemId(changesLog.getSystemId());
            ChangesLogIterator cli = changesLog.getLogIterator();
            while (cli.hasNextLog()) {
                ArrayList<ItemState> normalized = new ArrayList<ItemState>();
                PlainChangesLog next = cli.nextLog();
                for (ItemState change : next.getAllStates()) {
                    if (state == change.getState()) {
                        ItemData item = change.getData();
                        if (citem.isNode()) {
                            if (item.getIdentifier().equals(collisionID) || item.getQPath().isDescendantOf(citem.getData().getQPath())) continue;
                            normalized.add(change);
                            continue;
                        }
                        if (item.getIdentifier().equals(collisionID)) continue;
                        normalized.add(change);
                        continue;
                    }
                    normalized.add(change);
                }
                PlainChangesLogImpl plog = new PlainChangesLogImpl(normalized, next.getSessionId(), next.getEventType());
                result.addLog((PlainChangesLog)plog);
            }
            return result;
        }
        return null;
    }

    public void localSynchronization() {
        this.localSynchronization = true;
    }
}

