/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.artifact.ArtifactDescriptor;
import org.exoplatform.services.jcr.ext.artifact.ArtifactManagingException;
import org.exoplatform.services.jcr.ext.artifact.ArtifactManagingService;
import org.exoplatform.services.jcr.ext.artifact.DefaultFileFilter;
import org.exoplatform.services.jcr.ext.artifact.Descriptor;
import org.exoplatform.services.jcr.ext.artifact.FolderDescriptor;
import org.exoplatform.services.jcr.ext.artifact.SearchCriteria;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactManagingServiceImpl
implements ArtifactManagingService,
Startable {
    private static final int BUFFER = 4096;
    private static final String STRING_TERMINATOR = "*";
    private static final String NT_FILE = "artifact-nodetypes.xml";
    private static final String SERVICE_NAME = "ArtifactManaging";
    private RepositoryService repositoryService;
    private RegistryService registryService;
    private InitParams initParams;
    private SessionProvider sessionProvider;
    private String repoWorkspaceName;
    private String rootNodePath;
    private static Log LOGGER = ExoLogger.getLogger(ArtifactManagingServiceImpl.class);
    private Map<String, String> mimeMap = new Hashtable<String, String>();

    public ArtifactManagingServiceImpl(InitParams initParams, RepositoryService repositoryService, RegistryService registryService) throws RepositoryConfigurationException {
        this.repositoryService = repositoryService;
        this.registryService = registryService;
        if (initParams == null) {
            throw new RepositoryConfigurationException("Init parameters expected !!!");
        }
        this.initParams = initParams;
        this.setDefaultMimes();
    }

    public ArtifactManagingServiceImpl(InitParams params, RepositoryService repositoryService) throws RepositoryConfigurationException {
        this(params, repositoryService, null);
    }

    @Override
    public void addArtifact(SessionProvider sp, ArtifactDescriptor artifact, InputStream jarIStream, InputStream pomIStream) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node rootNode = (Node)session.getItem(this.rootNodePath);
        Node groupId_tail = this.createGroupIdLayout(rootNode, artifact);
        Node artifactId_node = this.createArtifactIdLayout(groupId_tail, artifact);
        Node version_node = this.createVersionLayout(artifactId_node, artifact);
        if (version_node != null) {
            this.importResource(version_node, jarIStream, "jar", artifact);
            this.importResource(version_node, pomIStream, "pom", artifact);
        }
        session.save();
    }

    @Override
    public void exportArtifacts(SessionProvider sp, FolderDescriptor parentFolder, OutputStream out) throws RepositoryException, FileNotFoundException {
        Session session = this.currentSession(sp);
        Node parentNode = this.rootNodePath.length() > 1 ? (Node)session.getItem(this.rootNodePath + "/" + parentFolder.getAsPath()) : (Node)session.getItem("/" + parentFolder.getAsPath());
        LOGGER.info((Object)"Write repository to zipped stream");
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(out, 4096));
        try {
            this.mapRepositoryToZipStream(parentNode, zout);
            zout.flush();
            zout.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot write to zip stream", (Throwable)e);
        }
    }

    @Override
    public void exportArtifacts(SessionProvider sp, FolderDescriptor parentFolder, File destFolder) throws RepositoryException, FileNotFoundException {
        Session session = this.currentSession(sp);
        Node parentNode = this.rootNodePath.length() > 1 ? (Node)session.getItem(this.rootNodePath + "/" + parentFolder.getAsPath()) : (Node)session.getItem("/" + parentFolder.getAsPath());
        this.mapRepositoryToFilefs(parentNode, destFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mapRepositoryToFilefs(Node parentNode, File parentFolder) throws RepositoryException {
        NodeIterator folderIterator = parentNode.getNodes();
        while (folderIterator.hasNext()) {
            Node folder = folderIterator.nextNode();
            if (folder.isNodeType("exo:artifact")) {
                File levelfolder = new File(parentFolder.getAbsoluteFile() + File.separator + folder.getName());
                levelfolder.mkdir();
                this.mapRepositoryToFilefs(folder, levelfolder);
                continue;
            }
            if (!folder.isNodeType("exo:file")) continue;
            File content = new File(parentFolder + File.separator + folder.getName());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(content);
                Node dataNode = folder.getNode("jcr:content");
                Property data = dataNode.getProperty("jcr:data");
                Property lastModified = dataNode.getProperty("jcr:lastModified");
                content.setLastModified(lastModified.getLong());
                IOUtils.copy((InputStream)data.getStream(), (OutputStream)fout);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"!!Can't create content fo file", (Throwable)e);
                IOUtils.closeQuietly((OutputStream)fout);
                continue;
            }
            catch (IOException e2) {
                LOGGER.error((Object)"!!Can't write content fo file", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fout);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fout);
                continue;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
    }

    private void mapRepositoryToZipStream(Node parentNode, ZipOutputStream zout) throws RepositoryException, IOException {
        NodeIterator folderIterator = parentNode.getNodes();
        while (folderIterator.hasNext()) {
            int count;
            ZipEntry entry;
            String entryName;
            Node folder = folderIterator.nextNode();
            if (folder.isNodeType("exo:artifact")) {
                entryName = parentNode.getPath() + File.separator + folder.getName();
                entry = new ZipEntry(entryName + "/");
                zout.putNextEntry(entry);
                this.mapRepositoryToZipStream(folder, zout);
                continue;
            }
            if (!folder.isNodeType("exo:file")) continue;
            entryName = parentNode.getPath() + File.separator + folder.getName();
            entry = new ZipEntry(entryName);
            LOGGER.debug((Object)("Zipping " + entryName));
            Node dataNode = folder.getNode("jcr:content");
            Property data = dataNode.getProperty("jcr:data");
            InputStream in = data.getStream();
            Property lastModified = dataNode.getProperty("jcr:lastModified");
            entry.setTime(lastModified.getLong());
            entry.setSize(in.available());
            zout.putNextEntry(entry);
            byte[] buf = new byte[4096];
            while ((count = in.read(buf, 0, 4096)) != -1) {
                zout.write(buf, 0, count);
            }
            zout.flush();
            in.close();
        }
    }

    @Override
    public List<Descriptor> getDescriptors(SessionProvider sp, FolderDescriptor parentFolder) throws RepositoryException {
        LOGGER.info((Object)("Get child nodes to : " + parentFolder.getAsString()));
        Session session = this.currentSession(sp);
        session.refresh(true);
        Node rootNode = (Node)session.getItem(this.rootNodePath);
        String strPath = parentFolder.getAsString();
        Node targetNode = strPath.equals("/") ? rootNode : rootNode.getNode(strPath.substring(1));
        LOGGER.info((Object)targetNode.getPath());
        NodeType[] a = targetNode.getMixinNodeTypes();
        String mixins = "";
        for (NodeType type : a) {
            mixins = mixins + type.getName() + " ";
        }
        LOGGER.info((Object)("**** Mixins : " + mixins));
        LOGGER.info((Object)("**** Workspace : " + session.getWorkspace().getName()));
        ArrayList<Descriptor> childNodes = new ArrayList<Descriptor>();
        NodeIterator iterator = targetNode.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            if (!node.isNodeType("nt:folder") && !node.isNodeType("nt:file")) continue;
            FolderDescriptor descriptor = new FolderDescriptor(node.getName());
            childNodes.add(descriptor);
        }
        return childNodes.size() == 0 ? null : childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importArtifacts(SessionProvider sp, InputStream in) throws RepositoryException, FileNotFoundException {
        LOGGER.info((Object)"Extract repository to temporary folder");
        String path = System.getProperty("java.io.tmpdir") + File.separator + "maven2";
        File temporaryFolder = new File(this.getUniqueFilename(path));
        if (!temporaryFolder.mkdir()) {
            throw new FileNotFoundException("Cannot create temporary folder");
        }
        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(in));
        try {
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory() && new File(temporaryFolder + File.separator + entry.getName()).mkdir()) continue;
                byte[] data = new byte[4096];
                File file = new File(temporaryFolder + File.separator + entry.getName());
                FileUtils.touch((File)file);
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);
                while ((count = zipIn.read(data, 0, 4096)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot get zip entry from stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipIn);
            IOUtils.closeQuietly((InputStream)in);
        }
        this.importArtifacts(sp, temporaryFolder);
        try {
            FileUtils.deleteDirectory((File)temporaryFolder);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot remove temporary folder", (Throwable)e);
        }
    }

    @Override
    public void importArtifacts(SessionProvider sp, File folder) throws RepositoryException, FileNotFoundException {
        if (!folder.exists()) {
            throw new FileNotFoundException("Source folder expected");
        }
        try {
            this.importFilesToJCR(sp, folder);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Execption during uploading local folder to JCR", (Throwable)e);
        }
    }

    private void importFilesToJCR(SessionProvider sp, File folder) throws Exception {
        for (File file : folder.listFiles(new DefaultFileFilter())) {
            String basename;
            File jarfile;
            String ext;
            if (file.isDirectory()) {
                this.importFilesToJCR(sp, file);
            }
            if (!(ext = FilenameUtils.getExtension((String)file.getAbsolutePath())).equals("pom") || !(jarfile = new File((basename = FilenameUtils.removeExtension((String)file.getAbsolutePath())).concat(".jar"))).exists()) continue;
            ArtifactDescriptor artifact = ArtifactDescriptor.createFromPomfile(file);
            FileInputStream jarIStream = new FileInputStream(jarfile);
            FileInputStream pomIStream = new FileInputStream(file);
            this.addArtifact(sp, artifact, jarIStream, pomIStream);
        }
    }

    @Override
    public void removeArtifact(SessionProvider sp, Descriptor artifact) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node root = (Node)session.getItem(this.rootNodePath);
        String pathToRemove = "";
        pathToRemove = this.rootNodePath.length() > 1 ? this.rootNodePath + "/" + artifact.getAsPath() : "/" + artifact.getAsPath();
        LOGGER.debug((Object)("Remove node: " + pathToRemove));
        Node rmNode = (Node)session.getItem(pathToRemove);
        while (rmNode != root) {
            Node parent = rmNode.getParent();
            rmNode.remove();
            if (parent.hasNodes()) break;
            rmNode = parent;
        }
        session.save();
    }

    @Override
    public List<Descriptor> searchArtifacts(SessionProvider sp, SearchCriteria criteria) throws RepositoryException {
        Session session = this.currentSession(sp);
        session.refresh(true);
        session.save();
        String param = criteria.getContainsExpr();
        String pathConstraint = "";
        pathConstraint = this.rootNodePath.length() > 1 ? this.rootNodePath + "/%/" + param + "[%]" : "/%/" + param + "[%]";
        String sqlQuery = String.format("SELECT * FROM nt:folder WHERE jcr:path LIKE '%s' ", pathConstraint);
        LOGGER.info((Object)sqlQuery);
        QueryManager manager = session.getWorkspace().getQueryManager();
        Query query = manager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        ArrayList<Descriptor> preciseNode = new ArrayList<Descriptor>();
        while (iterator.hasNext()) {
            Node candidate = iterator.nextNode();
            FolderDescriptor descriptor = new FolderDescriptor(candidate.getPath());
            preciseNode.add(descriptor);
        }
        return preciseNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.debug((Object)"Starting ArtifactManagingService ...");
        this.sessionProvider = SessionProvider.createSystemProvider();
        try {
            InputStream xml = this.getClass().getResourceAsStream(NT_FILE);
            ManageableRepository rep = this.repositoryService.getCurrentRepository();
            rep.getNodeTypeManager().registerNodeTypes(xml, 0);
            String entryPath = "exo:services/ArtifactManaging";
            RegistryEntry entry = this.registryService.getEntry(this.sessionProvider, entryPath);
            Document doc = entry.getDocument();
            this.repoWorkspaceName = doc.getElementsByTagName("artifact.workspace").item(0).getTextContent();
            LOGGER.info((Object)("Workspace from config : " + this.repoWorkspaceName));
            this.rootNodePath = doc.getElementsByTagName("artifact.rootNode").item(0).getTextContent();
            LOGGER.info((Object)("Root node from config : " + this.rootNodePath));
            this.prepareRootNode(this.sessionProvider, this.rootNodePath);
        }
        catch (PathNotFoundException e) {
            try {
                PropertiesParam props = this.initParams.getPropertiesParam("artifact.workspace");
                if (props == null) {
                    throw new RepositoryConfigurationException("Property parameters 'locations' expected");
                }
                this.repoWorkspaceName = props.getProperty("workspace");
                this.rootNodePath = props.getProperty("rootNode");
                Document doc = this.createInitConf(this.repoWorkspaceName, this.rootNodePath);
                RegistryEntry serviceEntry = new RegistryEntry(doc);
                this.registryService.createEntry(this.sessionProvider, "exo:services", serviceEntry);
                this.prepareRootNode(this.sessionProvider, this.rootNodePath);
            }
            catch (RepositoryException exc) {
                LOGGER.error((Object)"Cannot write init configuration to RegistryService", (Throwable)exc);
            }
            catch (RepositoryConfigurationException exc) {
                LOGGER.error((Object)"Cannot get init properties", (Throwable)exc);
            }
            catch (ParserConfigurationException exc) {
                LOGGER.error((Object)"Cann't create XML document", (Throwable)exc);
            }
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)"Error while register nodetypes/checking existance", (Throwable)e);
        }
        finally {
            this.sessionProvider.close();
        }
    }

    public void stop() {
    }

    private Session currentSession(SessionProvider sp) throws RepositoryException {
        return sp.getSession(this.repoWorkspaceName, this.repositoryService.getCurrentRepository());
    }

    private void prepareRootNode(SessionProvider sp, String path) throws RepositoryException {
        Session session = this.currentSession(sp);
        Node current_root = session.getRootNode();
        for (String folder : path.split("/")) {
            if (!current_root.hasNode(folder)) {
                current_root.addNode(folder);
            }
            current_root = current_root.getNode(folder);
        }
        session.save();
        if (!session.getItem(path).isNode()) {
            throw new RepositoryException("Maven root node is not been initialized");
        }
    }

    private Document createInitConf(String workspace, String relPath) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element r = doc.createElement(SERVICE_NAME);
        doc.appendChild(r);
        Element nameElement = doc.createElement("artifact.workspace");
        nameElement.setAttribute("id", "workspace");
        Text nameText = doc.createTextNode(this.repoWorkspaceName);
        nameElement.appendChild(nameText);
        r.appendChild(nameElement);
        Element descriptionElement = doc.createElement("artifact.rootNode");
        descriptionElement.setAttribute("id", "root");
        Text descriptionText = doc.createTextNode(this.rootNodePath);
        descriptionElement.appendChild(descriptionText);
        r.appendChild(descriptionElement);
        return doc;
    }

    private Node createGroupIdLayout(Node rootNode, ArtifactDescriptor artifact) throws RepositoryException {
        String[] items;
        FolderDescriptor groupId = artifact.getGroupId();
        ArrayList<String> struct_groupId = new ArrayList<String>();
        for (String subString : items = groupId.getAsPath().split("/")) {
            struct_groupId.add(subString);
        }
        Node groupIdTail = rootNode;
        for (String name : struct_groupId) {
            Node levelNode;
            if (!groupIdTail.hasNode(name)) {
                levelNode = groupIdTail.addNode(name, "nt:folder");
                levelNode.addMixin("exo:groupId");
            } else {
                levelNode = groupIdTail.getNode(name);
            }
            groupIdTail = levelNode;
        }
        return groupIdTail;
    }

    private Node createArtifactIdLayout(Node groupId_NodeTail, ArtifactDescriptor artifact) throws RepositoryException {
        Node artifactIdNode;
        String artifactId = artifact.getArtifactId();
        if (!groupId_NodeTail.hasNode(artifactId)) {
            artifactIdNode = groupId_NodeTail.addNode(artifactId, "nt:folder");
            artifactIdNode.addMixin("exo:artifactId");
            artifactIdNode.setProperty("exo:versionList", new String[]{STRING_TERMINATOR, STRING_TERMINATOR});
        } else {
            artifactIdNode = groupId_NodeTail.getNode(artifactId);
        }
        return artifactIdNode;
    }

    private Node createVersionLayout(Node artifactId, ArtifactDescriptor artifact) throws RepositoryException {
        String version = artifact.getVersionId();
        if (artifactId.hasNode(version)) {
            return null;
        }
        Node currentVersion = artifactId.addNode(version, "nt:folder");
        currentVersion.addMixin("exo:versionId");
        return currentVersion;
    }

    private void updateVersionList(Node artifactId, ArtifactDescriptor artifact) throws RepositoryException {
        String version = artifact.getVersionId();
        Property property = artifactId.getProperty("exo:versionList");
        Value[] values = property.getValues();
        ArrayList<String> versions = new ArrayList<String>();
        for (Value ver : values) {
            String str = ver.getString();
            if (str.equals(STRING_TERMINATOR)) continue;
            versions.add(str);
        }
        versions.add(version);
        String[] newValues = new String[versions.size()];
        Iterator i = versions.iterator();
        int index = 0;
        while (i.hasNext()) {
            newValues[index++] = (String)i.next();
        }
        artifactId.setProperty("exo:versionList", newValues);
    }

    private List<String> getAllArtifactVersions(Node artifactId) throws RepositoryException, ArtifactManagingException {
        Property property = artifactId.getProperty("exo:versionList");
        if (property == null) {
            throw new ArtifactManagingException("There is no version list property");
        }
        Value[] values = property.getValues();
        ArrayList<String> versionList = new ArrayList<String>();
        for (Value ver : values) {
            String str = ver.getString();
            if (str.equals(STRING_TERMINATOR)) continue;
            versionList.add(str);
        }
        return versionList;
    }

    private void updateMetadata(Node parentNode, ArtifactDescriptor artifact) throws RepositoryException {
        String groupId = artifact.getGroupId().getAsString();
        String artifactId = artifact.getArtifactId();
        String current_version = artifact.getVersionId();
        File srcFile = null;
        try {
            if (parentNode.isNodeType("exo:artifactId")) {
                List<String> available_versions = this.getAllArtifactVersions(parentNode);
                srcFile = this.createMultiMetadata(groupId, artifactId, current_version, available_versions);
            }
            if (parentNode.isNodeType("exo:versionId")) {
                srcFile = this.createSingleMetadata(groupId, artifactId, current_version);
            }
            FileInputStream file_in = new FileInputStream(srcFile);
            this.importResource(parentNode, file_in, "metadata", artifact);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Cannot create temporary file for holding artifact versions", (Throwable)e);
        }
        catch (ArtifactManagingException e) {
            LOGGER.error((Object)"Cannot create list for holding artifact versions", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void importResource(Node parentNode, InputStream file_in, String resourceType, ArtifactDescriptor artifact) throws RepositoryException {
        File tmp_file;
        String filename;
        block9: {
            filename = resourceType.equals("metadata") ? "maven-metadata.xml" : String.format("%s-%s.%s", artifact.getArtifactId(), artifact.getVersionId(), resourceType);
            FileOutputStream fout = null;
            tmp_file = null;
            try {
                String tmpFilename = this.getUniqueFilename(filename);
                tmp_file = File.createTempFile(tmpFilename, null);
                fout = new FileOutputStream(tmp_file);
                IOUtils.copy((InputStream)file_in, (OutputStream)fout);
                fout.flush();
                IOUtils.closeQuietly((InputStream)file_in);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"Cannot create .tmp file for storing artifact", (Throwable)e);
                break block9;
            }
            catch (IOException e2) {
                LOGGER.error((Object)"IO exception on .tmp file for storing artifact", (Throwable)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)file_in);
                IOUtils.closeQuietly(fout);
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        this.writePrimaryContent(parentNode, filename, resourceType, tmp_file);
        this.writeChecksum(parentNode, filename, tmp_file, "SHA1");
        try {
            FileUtils.forceDelete((File)tmp_file);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot delete tmp file", (Throwable)e);
        }
    }

    private void writePrimaryContent(Node parentNode, String filename, String resourceType, File srcFile) throws RepositoryException {
        String mixinType;
        String mimeType = this.getRelativeMimeType(resourceType);
        Node nodeResourceFile = parentNode.addNode(filename, "nt:file");
        if (nodeResourceFile.canAddMixin(mixinType = "exo:maven".concat(resourceType))) {
            nodeResourceFile.addMixin(mixinType);
        }
        try {
            FileInputStream file_is = new FileInputStream(srcFile);
            Node content = nodeResourceFile.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", (InputStream)file_is);
            IOUtils.closeQuietly((InputStream)file_is);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
    }

    private void writeChecksum(Node parentNode, String filename, File srcFile, String algorithm) throws RepositoryException {
        String mixinType;
        Node nodeChecksumFile = parentNode.addNode(filename.concat("." + algorithm.toLowerCase()), "nt:file");
        if (nodeChecksumFile.canAddMixin(mixinType = "exo:maven".concat(algorithm.toLowerCase()))) {
            nodeChecksumFile.addMixin(mixinType);
        }
        try {
            ByteArrayInputStream checksum_is = new ByteArrayInputStream(this.getChecksum(srcFile, algorithm).getBytes());
            String mimeType = "text/xml";
            Node content = nodeChecksumFile.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", mimeType);
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:data", (InputStream)checksum_is);
            IOUtils.closeQuietly((InputStream)checksum_is);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Cannot read from .tmp resource file", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"No such algorithm for generating checksums", (Throwable)e);
        }
    }

    protected String getChecksum(File file, String algo) throws NoSuchAlgorithmException, IOException {
        ChecksumObserver checksum = null;
        try {
            byte[] buffer = FileUtils.readFileToByteArray((File)file);
            if ("MD5".equals(algo)) {
                checksum = new ChecksumObserver("MD5");
            } else if ("SHA1".equals(algo)) {
                checksum = new ChecksumObserver("SHA-1");
            } else {
                throw new NoSuchAlgorithmException("No support for algorithm " + algo + ".");
            }
            checksum.transferProgress(null, buffer, buffer.length);
            checksum.transferCompleted(null);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error reading from stream", (Throwable)e);
        }
        return checksum.getActualChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createSingleMetadata(String groupId, String artifactId, String version) throws FileNotFoundException {
        File temp = null;
        try {
            String filename = this.getUniqueFilename("maven-metadata.xml");
            temp = File.createTempFile(filename, null);
            FileOutputStream os = new FileOutputStream(temp);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(os);
            try {
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("metadata");
                writer.writeStartElement("groupId");
                writer.writeCharacters(groupId);
                writer.writeEndElement();
                writer.writeStartElement("artifactId");
                writer.writeCharacters(artifactId);
                writer.writeEndElement();
                writer.writeStartElement("version");
                writer.writeCharacters(version);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            finally {
                writer.flush();
                writer.close();
                ((OutputStream)os).close();
            }
        }
        catch (XMLStreamException e) {
            LOGGER.error((Object)"Error on creating metadata - XML", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error on creating metadata - FILE", (Throwable)e);
        }
        return temp.exists() ? temp : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createMultiMetadata(String groupId, String artifactId, String current_version, List<String> v_list) throws FileNotFoundException {
        File temp = null;
        try {
            String filename = this.getUniqueFilename("maven-metadata.xml");
            temp = File.createTempFile(filename, null);
            FileOutputStream os = new FileOutputStream(temp);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(os);
            try {
                String elderVersion;
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("metadata");
                writer.writeStartElement("groupId");
                writer.writeCharacters(groupId);
                writer.writeEndElement();
                writer.writeStartElement("artifactId");
                writer.writeCharacters(artifactId);
                writer.writeEndElement();
                if (v_list.size() > 0) {
                    Collections.sort(v_list);
                    elderVersion = v_list.get(0);
                } else {
                    elderVersion = current_version;
                }
                v_list.add(current_version);
                writer.writeStartElement("version");
                writer.writeCharacters(elderVersion);
                writer.writeEndElement();
                writer.writeStartElement("versions");
                writer.writeStartElement("versioning");
                Iterator<String> iterator = v_list.iterator();
                while (iterator.hasNext()) {
                    writer.writeStartElement("version");
                    writer.writeCharacters(iterator.next());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            finally {
                writer.flush();
                writer.close();
                ((OutputStream)os).close();
            }
        }
        catch (XMLStreamException e) {
            LOGGER.error((Object)"Error on creating metadata - XML", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error on creating metadata - FILE", (Throwable)e);
        }
        return temp.exists() ? temp : null;
    }

    private String getRelativeMimeType(String key) {
        return this.mimeMap.get(key);
    }

    private void setDefaultMimes() {
        this.mimeMap.put("jar", "application/java-archive");
        this.mimeMap.put("pom", "text/xml");
    }

    private String getUniqueFilename(String basename) {
        String suffix = Double.valueOf(Math.random()).toString().substring(2, 7);
        return basename + "." + suffix;
    }
}

