/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.GroupImpl;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;

public class GroupHandlerImpl
extends CommonHandler
implements GroupHandler {
    public static final String EXO_DESCRIPTION = "exo:description";
    public static final String EXO_GROUP_ID = "exo:groupId";
    public static final String EXO_PARENT_ID = "exo:parentId";
    public static final String EXO_LABEL = "exo:label";
    public static final String STORAGE_EXO_GROUPS = "exo:groups";
    protected final List<GroupEventListener> listeners = new ArrayList<GroupEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.GroupHandlerImpl");

    GroupHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addChild started");
        }
        Session session = this.service.getStorageSession();
        try {
            String parentId = parent == null ? "" : parent.getId();
            String parentPath = this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + parentId;
            if (!session.itemExists(parentPath)) {
                return;
            }
            Node parentNode = (Node)session.getItem(parentPath);
            Node gNode = parentNode.addNode(child.getGroupName(), "exo:hierarchyGroup");
            GroupImpl group = new GroupImpl(child.getGroupName(), parentId, gNode.getUUID());
            group.setDescription(child.getDescription());
            group.setLabel(child.getLabel() != null ? child.getLabel() : child.getGroupName());
            if (broadcast) {
                this.preSave(child, true);
            }
            this.writeObjectToNode(group, gNode);
            session.save();
            if (broadcast) {
                this.postSave(child, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not add child group with groupId '" + child.getId() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners.add(listener);
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createGroup method");
        }
        this.addChild(null, group, broadcast);
    }

    public Group createGroupInstance() {
        return new GroupImpl();
    }

    public Group findGroupById(String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupById started");
        }
        Session session = this.service.getStorageSession();
        try {
            Group g;
            String gPath = this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + groupId;
            if (!session.itemExists(gPath)) {
                Group group = null;
                return group;
            }
            Node gNode = (Node)session.getItem(gPath);
            Group group = g = this.readObjectFromNode(gNode);
            return group;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group by groupId '" + groupId + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupByMembership started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Group> types = new ArrayList<Group>();
            String mtUUID = membershipType == null ? null : ((Node)session.getItem(this.service.getStoragePath() + "/" + "exo:membershipTypes" + "/" + membershipType)).getUUID();
            String whereStatement = mtUUID == null ? "" : " where exo:membershipType='" + mtUUID + "'";
            String mStatement = "select * from exo:userMembership" + whereStatement;
            Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Node uNode = mNode.getParent();
                if (!uNode.getName().equals(userName)) continue;
                Node gNode = session.getNodeByUUID(this.readStringProperty(mNode, "exo:group"));
                Group g = this.readObjectFromNode(gNode);
                types.add(g);
            }
            ArrayList<Group> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find groups", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findGroups(Group parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroups started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Group> types = new ArrayList<Group>();
            String gPath = this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS;
            if (parent == null || session.itemExists(gPath + parent.getId())) {
                String parentId = parent == null ? "" : parent.getId();
                String whereStatement = "where exo:parentId " + (parentId.equals("") ? " is null" : " = '" + parentId + "'");
                String statement = "select * from exo:group " + whereStatement + " order by exo:groupId";
                Query query = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult gRes = query.execute();
                NodeIterator gNodes = gRes.getNodes();
                while (gNodes.hasNext()) {
                    Node gNode = gNodes.nextNode();
                    Group g = this.readObjectFromNode(gNode);
                    types.add(g);
                }
            }
            ArrayList<Group> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find groups", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findGroupsOfUser started");
        }
        return this.findGroupByMembership(user, null);
    }

    public Collection getAllGroups() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Group> types = new ArrayList<Group>();
            String statement = "select * from exo:group order by exo:groupId";
            Query query = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult gRes = query.execute();
            NodeIterator gNodes = gRes.getNodes();
            while (gNodes.hasNext()) {
                Node gNode = gNodes.nextNode();
                Group g = this.readObjectFromNode(gNode);
                types.add(g);
            }
            ArrayList<Group> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get all groups ", e);
        }
        finally {
            session.logout();
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeGroup started");
        }
        Session session = this.service.getStorageSession();
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + group.getId());
            NodeIterator gNodes = gNode.getNodes();
            while (gNodes.hasNext()) {
                this.removeGroup(this.readObjectFromNode(gNodes.nextNode()), true);
            }
            String mStatement = "select * from exo:userMembership where exo:group='" + gNode.getUUID() + "'";
            Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                this.service.getMembershipHandler().removeMembership(mNode.getUUID(), broadcast);
            }
            Group g = this.readObjectFromNode(gNode);
            if (broadcast) {
                this.preDelete(group);
            }
            gNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(group);
            }
            log.debug((Object)("saveGroup return=" + group));
            Group group2 = g;
            return group2;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove group with groupId '" + group.getId() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        this.listeners.remove(listener);
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"saveGroup started");
        }
        Session session = this.service.getStorageSession();
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_GROUPS + group.getId());
            if (broadcast) {
                this.preSave(group, false);
            }
            this.writeObjectToNode(group, gNode);
            session.save();
            if (broadcast) {
                this.postSave(group, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save group '" + group.getId() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    private Group readObjectFromNode(Node node) throws Exception {
        try {
            String groupId = this.readStringProperty(node, EXO_GROUP_ID);
            GroupImpl group = new GroupImpl(node.getName(), groupId.substring(0, groupId.lastIndexOf(47)), node.getUUID());
            group.setDescription(this.readStringProperty(node, EXO_DESCRIPTION));
            group.setLabel(this.readStringProperty(node, EXO_LABEL));
            return group;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read node properties", e);
        }
    }

    private void writeObjectToNode(Group group, Node node) throws Exception {
        try {
            node.setProperty(EXO_LABEL, group.getLabel());
            node.setProperty(EXO_DESCRIPTION, group.getDescription());
            node.setProperty(EXO_GROUP_ID, group.getId());
            node.setProperty(EXO_PARENT_ID, group.getParentId());
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write node properties", e);
        }
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners) {
            listener.postDelete(group);
        }
    }
}

