/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileHandlerImpl;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.picocontainer.Startable;

public class JCROrganizationServiceImpl
extends BaseOrganizationService
implements Startable {
    public static final String STORAGE_PATH = "storage-path";
    public static final String STORAGE_WORKSPACE = "storage-workspace";
    public static final String STORAGE_PATH_DEFAULT = "/exo:organization";
    protected ManageableRepository repository;
    protected RepositoryService repositoryService;
    protected String storagePath;
    protected String storageWorkspace;

    public JCROrganizationServiceImpl(RepositoryService repositoryService, InitParams params) throws ConfigurationException {
        String path;
        String workspace = params.getValueParam(STORAGE_WORKSPACE).getValue();
        ValueParam paramStoragePath = params.getValueParam(STORAGE_PATH);
        String string = path = paramStoragePath != null ? paramStoragePath.getValue() : null;
        if (path != null) {
            if (path.equals("/")) {
                throw new ConfigurationException("storage-path can not be a root node");
            }
            this.storagePath = path;
        } else {
            this.storagePath = STORAGE_PATH_DEFAULT;
        }
        this.storageWorkspace = workspace;
        this.repositoryService = repositoryService;
        this.userDAO_ = new UserHandlerImpl(this);
        this.userProfileDAO_ = new UserProfileHandlerImpl(this);
        this.groupDAO_ = new GroupHandlerImpl(this);
        this.membershipDAO_ = new MembershipHandlerImpl(this);
        this.membershipTypeDAO_ = new MembershipTypeHandlerImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.repository = this.repositoryService.getDefaultRepository();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get default repository", e);
        }
        if (this.storageWorkspace == null) {
            this.storageWorkspace = this.repository.getConfiguration().getDefaultWorkspaceName();
        }
        try {
            Session session = this.getStorageSession();
            try {
                session.getItem(this.storagePath);
            }
            catch (PathNotFoundException e) {
                Node storage = session.getRootNode().addNode(this.storagePath.substring(1), "exo:organizationStorage");
                storage.addNode("exo:users", "exo:organizationUsers");
                storage.addNode("exo:groups", "exo:organizationGroups");
                storage.addNode("exo:membershipTypes", "exo:organizationMembershipTypes");
                session.save();
            }
            finally {
                session.logout();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not configure storage", e);
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    String getStoragePath() {
        return this.storagePath;
    }

    Session getStorageSession() throws RepositoryException {
        try {
            return this.repository.getSystemSession(this.storageWorkspace);
        }
        catch (NullPointerException e) {
            throw new RepositoryException("Can not get system session because repository is not initialized", (Throwable)e);
        }
    }
}

