/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;

public class MembershipHandlerImpl
extends CommonHandler
implements MembershipHandler {
    public static final String EXO_GROUP = "exo:group";
    public static final String EXO_MEMBERSHIP_TYPE = "exo:membershipType";
    protected final List<MembershipEventListener> listeners = new ArrayList<MembershipEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.MembershipHandlerImpl");

    MembershipHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners.add(listener);
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMembership");
        }
        Session session = this.service.getStorageSession();
        try {
            Group g = this.service.getGroupHandler().findGroupById(m.getGroupId());
            User u = this.service.getUserHandler().findUserByName(m.getUserName());
            MembershipType mt = this.service.getMembershipTypeHandler().createMembershipTypeInstance();
            mt.setName(m.getMembershipType());
            this.linkMembership(u, g, mt, broadcast);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create membership", e);
        }
        finally {
            session.logout();
        }
    }

    public Membership createMembershipInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMembershipInstance");
        }
        return new MembershipImpl();
    }

    public Membership findMembership(String id) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembership");
        }
        Session session = this.service.getStorageSession();
        try {
            Node mNode = session.getNodeByUUID(id);
            Membership membership = this.readObjectFromNode(mNode);
            return membership;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by UUId", e);
        }
        finally {
            session.logout();
        }
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserGroupAndType");
        }
        Session session = this.service.getStorageSession();
        try {
            String membershipTypeUUId;
            MembershipImpl membership = null;
            String groupUUId = this.getGroupUUID(groupId);
            if (groupUUId != null && (membershipTypeUUId = this.getMembershipTypeUUID(type)) != null) {
                String mStatement = "select * from exo:userMembership where exo:group='" + groupUUId + "' and exo:membershipType='" + membershipTypeUUId + "'";
                Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    Node uNode = mNode.getParent();
                    if (!uNode.getName().equals(userName)) continue;
                    if (membership != null) {
                        throw new OrganizationServiceException("More than one membership is found");
                    }
                    membership = new MembershipImpl(mNode.getUUID(), userName, groupId, type);
                }
            }
            MembershipImpl membershipImpl = membership;
            return membershipImpl;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type for user '" + userName + "' groupId '" + groupId + "' type '" + type + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByGroup");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String groupUUID = this.getGroupUUID(group.getId());
            if (groupUUID != null) {
                String statement = "select * from exo:userMembership where exo:group='" + groupUUID + "'";
                Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    types.add(this.readObjectFromNode(mNode));
                }
            }
            ArrayList<Membership> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by group", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembeshipByUser");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String userPath = this.service.getStoragePath() + "/" + "exo:users" + "/" + userName;
            if (!session.itemExists(userPath)) {
                ArrayList<Membership> arrayList = types;
                return arrayList;
            }
            String mStatement = "select * from exo:userMembership";
            Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Node uNode = mNode.getParent();
                if (!uNode.getName().equals(userName)) continue;
                types.add(this.readObjectFromNode(mNode));
            }
            ArrayList<Membership> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserAndGroup");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String groupUUId = this.getGroupUUID(groupId);
            if (groupUUId != null) {
                String mStatement = "select * from exo:userMembership where exo:group='" + groupUUId + "'";
                Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    Node uNode = mNode.getParent();
                    if (!uNode.getName().equals(userName)) continue;
                    types.add(this.readObjectFromNode(mNode));
                }
            }
            ArrayList<Membership> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "' and group '" + groupId + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"linkMembership");
        }
        Session session = this.service.getStorageSession();
        try {
            if (m.getName().equals("*") && !session.itemExists(this.service.getStoragePath() + "/" + "exo:membershipTypes" + "/" + m.getName())) {
                MembershipType mt = this.service.getMembershipTypeHandler().createMembershipTypeInstance();
                mt.setName("*");
                mt.setDescription("any membership type");
                this.service.getMembershipTypeHandler().createMembershipType(mt, broadcast);
            }
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + user.getUserName());
            MembershipImpl membership = new MembershipImpl(null, user.getUserName(), group.getId(), m.getName());
            Node mNode = uNode.addNode("exo:membership");
            if (broadcast) {
                this.preSave(membership, true);
            }
            this.writeObjectToNode(membership, mNode);
            session.save();
            if (broadcast) {
                this.postSave(membership, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not link membership for user '" + user.getUserName() + "' group '" + group.getGroupName() + "' and membership type '" + m.getName() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembership");
        }
        Session session = this.service.getStorageSession();
        try {
            Node mNode = session.getNodeByUUID(id);
            Membership membership = this.readObjectFromNode(mNode);
            if (broadcast) {
                this.preDelete(membership);
            }
            mNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(membership);
            }
            Membership membership2 = membership;
            return membership2;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by UUId", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembershipByUser");
        }
        Session session = this.service.getStorageSession();
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + userName);
            List types = new ArrayList();
            types = (List)this.findMembershipsByUser(userName);
            NodeIterator mNodes = uNode.getNodes("exo:membership");
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Membership membership = this.readObjectFromNode(mNode);
                if (broadcast) {
                    this.preDelete(membership);
                }
                mNode.remove();
            }
            session.save();
            for (int i = 0; i < types.size(); ++i) {
                if (!broadcast) continue;
                this.postDelete((Membership)types.get(i));
            }
            List list = types;
            return list;
        }
        catch (PathNotFoundException e) {
            throw new OrganizationServiceException("Can not find user '" + userName + "' for remove membership.");
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership by user '" + userName + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        this.listeners.remove(listener);
    }

    private String getMembershipTypeUUID(String type) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            String mtPath = this.service.getStoragePath() + "/" + "exo:membershipTypes";
            String string = type != null && type.length() != 0 && session.itemExists(mtPath + "/" + type) ? ((Node)session.getItem(mtPath + "/" + type)).getUUID() : null;
            return string;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type '" + type + "'", e);
        }
        finally {
            session.logout();
        }
    }

    private String getGroupUUID(String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            String gPath = this.service.getStoragePath() + "/" + "exo:groups";
            String string = groupId != null && groupId.length() != 0 && session.itemExists(gPath + groupId) ? ((Node)session.getItem(gPath + groupId)).getUUID() : null;
            return string;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group '" + groupId + "'", e);
        }
        finally {
            session.logout();
        }
    }

    private String getMembershipType(String UUID) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            String string = session.getNodeByUUID(UUID).getName();
            return string;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type by uuid " + UUID, e);
        }
        finally {
            session.logout();
        }
    }

    private String getGroupId(String UUID) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Node gNode = session.getNodeByUUID(UUID);
            String string = this.readStringProperty(gNode, "exo:groupId");
            return string;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group by uuid " + UUID, e);
        }
        finally {
            session.logout();
        }
    }

    private Membership readObjectFromNode(Node node) throws Exception {
        try {
            String groupUUID = this.readStringProperty(node, EXO_GROUP);
            String membershipTypeUUID = this.readStringProperty(node, EXO_MEMBERSHIP_TYPE);
            String groupId = this.getGroupId(groupUUID);
            String membershipType = this.getMembershipType(membershipTypeUUID);
            String userName = node.getParent().getName();
            return new MembershipImpl(node.getUUID(), userName, groupId, membershipType);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read membership properties", e);
        }
    }

    private void writeObjectToNode(Membership m, Node node) throws Exception {
        try {
            String groupUUId = this.getGroupUUID(m.getGroupId());
            String membershipTypeUUId = this.getMembershipTypeUUID(m.getMembershipType());
            node.setProperty(EXO_GROUP, groupUUId);
            node.setProperty(EXO_MEMBERSHIP_TYPE, membershipTypeUUId);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write membership properties", e);
        }
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postDelete(membership);
        }
    }
}

