/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;

public class UserHandlerImpl
extends CommonHandler
implements UserHandler {
    public static final String EXO_CREATED_DATE = "exo:createdDate";
    public static final String EXO_EMAIL = "exo:email";
    public static final String EXO_FIRST_NAME = "exo:firstName";
    public static final String EXO_LAST_LOGIN_TIME = "exo:lastLoginTime";
    public static final String EXO_LAST_NAME = "exo:lastName";
    public static final String EXO_MEMBERSHIP = "exo:membership";
    public static final String EXO_PASSWORD = "exo:password";
    public static final String EXO_PROFILE = "exo:profile";
    public static final String STORAGE_EXO_USERS = "exo:users";
    protected final List<UserEventListener> listeners = new ArrayList<UserEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserHandlerImpl");

    UserHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners.add(listener);
    }

    public boolean authenticate(String username, String password) throws Exception {
        User user;
        boolean authenticated;
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.authenticate method is started");
        }
        boolean bl = authenticated = (user = this.findUserByName(username)) != null ? user.getPassword().equals(password) : false;
        if (authenticated) {
            user.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser(user, false);
        }
        return authenticated;
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUser method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS);
            Node uNode = storageNode.addNode(user.getUserName());
            if (user.getCreatedDate() == null) {
                Calendar calendar = Calendar.getInstance();
                user.setCreatedDate(calendar.getTime());
            }
            if (broadcast) {
                this.preSave(user, true);
            }
            this.writeObjectToNode(user, uNode);
            session.save();
            if (broadcast) {
                this.postSave(user, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create user '" + user.getUserName() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public User createUserInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance() method is started");
        }
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance(String) method is started");
        }
        return new UserImpl(username);
    }

    public User findUserByName(String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUserByName method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS + "/" + userName);
            User user = this.readObjectFromNode(uNode);
            return user;
        }
        catch (PathNotFoundException e) {
            User user = null;
            return user;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user '" + userName + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public PageList findUsers(org.exoplatform.services.organization.Query query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUsers method is started");
        }
        String where = "";
        where = "jcr:path LIKE '%'";
        if (query.getEmail() != null) {
            where = where + (where.length() == 0 ? "" : " AND ") + "exo:email LIKE '" + query.getEmail().replace('*', '%') + "'";
        }
        if (query.getFirstName() != null) {
            where = where + (where.length() == 0 ? "" : " AND ") + "exo:firstName LIKE '" + query.getFirstName().replace('*', '%') + "'";
        }
        if (query.getLastName() != null) {
            where = where + (where.length() == 0 ? "" : " AND ") + "exo:lastName LIKE '" + query.getLastName().replace('*', '%') + "'";
        }
        ArrayList<User> types = new ArrayList<User>();
        String statement = "select * from exo:user " + (where.length() == 0 ? "" : "where " + where);
        Query uQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(statement, "sql");
        QueryResult uRes = uQuery.execute();
        NodeIterator uNodes = uRes.getNodes();
        while (uNodes.hasNext()) {
            User user;
            Node uNode = uNodes.nextNode();
            String userName = uNode.getName();
            if (query.getUserName() != null && userName.indexOf(this.removeAsterix(query.getUserName())) == -1 || (user = this.findUserByName(uNode.getName())) == null || query.getFromLoginDate() != null && (user.getLastLoginTime() == null || query.getFromLoginDate().getTime() > user.getLastLoginTime().getTime()) || query.getToLoginDate() != null && (user.getLastLoginTime() == null || query.getToLoginDate().getTime() < user.getLastLoginTime().getTime())) continue;
            types.add(user);
        }
        return new ObjectPageList(types, 10);
    }

    public PageList findUsersByGroup(String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUsersByGroup method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<User> users = new ArrayList<User>();
            String gPath = this.service.getStoragePath() + "/" + "exo:groups" + groupId;
            if (session.itemExists(gPath)) {
                Node gNode = (Node)session.getItem(gPath);
                String statement = "select * from exo:userMembership where exo:group='" + gNode.getUUID() + "'";
                Query mquery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult mres = mquery.execute();
                NodeIterator membs = mres.getNodes();
                while (membs.hasNext()) {
                    Node membership = membs.nextNode();
                    Node userNode = membership.getParent();
                    User user = this.findUserByName(userNode.getName());
                    if (user == null) continue;
                    users.add(user);
                }
            }
            ObjectPageList objectPageList = new ObjectPageList(users, 10);
            return objectPageList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not users by group '" + groupId + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public PageList getUserPageList(int pageSize) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.getUserPageList method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<User> types = new ArrayList<User>();
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS);
            NodeIterator uNodes = storageNode.getNodes();
            while (uNodes.hasNext()) {
                Node uNode = uNodes.nextNode();
                User user = this.findUserByName(uNode.getName());
                if (user == null) continue;
                types.add(user);
            }
            ObjectPageList objectPageList = new ObjectPageList(types, 10);
            return objectPageList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find users", e);
        }
        finally {
            session.logout();
        }
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.removeUser method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            String uPath = this.service.getStoragePath() + "/" + STORAGE_EXO_USERS + "/" + userName;
            if (!session.itemExists(uPath)) {
                User user = null;
                return user;
            }
            Node uNode = (Node)session.getItem(uPath);
            User user = this.findUserByName(userName);
            if (broadcast) {
                this.preDelete(user);
            }
            uNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(user);
            }
            User user2 = user;
            return user2;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove user '" + userName + "'", e);
        }
        finally {
            session.logout();
        }
    }

    public void removeUserEventListener(UserEventListener listener) {
        this.listeners.remove(listener);
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.saveUser method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            UserImpl userImpl = (UserImpl)user;
            String userUUID = userImpl.getUUId() != null ? userImpl.getUUId() : ((UserImpl)this.findUserByName(user.getUserName())).getUUId();
            Node uNode = session.getNodeByUUID(userUUID);
            String srcPath = uNode.getPath();
            int pos = srcPath.lastIndexOf(47);
            String prevName = srcPath.substring(pos + 1);
            String destPath = srcPath.substring(0, pos) + "/" + user.getUserName();
            if (!prevName.equals(user.getUserName())) {
                session.move(srcPath, destPath);
            }
            Node nmtNode = (Node)session.getItem(destPath);
            if (broadcast) {
                this.preSave(user, false);
            }
            this.writeObjectToNode(user, nmtNode);
            session.save();
            if (broadcast) {
                this.postSave(user, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save user '" + user.getUserName() + "'", e);
        }
        finally {
            session.logout();
        }
    }

    private User readObjectFromNode(Node node) throws Exception {
        try {
            UserImpl user = new UserImpl(node.getName(), node.getUUID());
            user.setCreatedDate(this.readDateProperty(node, EXO_CREATED_DATE));
            user.setLastLoginTime(this.readDateProperty(node, EXO_LAST_LOGIN_TIME));
            user.setEmail(this.readStringProperty(node, EXO_EMAIL));
            user.setPassword(this.readStringProperty(node, EXO_PASSWORD));
            user.setFirstName(this.readStringProperty(node, EXO_FIRST_NAME));
            user.setLastName(this.readStringProperty(node, EXO_LAST_NAME));
            return user;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read user properties", e);
        }
    }

    private void writeObjectToNode(User user, Node node) throws Exception {
        try {
            Calendar calendar = null;
            node.setProperty(EXO_EMAIL, user.getEmail());
            node.setProperty(EXO_FIRST_NAME, user.getFirstName());
            node.setProperty(EXO_LAST_NAME, user.getLastName());
            node.setProperty(EXO_PASSWORD, user.getPassword());
            if (user.getLastLoginTime() == null) {
                node.setProperty(EXO_LAST_LOGIN_TIME, calendar);
            } else {
                calendar = Calendar.getInstance();
                calendar.setTime(user.getLastLoginTime());
                node.setProperty(EXO_LAST_LOGIN_TIME, calendar);
            }
            calendar = Calendar.getInstance();
            calendar.setTime(user.getCreatedDate());
            node.setProperty(EXO_CREATED_DATE, calendar);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write user properties", e);
        }
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postDelete(user);
        }
    }

    private String removeAsterix(String str) {
        if (str.startsWith("*")) {
            str = str.substring(1);
        }
        if (str.endsWith("*")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

