/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserProfileImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;

public class UserProfileHandlerImpl
extends CommonHandler
implements UserProfileHandler {
    public static final String EXO_ATTRIBUTES = "exo:attributes";
    protected final List<UserProfileEventListener> listeners = new ArrayList<UserProfileEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserProfileHandlerImpl");

    UserProfileHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.add(listener);
    }

    public UserProfile createUserProfileInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance() method is started");
        }
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.createUserProfileInstance(String) method is started");
        }
        return new UserProfileImpl(userName);
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfileByName method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            String uPath = this.service.getStoragePath() + "/" + "exo:users" + "/" + userName;
            if (!session.itemExists(uPath)) {
                UserProfile userProfile = null;
                return userProfile;
            }
            Node uNode = (Node)session.getItem(uPath);
            String attrPath = uPath + "/" + "exo:profile" + "/" + EXO_ATTRIBUTES;
            if (!session.itemExists(attrPath)) {
                UserProfile userProfile = null;
                return userProfile;
            }
            Node attrNode = (Node)session.getItem(attrPath);
            UserProfileImpl userProfile = new UserProfileImpl(userName);
            PropertyIterator props = attrNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (prop.getName().startsWith("jcr:") || prop.getName().startsWith("exo:")) continue;
                userProfile.setAttribute(prop.getName(), prop.getString());
            }
            UserProfileImpl userProfileImpl = userProfile;
            return userProfileImpl;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user profile", e);
        }
        finally {
            session.logout();
        }
    }

    public Collection findUserProfiles() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.findUserProfiles method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            ArrayList<UserProfile> types = new ArrayList<UserProfile>();
            Node storagePath = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            NodeIterator nodes = storagePath.getNodes();
            while (nodes.hasNext()) {
                Node uNode = nodes.nextNode();
                UserProfile userProfile = this.findUserProfileByName(uNode.getName());
                if (userProfile == null) continue;
                types.add(userProfile);
            }
            ArrayList<UserProfile> arrayList = types;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user profiles", e);
        }
        finally {
            session.logout();
        }
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.removeUserProfile method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            UserProfile userProfile = this.findUserProfileByName(userName);
            if (userProfile == null) {
                UserProfile userProfile2 = null;
                return userProfile2;
            }
            Node profileNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + userName + "/" + "exo:profile");
            if (broadcast) {
                this.preDelete(userProfile);
            }
            profileNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(userProfile);
            }
            UserProfile userProfile3 = userProfile;
            return userProfile3;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove '" + userName + "' profile", e);
        }
        finally {
            session.logout();
        }
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners.remove(listener);
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UserProfile.saveUserProfile method is started");
        }
        Session session = this.service.getStorageSession();
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + profile.getUserName());
            try {
                uNode.getNode("exo:profile");
            }
            catch (PathNotFoundException e) {
                uNode.addNode("exo:profile");
            }
            Node profileNode = uNode.getNode("exo:profile");
            try {
                profileNode.getNode(EXO_ATTRIBUTES);
            }
            catch (PathNotFoundException e) {
                profileNode.addNode(EXO_ATTRIBUTES);
            }
            Node attrNode = profileNode.getNode(EXO_ATTRIBUTES);
            if (broadcast) {
                this.preSave(profile, false);
            }
            Object[] keys = profile.getUserInfoMap().keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                attrNode.setProperty(key, profile.getAttribute(key));
            }
            session.save();
            if (broadcast) {
                this.postSave(profile, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save '" + profile.getUserName() + "' profile", e);
        }
        finally {
            session.logout();
        }
    }

    private void preSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preSave(userProfile, isNew);
        }
    }

    private void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postSave(userProfile, isNew);
        }
    }

    private void preDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.preDelete(userProfile);
        }
    }

    private void postDelete(UserProfile userProfile) throws Exception {
        for (UserProfileEventListener listener : this.listeners) {
            listener.postDelete(userProfile);
        }
    }
}

