/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.initializer.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.ext.replication.async.transport.AbstractPacket;

public class WorkspaceDataPacket
extends AbstractPacket {
    public static final int WORKSPACE_DATA_PACKET = 100;
    private byte[] crc;
    private long totalPacketsCount;
    private long offset;
    private byte[] buffer;

    public WorkspaceDataPacket(int type, long totalPacketsCount, byte[] checksum, long offset, byte[] buffer) {
        super(type, -1);
        this.totalPacketsCount = totalPacketsCount;
        this.crc = checksum;
        this.offset = offset;
        this.buffer = buffer;
    }

    public WorkspaceDataPacket() {
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public long getPacketsCount() {
        return this.totalPacketsCount;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.crc.length);
        out.write(this.crc);
        out.writeLong(this.totalPacketsCount);
        out.writeLong(this.offset);
        out.writeInt(this.buffer.length);
        out.write(this.buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.crc = new byte[in.readInt()];
        in.readFully(this.crc);
        this.totalPacketsCount = in.readLong();
        this.offset = in.readLong();
        int bufSize = in.readInt();
        this.buffer = new byte[bufSize];
        in.readFully(this.buffer);
    }
}

