/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;

public class MembershipTypeHandlerImpl
extends CommonHandler
implements MembershipTypeHandler {
    public static final String EXO_DESCRIPTION = "exo:description";
    public static final String STORAGE_EXO_MEMBERSHIP_TYPES = "exo:membershipTypes";
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.MembershipTypeHandler");

    MembershipTypeHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    MembershipType createMembershipType(Session session, MembershipType mt, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.createMembershipType method is started");
        }
        try {
            Node storagePath = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_MEMBERSHIP_TYPES);
            Node mtNode = storagePath.addNode(mt.getName());
            this.writeObjectToNode(mt, mtNode);
            session.save();
            return this.readObjectFromNode(mtNode);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create membership type '" + mt.getName() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.createMembershipType(session, mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    public MembershipType createMembershipTypeInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.createMembershipTypeInstance method is started");
        }
        return new MembershipTypeImpl();
    }

    private MembershipType findMembershipType(Session session, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.findMembershipType method is started");
        }
        try {
            Node mtNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_MEMBERSHIP_TYPES + "/" + name);
            return this.readObjectFromNode(mtNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type '" + name + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType findMembershipType(String name) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.findMembershipType(session, name);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipTypes(Session session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.findMembershipTypes method is started");
        }
        try {
            ArrayList<MembershipType> types = new ArrayList<MembershipType>();
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_MEMBERSHIP_TYPES);
            NodeIterator nodes = storageNode.getNodes();
            while (nodes.hasNext()) {
                Node mtNode = nodes.nextNode();
                if (mtNode.getName().equals("*")) continue;
                types.add(this.readObjectFromNode(mtNode));
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership types", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipTypes() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipTypes(session);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType removeMembershipType(Session session, String name, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.removeMembershipType method is started");
        }
        try {
            Node mtNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_MEMBERSHIP_TYPES + "/" + name);
            String mStatement = "select * from exo:userMembership where exo:membershipType='" + mtNode.getUUID() + "'";
            Query mQuery = session.getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                ((MembershipHandlerImpl)this.service.getMembershipHandler()).removeMembership(session, mNode.getUUID(), broadcast);
            }
            MembershipType mt = this.readObjectFromNode(mtNode);
            mtNode.remove();
            session.save();
            return mt;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership type '" + name + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.removeMembershipType(session, name, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType saveMembershipType(Session session, MembershipType mt, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.saveMembershipType method is started");
        }
        try {
            MembershipTypeImpl mtImpl = (MembershipTypeImpl)mt;
            String mtUUID = mtImpl.getUUId() != null ? mtImpl.getUUId() : ((MembershipTypeImpl)this.findMembershipType(session, mt.getName())).getUUId();
            Node mtNode = session.getNodeByUUID(mtUUID);
            String srcPath = mtNode.getPath();
            int pos = srcPath.lastIndexOf(47);
            String prevName = srcPath.substring(pos + 1);
            if (!prevName.equals(mt.getName())) {
                String destPath = srcPath.substring(0, pos) + "/" + mt.getName();
                session.move(srcPath, destPath);
                mtNode = (Node)session.getItem(destPath);
            }
            this.writeObjectToNode(mt, mtNode);
            session.save();
            return this.readObjectFromNode(mtNode);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save membership type '" + mt.getName() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.saveMembershipType(session, mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType readObjectFromNode(Node node) throws Exception {
        try {
            MembershipTypeImpl mt = new MembershipTypeImpl(node.getUUID());
            mt.setName(node.getName());
            mt.setDescription(this.readStringProperty(node, EXO_DESCRIPTION));
            return mt;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read membership type properties", e);
        }
    }

    private void writeObjectToNode(MembershipType mt, Node node) throws Exception {
        try {
            node.setProperty(EXO_DESCRIPTION, mt.getDescription());
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write membership type properties", e);
        }
    }
}

