/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.replication.async.AsyncTransmitter;
import org.exoplatform.services.jcr.ext.replication.async.ItemDataExportVisitor;
import org.exoplatform.services.jcr.ext.replication.async.LocalEventListener;
import org.exoplatform.services.jcr.ext.replication.async.RemoteEventListener;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportRequest;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportServer;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.SimpleChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteExportServerImpl
implements RemoteExportServer,
LocalEventListener,
RemoteEventListener {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.RemoteExportServerImpl");
    public static final String FILE_PREFIX = "export";
    protected final AsyncTransmitter transmitter;
    protected final DataManager dataManager;
    protected final DataManager systemDataManager;
    protected final NodeTypeDataManager ntManager;
    protected final Set<ExportWorker> workers = new LinkedHashSet<ExportWorker>();
    protected final ResourcesHolder resHolder = new ResourcesHolder();
    protected boolean stopped = false;

    public RemoteExportServerImpl(AsyncTransmitter transmitter, DataManager dataManager, DataManager systemDataManager, NodeTypeDataManager ntManager) {
        this.transmitter = transmitter;
        this.dataManager = dataManager;
        this.systemDataManager = systemDataManager;
        this.ntManager = ntManager;
    }

    protected ChangesFile getExportChanges(String nodeId) throws RepositoryException, RemoteExportException {
        DataManager requiredDataManager;
        NodeData exportedNode = (NodeData)this.dataManager.getItemData(nodeId);
        if (exportedNode == null) {
            exportedNode = (NodeData)this.systemDataManager.getItemData(nodeId);
            requiredDataManager = this.systemDataManager;
        } else {
            requiredDataManager = this.dataManager;
        }
        NodeData parentNode = nodeId.equals("00exo0jcr0root0uuid0000000000000") ? exportedNode : (NodeData)requiredDataManager.getItemData(exportedNode.getParentIdentifier());
        ObjectWriterImpl out = null;
        try {
            MessageDigest digest;
            File chLogFile = File.createTempFile(FILE_PREFIX, "-" + nodeId);
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RemoteExportException(e);
            }
            DigestOutputStream dout = new DigestOutputStream(new FileOutputStream(chLogFile), digest);
            out = new ObjectWriterImpl((OutputStream)dout);
            ItemDataExportVisitor exporter = new ItemDataExportVisitor((ObjectWriter)out, parentNode, this.ntManager, (ItemDataConsumer)requiredDataManager, (ItemDataConsumer)this.systemDataManager);
            exportedNode.accept((ItemDataVisitor)exporter);
            out.flush();
            byte[] crc = digest.digest();
            SimpleChangesFile simpleChangesFile = new SimpleChangesFile(chLogFile, crc, System.currentTimeMillis(), this.resHolder);
            return simpleChangesFile;
        }
        catch (IOException e) {
            throw new RemoteExportException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("I/O error on result stream close " + e), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendExport(RemoteExportRequest event) {
        if (this.stopped) {
            LOG.warn((Object)("Export server stopped. Cannot handle SEND EXPORT request for Node Id " + event.getNodeId() + ". Request from " + event.getMember()));
        } else {
            ExportWorker export = new ExportWorker(event.getMember(), event.getNodeId());
            export.start();
            this.workers.add(export);
        }
    }

    @Override
    public void onCancel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On CANCEL");
        }
        for (ExportWorker worker : this.workers) {
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Cancel error " + e));
            }
            LOG.info((Object)("Cancel export for member " + worker.member));
        }
    }

    @Override
    public void onDisconnectMembers(List<Member> members) {
        for (ExportWorker worker : this.workers) {
            if (!members.contains(worker.member)) continue;
            worker.interrupt();
            LOG.info((Object)("Interrupt export for member " + worker.member));
        }
    }

    @Override
    public void onStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On STOP");
        }
        try {
            this.resHolder.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error of data streams close " + e), (Throwable)e);
        }
        this.stopped = true;
    }

    @Override
    public void onMerge(MemberAddress member) {
    }

    @Override
    public void onStart(List<MemberAddress> members) {
    }

    class ExportWorker
    extends Thread {
        final MemberAddress member;
        final String nodeId;

        ExportWorker(MemberAddress member, String nodeId) {
            this.member = member;
            this.nodeId = nodeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LOG.info((Object)("Remote EXPORT request from member " + this.member + ", node " + this.nodeId));
                ChangesFile chl = RemoteExportServerImpl.this.getExportChanges(this.nodeId);
                RemoteExportServerImpl.this.transmitter.sendExport(chl, this.member);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Remote export request served, send result to member " + this.member));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("IO error on send export changes " + e), (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Repository error on remote export request " + (Object)((Object)e)), (Throwable)e);
                try {
                    RemoteExportServerImpl.this.transmitter.sendError("error " + (Object)((Object)e), this.member);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IO error on send error message " + (Object)((Object)e)), (Throwable)e);
                }
            }
            catch (RemoteExportException e) {
                LOG.error((Object)("Remote export request causes the error " + e), (Throwable)e);
                try {
                    RemoteExportServerImpl.this.transmitter.sendError("error " + e, this.member);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IO error on send error message " + e), (Throwable)e);
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("Exception on remote export request " + e), e);
                try {
                    RemoteExportServerImpl.this.transmitter.sendError("error " + e, this.member);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IO error on send error message " + e), e);
                }
            }
            finally {
                RemoteExportServerImpl.this.workers.remove(this);
            }
        }
    }
}

