/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.analyze;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.replication.async.analyze.ChangesAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalyzer
implements ChangesAnalyzer {
    protected final boolean localPriority;
    protected final DataManager dataManager;
    protected final NodeTypeDataManager ntManager;

    public AbstractAnalyzer(boolean localPriority, DataManager dataManager, NodeTypeDataManager ntManager) {
        this.localPriority = localPriority;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
    }

    @Override
    public abstract void analyze(ItemState var1, ChangesStorage<ItemState> var2, ChangesStorage<ItemState> var3, ConflictResolver var4) throws IOException, ClassCastException, ClassNotFoundException, RepositoryException;

    @Override
    public boolean isLocalPriority() {
        return this.localPriority;
    }

    protected boolean isPropertyAllowed(InternalQName propertyName, NodeData parent) {
        PropertyDefinitionDatas pdef = this.ntManager.findPropertyDefinitions(propertyName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        return pdef != null;
    }
}

