/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.analyze;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.ext.replication.async.analyze.AbstractAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixinAnalyzer
extends AbstractAnalyzer {
    public MixinAnalyzer(boolean localPriority, DataManager dataManager, NodeTypeDataManager ntManager) {
        super(localPriority, dataManager, ntManager);
    }

    @Override
    public void analyze(ItemState incomeChange, ChangesStorage<ItemState> local, ChangesStorage<ItemState> income, ConflictResolver confilictResolver) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator<ItemState> liter = local.getChanges();
        block14: while (liter.hasNext()) {
            List<ItemState> updateSeq;
            ItemState nextLocalState;
            ItemState localState = liter.next();
            ItemData localData = localState.getData();
            ItemData incomeData = incomeChange.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER)) || localData.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (this.isLocalPriority()) {
                block0 : switch (localState.getState()) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (localState.isPersisted()) {
                            if (!localData.isNode() || !incomeData.getQPath().equals((Object)localData.getQPath()) && !incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            updateSeq = local.getUpdateSequence(localState);
                            for (ItemState item : updateSeq) {
                                if (!incomeData.getQPath().equals((Object)item.getData().getQPath()) && !incomeData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                confilictResolver.add(incomeData.getQPath());
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break block0;
                            }
                            continue block14;
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            if (!localData.isNode() || !incomeData.getQPath().equals((Object)localData.getQPath())) break;
                            confilictResolver.add(incomeData.getQPath());
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 16: {
                        if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                        confilictResolver.add(incomeData.getQPath());
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                    }
                }
                continue;
            }
            switch (localState.getState()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if (localState.isPersisted()) {
                        if (!localData.isNode() || !incomeData.getQPath().equals((Object)localData.getQPath()) && !incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        updateSeq = local.getUpdateSequence(localState);
                        for (ItemState st : updateSeq) {
                            if (!incomeData.getQPath().isDescendantOf(st.getData().getQPath()) && !incomeData.getQPath().equals((Object)st.getData().getQPath())) continue;
                            confilictResolver.add(st.getData().getQPath());
                        }
                        continue block14;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        if (!localData.isNode() || !localData.getQPath().equals((Object)incomeData.getQPath())) break;
                        confilictResolver.addAll(local.getUniquePathesByUUID(localData.getIdentifier()));
                        break;
                    }
                }
                case 32: {
                    break;
                }
                case 16: {
                    if (!incomeData.getQPath().equals((Object)localData.getQPath())) break;
                    confilictResolver.add(localData.getQPath());
                }
            }
        }
    }
}

