/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.jcr.dataflow.PairChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChecksumNotFoundException;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.VersionLogHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class SystemLocalStorageImpl
extends LocalStorageImpl
implements VersionLogHolder {
    protected final Map<String, PairChangesLog> pcLogs = new HashMap<String, PairChangesLog>();

    public SystemLocalStorageImpl(String storagePath, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) throws ChecksumNotFoundException, NoSuchAlgorithmException {
        super(storagePath, fileCleaner, maxBufferSize, holder);
    }

    public PairChangesLog getPairLog(String pairId) {
        return this.pcLogs.remove(pairId);
    }

    protected void processedPairChangesLog(PairChangesLog pcLog, String systemId) {
        if (this.pcLogs.get(pcLog.getPairId()) == null) {
            this.pcLogs.put(pcLog.getPairId(), pcLog);
        } else {
            TransactionChangesLog t = new TransactionChangesLog((PlainChangesLog)pcLog);
            t.setSystemId(systemId);
            this.changesQueue.add(t);
            t = new TransactionChangesLog((PlainChangesLog)this.getPairLog(pcLog.getPairId()));
            t.setSystemId(systemId);
            this.changesQueue.add(t);
        }
    }
}

