/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.ext.replication.recovery.AbstractFSAccess;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.TransactionChangesLogReader;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryReader
extends AbstractFSAccess {
    private static Log log = ExoLogger.getLogger((String)"ext.RecoveryReader");
    private FileCleaner fileCleaner;
    private int maxBufferSize;
    private ReaderSpoolFileHolder holder;
    private File recoveryDir;

    public RecoveryReader(FileCleaner fileCleaner, File recoveryDir, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
        this.recoveryDir = recoveryDir;
    }

    public TransactionChangesLog getChangesLog(String filePath) throws IOException, ClassNotFoundException {
        TransactionChangesLog tcl;
        ObjectReaderImpl in = new ObjectReaderImpl((InputStream)new FileInputStream(filePath));
        TransactionChangesLogReader rdr = new TransactionChangesLogReader(this.fileCleaner, this.maxBufferSize, this.holder);
        try {
            tcl = rdr.read((ObjectReader)in);
        }
        catch (UnknownClassIdException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        in.close();
        return tcl;
    }

    public List<String> getFilePathList(Calendar timeStamp, String ownName) throws IOException {
        File dataInfo = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownName);
        ArrayList<String> list = new ArrayList<String>();
        if (dataInfo.exists()) {
            String sPath;
            BufferedReader br = new BufferedReader(new FileReader(dataInfo));
            while ((sPath = br.readLine()) != null) {
                if (sPath.startsWith("---")) continue;
                File f = new File(sPath);
                Calendar time = this.getTimeStamp(f.getName());
                if (!timeStamp.after(time)) break;
                list.add(sPath);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sPath);
            }
        }
        return list;
    }

    private Calendar getTimeStamp(String fileName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        Calendar timeStamp = Calendar.getInstance();
        try {
            timeStamp.setTime(dateFormat.parse(fileName));
        }
        catch (ParseException e) {
            log.error((Object)"Can't parce date", (Throwable)e);
        }
        return timeStamp;
    }
}

