/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import javax.jcr.RepositoryException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupJobListener;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessagesLog;
import org.exoplatform.services.jcr.ext.backup.impl.BackupSchedulerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BackupScheduler {
    protected Log log = ExoLogger.getLogger((String)"ext.BackupScheduler");
    private final BackupManagerImpl backup;
    private final BackupMessagesLog messages;
    private final Timer timer;
    private final List<WeakReference<SchedulerTask>> tasks = new ArrayList<WeakReference<SchedulerTask>>();

    BackupScheduler(BackupManagerImpl backup, BackupMessagesLog messages) {
        this.backup = backup;
        this.timer = new Timer("BackupScheduler_Timer_" + new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date()), true);
        this.timer.schedule((TimerTask)new CleanupTasksListTask(), 1800000L, 1800000L);
        this.messages = messages;
    }

    private void registerShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    BackupScheduler.this.timer.cancel();
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public BackupMessage[] getErrors() {
        return this.messages.getMessages();
    }

    void restore(File taskFile) throws BackupSchedulerException, BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        try {
            TaskConfig tconf = new TaskConfig(taskFile);
            Date now = new Date();
            if (tconf.stopTime != null && tconf.stopTime.after(now) || tconf.chainPeriod > 0L || tconf.incrPeriod > 0L) {
                this.schedule(tconf.backupConfig, tconf.startTime, tconf.stopTime, tconf.chainPeriod, tconf.incrPeriod, null);
            }
        }
        catch (IOException e) {
            throw new BackupSchedulerException("Can't restore scheduler from task file " + taskFile.getAbsolutePath(), e);
        }
        catch (ParseException e) {
            throw new BackupSchedulerException("Can't restore scheduler from task file " + taskFile.getAbsolutePath(), e);
        }
        catch (XMLStreamException e) {
            throw new BackupSchedulerException("Can't restore scheduler from task file " + taskFile.getAbsolutePath(), e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupSchedulerException("Can't restore scheduler from task file " + taskFile.getAbsolutePath(), e);
        }
    }

    public void schedule(BackupConfig config, Date startTime, Date stopTime, long chainPeriod, long incrementalPeriod) throws BackupSchedulerException {
        this.schedule(config, startTime, stopTime, chainPeriod, incrementalPeriod, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void schedule(BackupConfig config, Date startTime, Date stopTime, long chainPeriod, long incrementalPeriod, BackupJobListener listener) throws BackupSchedulerException {
        long chainPeriodMilliseconds = chainPeriod * 1000L;
        if (incrementalPeriod > 0L) {
            config.setIncrementalJobPeriod(incrementalPeriod);
        }
        if (stopTime != null) {
            if (!stopTime.after(startTime)) throw new BackupSchedulerException("Stop time (" + stopTime + ") should be after the start time (" + startTime + ")");
            if (chainPeriodMilliseconds > 0L) {
                PeriodicTask periodicTask = new PeriodicTask(config, stopTime, listener);
                this.timer.schedule((TimerTask)periodicTask, startTime, chainPeriodMilliseconds);
            } else {
                long stopPeriod = stopTime.getTime() - startTime.getTime();
                PeriodTask periodTask = new PeriodTask(config, listener);
                this.timer.schedule((TimerTask)periodTask, startTime, stopPeriod);
            }
        } else if (chainPeriodMilliseconds > 0L) {
            PeriodicTask periodicTask = new PeriodicTask(config, null, listener);
            this.timer.schedule((TimerTask)periodicTask, startTime, chainPeriodMilliseconds);
        } else {
            RunOnceTask runOnceTask = new RunOnceTask(config, listener);
            this.timer.schedule((TimerTask)runOnceTask, startTime);
        }
        List<WeakReference<SchedulerTask>> stopPeriod = this.tasks;
        synchronized (stopPeriod) {
            void var11_12;
            this.tasks.add(new WeakReference<void>(var11_12));
        }
        TaskConfig tc = new TaskConfig(config, startTime, stopTime, chainPeriod, incrementalPeriod);
        try {
            File taskFile = new File(this.backup.getLogsDirectory().getAbsolutePath() + File.separator + config.getRepository() + "-" + config.getWorkspace() + ".task");
            if (taskFile.exists()) {
                throw new BackupSchedulerException("Task for repository '" + config.getRepository() + "' workspace '" + config.getWorkspace() + "' already exists. File " + taskFile.getAbsolutePath());
            }
            tc.save(taskFile);
            return;
        }
        catch (IOException e) {
            throw new BackupSchedulerException("Can't save scheduler task file " + e, e);
        }
        catch (XMLStreamException e) {
            throw new BackupSchedulerException("Can't save scheduler task file " + e, e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupSchedulerException("Can't save scheduler task file " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerTask findTask(String repository, String workspace) {
        List<WeakReference<SchedulerTask>> list = this.tasks;
        synchronized (list) {
            for (WeakReference<SchedulerTask> tr : this.tasks) {
                SchedulerTask task = (SchedulerTask)tr.get();
                if (task == null || !task.config.getRepository().equals(repository) || !task.config.getWorkspace().equals(workspace)) continue;
                return task;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unschedule(BackupConfig config) throws BackupSchedulerException {
        List<WeakReference<SchedulerTask>> list = this.tasks;
        synchronized (list) {
            Iterator<WeakReference<SchedulerTask>> ti = this.tasks.iterator();
            while (ti.hasNext()) {
                WeakReference<SchedulerTask> tr = ti.next();
                SchedulerTask task = (SchedulerTask)tr.get();
                if (task == null || !task.config.getRepository().equals(config.getRepository()) || !task.config.getWorkspace().equals(config.getWorkspace())) continue;
                try {
                    task.done().await();
                }
                catch (InterruptedException e) {
                    throw new BackupSchedulerException("Task stop operation fails " + e, e);
                }
                ti.remove();
                return true;
            }
        }
        return false;
    }

    private class RunOnceTask
    extends SchedulerTask {
        RunOnceTask(BackupConfig config, BackupJobListener listener) {
            super(config, listener);
        }

        public void run() {
            this.start();
            this.removeTaskConfig();
        }
    }

    private class PeriodicTask
    extends SchedulerTask {
        private final Date stopTime;

        PeriodicTask(BackupConfig config, Date stopTime, BackupJobListener listener) {
            super(config, listener);
            this.stopTime = stopTime;
        }

        public void run() {
            if (this.chain != null && this.chain.isFinished()) {
                this.cancel();
                this.removeTaskConfig();
            } else if (this.stopTime != null && new Date().after(this.stopTime)) {
                this.done();
            } else if (this.status == TaskStatus.VIRGIN) {
                this.start();
                this.status = TaskStatus.EXECUTED;
            } else if (this.status == TaskStatus.EXECUTED) {
                try {
                    this.stop().await();
                }
                catch (InterruptedException e) {
                    this.postError("Can't stop task for periodic rotation ", e);
                }
                this.start();
            } else {
                BackupScheduler.this.log.warn((Object)("Chain already task finished " + this.getChainName() + ", " + this));
            }
        }
    }

    private class PeriodTask
    extends SchedulerTask {
        PeriodTask(BackupConfig config, BackupJobListener listener) {
            super(config, listener);
        }

        public void run() {
            if (this.status == TaskStatus.VIRGIN) {
                this.start();
                this.status = TaskStatus.EXECUTED;
            } else if (this.status == TaskStatus.EXECUTED) {
                this.done();
            } else {
                BackupScheduler.this.log.warn((Object)("Chain already task finished " + this.getChainName() + ", " + this));
            }
        }
    }

    private abstract class SchedulerTask
    extends TimerTask {
        protected final BackupConfig config;
        protected BackupChain chain;
        protected TaskStatus status = TaskStatus.VIRGIN;
        protected final BackupJobListener listener;

        SchedulerTask(BackupConfig config, BackupJobListener listener) {
            this.config = config;
            this.listener = listener;
        }

        public String toString() {
            return super.toString() + "-" + this.getChainName();
        }

        public String getChainName() {
            return this.config.getRepository() + "@" + this.config.getWorkspace();
        }

        public BackupChain getChain() {
            return this.chain;
        }

        protected TaskThread stop() {
            TaskThread stopper = new TaskThread("BackupScheduler_Task_" + this.getChainName() + "-stop"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        BackupConfig backupConfig = SchedulerTask.this.config;
                        synchronized (backupConfig) {
                            BackupScheduler.this.backup.stopBackup(SchedulerTask.this.chain);
                            if (BackupScheduler.this.log.isDebugEnabled()) {
                                BackupScheduler.this.log.debug((Object)("Chain stopped " + SchedulerTask.this.chain.getLogFilePath()));
                            }
                        }
                    }
                    finally {
                        this.markReady();
                    }
                }
            };
            stopper.start();
            return stopper;
        }

        protected TaskThread start() {
            TaskThread starter = new TaskThread("BackupScheduler_Task_" + this.getChainName() + "-start"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        BackupConfig backupConfig = SchedulerTask.this.config;
                        synchronized (backupConfig) {
                            SchedulerTask.this.chain = BackupScheduler.this.backup.startBackup(SchedulerTask.this.config, SchedulerTask.this.listener);
                            if (BackupScheduler.this.log.isDebugEnabled()) {
                                BackupScheduler.this.log.debug((Object)("Chain satarted " + SchedulerTask.this.chain.getLogFilePath()));
                            }
                        }
                    }
                    catch (BackupOperationException e) {
                        SchedulerTask.this.postError(SchedulerTask.this.getChainName() + " start", e);
                    }
                    catch (BackupConfigurationException e) {
                        SchedulerTask.this.postError(SchedulerTask.this.getChainName() + " start", e);
                    }
                    catch (RepositoryException e) {
                        SchedulerTask.this.postError(SchedulerTask.this.getChainName() + " start", e);
                    }
                    catch (RepositoryConfigurationException e) {
                        SchedulerTask.this.postError(SchedulerTask.this.getChainName() + " start", e);
                    }
                    finally {
                        this.markReady();
                    }
                }
            };
            starter.start();
            return starter;
        }

        protected void postError(String message, Throwable e) {
            BackupScheduler.this.messages.addError(message, e);
            BackupScheduler.this.log.error((Object)message, e);
            if (this.listener != null) {
                this.listener.onError(null, message, e);
            }
        }

        protected TaskThread done() {
            TaskThread done = new TaskThread("BackupScheduler_Task_" + this.getChainName() + "-done"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        BackupConfig backupConfig = SchedulerTask.this.config;
                        synchronized (backupConfig) {
                            SchedulerTask.this.cancel();
                            BackupScheduler.this.backup.stopBackup(SchedulerTask.this.chain);
                            SchedulerTask.this.removeTaskConfig();
                            if (BackupScheduler.this.log.isDebugEnabled()) {
                                BackupScheduler.this.log.debug((Object)("Task done (stopped and scheduler canceled) " + (SchedulerTask.this.chain != null ? SchedulerTask.this.chain.getLogFilePath() : "[not started]")));
                            }
                        }
                    }
                    finally {
                        this.markReady();
                    }
                }
            };
            done.start();
            return done;
        }

        protected void removeTaskConfig() {
            File taskFile = new File(BackupScheduler.this.backup.getLogsDirectory().getAbsolutePath() + File.separator + this.config.getRepository() + "-" + this.config.getWorkspace() + ".task");
            if (taskFile.exists()) {
                taskFile.delete();
                if (BackupScheduler.this.log.isDebugEnabled()) {
                    BackupScheduler.this.log.debug((Object)("Remove scheduler task " + taskFile.getAbsolutePath()));
                }
            }
        }

        public boolean cancel() {
            this.status = TaskStatus.FINISHED;
            if (BackupScheduler.this.log.isDebugEnabled()) {
                BackupScheduler.this.log.debug((Object)("Task scheduling canceled " + (this.chain != null ? this.chain.getLogFilePath() : "[not started]")));
            }
            return super.cancel();
        }
    }

    class CleanupTasksListTask
    extends TimerTask {
        static final int PERIOD = 1800000;

        CleanupTasksListTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = BackupScheduler.this.tasks;
            synchronized (list) {
                Iterator ti = BackupScheduler.this.tasks.iterator();
                while (ti.hasNext()) {
                    if (((WeakReference)ti.next()).get() != null) continue;
                    ti.remove();
                }
            }
        }
    }

    private class TaskThread
    extends Thread {
        private final CountDownLatch latch;

        public TaskThread(String name) {
            super(name);
            this.latch = new CountDownLatch(1);
        }

        void markReady() {
            this.latch.countDown();
        }

        void await() throws InterruptedException {
            this.latch.await();
        }
    }

    private class TaskConfig {
        private final DateFormat datef = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        BackupConfig backupConfig;
        Date startTime;
        Date stopTime;
        long chainPeriod;
        long incrPeriod;

        TaskConfig(BackupConfig backupConfig, Date startTime, Date stopTime, long chainPeriod, long incrPeriod) {
            this.backupConfig = backupConfig;
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.chainPeriod = chainPeriod;
            this.incrPeriod = incrPeriod;
        }

        TaskConfig(File taskFile) throws IOException, XMLStreamException, FactoryConfigurationError, ParseException {
            this.read(taskFile);
        }

        Date parseDate(String dateString) throws ParseException {
            if ("null".equals(dateString)) {
                return null;
            }
            return this.datef.parse(dateString);
        }

        String formatDate(Date date) {
            return date == null ? "null" : this.datef.format(date);
        }

        void save(File taskFile) throws IOException, XMLStreamException, FactoryConfigurationError {
            TaskConfigWriter w = new TaskConfigWriter(taskFile);
            w.writeBackupConfig(this.backupConfig);
            w.writeSchedulerConfig(this.startTime, this.stopTime, this.chainPeriod, this.incrPeriod);
            w.writeEndLog();
        }

        void read(File taskFile) throws IOException, XMLStreamException, FactoryConfigurationError, ParseException {
            TaskConfigReader r = new TaskConfigReader(taskFile);
            r.readLogFile();
            this.backupConfig = r.backupConfig;
            this.startTime = r.startTime;
            this.stopTime = r.stopTime;
            this.chainPeriod = r.chainPeriod;
            this.incrPeriod = r.incrPeriod;
        }

        @Deprecated
        void read_old(File taskFile) throws IOException, ParseException, BackupSchedulerException {
            long _incrPeriod;
            long _chainPeriod;
            Date _stopTime;
            Date _startTime;
            char[] cbuf = new char[1024];
            StringBuilder content = new StringBuilder();
            FileReader fr = new FileReader(taskFile);
            int r = 0;
            while ((r = fr.read(cbuf)) >= 0) {
                content.append(cbuf, 0, r);
            }
            fr.close();
            String[] fc = content.toString().trim().split("\n");
            if (fc.length > 1) {
                File _backupLog = null;
                _startTime = null;
                _stopTime = null;
                _chainPeriod = -1L;
                _incrPeriod = -1L;
                String[] terms = fc[fc.length - 1].split(",");
                for (int i = 0; i < terms.length; ++i) {
                    if (i == 0) {
                        _backupLog = new File(terms[i]);
                        continue;
                    }
                    if (i == 1) {
                        _startTime = this.datef.parse(terms[i]);
                        continue;
                    }
                    if (i == 2) {
                        String t = terms[i];
                        if ("null".equals(t)) continue;
                        _stopTime = this.datef.parse(t);
                        continue;
                    }
                    if (i == 3) {
                        _chainPeriod = Long.parseLong(terms[i]);
                        continue;
                    }
                    if (i != 4) continue;
                    _incrPeriod = Long.parseLong(terms[i]);
                }
                if (!_backupLog.exists()) {
                    throw new BackupSchedulerException("Scheduler task skipped due to the error. Backup log file not exists " + _backupLog.getAbsolutePath() + ". Task file " + taskFile.getAbsolutePath());
                }
            } else {
                throw new BackupSchedulerException("Scheduler task skipped due to bad configured task file " + taskFile.getAbsolutePath() + ". File doesn't contains configuration line.");
            }
            this.startTime = _startTime;
            this.stopTime = _stopTime;
            this.chainPeriod = _chainPeriod;
            this.incrPeriod = _incrPeriod;
        }

        @Deprecated
        File save_old(File taskFile) throws IOException {
            if (!taskFile.exists()) {
                FileWriter fw = new FileWriter(taskFile);
                fw.append("LogPath,StartTime,StopTime,ChainPeriod,IncrPeriod\n");
                fw.append(taskFile.getAbsolutePath() + "," + this.datef.format(this.startTime) + "," + (this.stopTime != null ? this.datef.format(this.stopTime) : "null") + "," + this.chainPeriod + "," + this.incrPeriod);
                fw.close();
                return taskFile;
            }
            return null;
        }

        class TaskConfigReader {
            Log logger = ExoLogger.getLogger((String)"ext.TaskConfigReader");
            final FileInputStream logFile;
            final XMLStreamReader reader;
            BackupConfig backupConfig;
            Date startTime;
            Date stopTime;
            long chainPeriod;
            long incrPeriod;

            TaskConfigReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
                this.logFile = new FileInputStream(logFile);
                this.reader = XMLInputFactory.newInstance().createXMLStreamReader(this.logFile);
            }

            void readLogFile() throws XMLStreamException, ParseException, IOException {
                try {
                    while (true) {
                        int eventCode = this.reader.next();
                        switch (eventCode) {
                            case 1: {
                                String name = this.reader.getLocalName();
                                if (name.equals("backup-config")) {
                                    this.readBackupConfig();
                                }
                                if (!name.equals("scheduler-config")) break;
                                this.readTaskConfig();
                                break;
                            }
                            case 8: {
                                return;
                            }
                        }
                    }
                }
                finally {
                    this.logFile.close();
                }
            }

            private void readTaskConfig() throws XMLStreamException, MalformedURLException, ParseException {
                boolean endJobEntryInfo = false;
                while (!endJobEntryInfo) {
                    int eventCode = this.reader.next();
                    switch (eventCode) {
                        case 1: {
                            String name = this.reader.getLocalName();
                            if (name.equals("start-time")) {
                                this.startTime = TaskConfig.this.parseDate(this.readContent());
                            }
                            if (name.equals("stop-time")) {
                                this.stopTime = TaskConfig.this.parseDate(this.readContent());
                            }
                            if (name.equals("chain-period")) {
                                this.chainPeriod = Long.valueOf(this.readContent());
                            }
                            if (!name.equals("incr-period")) break;
                            this.incrPeriod = Long.valueOf(this.readContent());
                            break;
                        }
                        case 2: {
                            String tagName = this.reader.getLocalName();
                            if (!tagName.equals("scheduler-config")) break;
                            endJobEntryInfo = true;
                        }
                    }
                }
            }

            private void readBackupConfig() throws XMLStreamException {
                BackupConfig conf = new BackupConfig();
                boolean endBackupConfig = false;
                while (!endBackupConfig) {
                    int eventCode = this.reader.next();
                    switch (eventCode) {
                        case 1: {
                            String name = this.reader.getLocalName();
                            if (name.equals("backup-dir")) {
                                conf.setBackupDir(new File(this.readContent()));
                            }
                            if (name.equals("repository")) {
                                conf.setRepository(this.readContent());
                            }
                            if (name.equals("workspace")) {
                                conf.setWorkspace(this.readContent());
                            }
                            if (!name.equals("incremental-job-period")) break;
                            conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                            break;
                        }
                        case 2: {
                            String tagName = this.reader.getLocalName();
                            if (!tagName.equals("backup-config")) break;
                            endBackupConfig = true;
                        }
                    }
                }
                this.backupConfig = conf;
            }

            private String readContent() throws XMLStreamException {
                String content = null;
                int eventCode = this.reader.next();
                if (eventCode == 4) {
                    content = this.reader.getText();
                }
                return content;
            }
        }

        class TaskConfigWriter {
            Log logger = ExoLogger.getLogger((String)"ext.TaskConfigWriter");
            final FileOutputStream logFile;
            final XMLStreamWriter writer;

            TaskConfigWriter(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
                this.logFile = new FileOutputStream(logFile);
                this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.logFile);
                this.writer.writeStartDocument();
                this.writer.writeStartElement("backup-task-config");
                this.writer.flush();
            }

            void writeBackupConfig(BackupConfig config) throws XMLStreamException {
                this.writer.writeStartElement("backup-config");
                this.writer.writeStartElement("full-backup-type");
                this.writer.writeCharacters(BackupScheduler.this.backup.getFullBackupType());
                this.writer.writeEndElement();
                this.writer.writeStartElement("incremental-backup-type");
                this.writer.writeCharacters(BackupScheduler.this.backup.getIncrementalBackupType());
                this.writer.writeEndElement();
                if (config.getBackupDir() != null) {
                    this.writer.writeStartElement("backup-dir");
                    this.writer.writeCharacters(config.getBackupDir().getAbsolutePath());
                    this.writer.writeEndElement();
                }
                if (config.getRepository() != null) {
                    this.writer.writeStartElement("repository");
                    this.writer.writeCharacters(config.getRepository());
                    this.writer.writeEndElement();
                }
                if (config.getWorkspace() != null) {
                    this.writer.writeStartElement("workspace");
                    this.writer.writeCharacters(config.getWorkspace());
                    this.writer.writeEndElement();
                }
                this.writer.writeStartElement("incremental-job-period");
                this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.flush();
            }

            void writeSchedulerConfig(Date startTime, Date stopTime, long chainPeriod, long incrPeriod) throws XMLStreamException {
                this.writer.writeStartElement("scheduler-config");
                this.writer.writeStartElement("start-time");
                this.writer.writeCharacters(TaskConfig.this.formatDate(startTime));
                this.writer.writeEndElement();
                this.writer.writeStartElement("stop-time");
                this.writer.writeCharacters(TaskConfig.this.formatDate(stopTime));
                this.writer.writeEndElement();
                this.writer.writeStartElement("chain-period");
                this.writer.writeCharacters(String.valueOf(chainPeriod));
                this.writer.writeEndElement();
                this.writer.writeStartElement("incr-period");
                this.writer.writeCharacters(String.valueOf(incrPeriod));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.flush();
            }

            void writeEndLog() throws XMLStreamException, IOException {
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
                this.logFile.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskStatus {
        VIRGIN,
        EXECUTED,
        FINISHED;

    }
}

