/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.initializer.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.services.jcr.ext.initializer.RemoteWorkspaceInitializationException;
import org.exoplatform.services.jcr.ext.initializer.impl.InitializationErrorPacket;
import org.exoplatform.services.jcr.ext.initializer.impl.WorkspaceDataPacket;
import org.exoplatform.services.jcr.ext.replication.storage.IncomeDataContext;
import org.exoplatform.services.jcr.ext.replication.storage.Member;
import org.exoplatform.services.jcr.ext.replication.storage.RandomChangesFile;
import org.exoplatform.services.jcr.ext.replication.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.transport.MemberAddress;
import org.exoplatform.services.jcr.ext.replication.transport.PacketListener;
import org.exoplatform.services.jcr.ext.replication.transport.StateEvent;
import org.exoplatform.services.jcr.ext.replication.transport.StateListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoteReceiver
implements PacketListener,
StateListener {
    private static Log log = ExoLogger.getLogger((String)"ext.RemoteReceiver");
    private final File tempDir;
    private IncomeDataContext context;
    private CountDownLatch latch;
    private RemoteWorkspaceInitializationException exception = null;
    private int membrerInited = 0;

    public RemoteReceiver(File tempDir, CountDownLatch latch) {
        this.tempDir = tempDir;
        this.latch = latch;
    }

    public void onError(MemberAddress sourceAddress) {
    }

    public void receive(AbstractPacket packet, MemberAddress sourceAddress) {
        switch (packet.getType()) {
            case 100: {
                try {
                    WorkspaceDataPacket wdPacket = (WorkspaceDataPacket)packet;
                    if (this.context == null) {
                        RandomChangesFile changesFile;
                        try {
                            File subDir = new File(this.tempDir.getCanonicalPath() + File.separator + System.currentTimeMillis());
                            subDir.mkdirs();
                            File wdFile = File.createTempFile("wdFile", ".0", subDir);
                            changesFile = new RandomChangesFile(wdFile, wdPacket.getCRC(), 1L, new ResourcesHolder());
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new IOException(e.getMessage());
                        }
                        this.context = new IncomeDataContext(changesFile, new Member(sourceAddress, -1), wdPacket.getPacketsCount());
                    }
                    this.context.writeData(wdPacket.getBuffer(), wdPacket.getOffset());
                    if (!this.context.isFinished()) break;
                    this.latch.countDown();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot save workspace data changes", (Throwable)e);
                    this.exception = new RemoteWorkspaceInitializationException("Cannot save workspace data changes", e);
                    this.latch.countDown();
                }
                break;
            }
            case 101: {
                InitializationErrorPacket ePacket = (InitializationErrorPacket)packet;
                this.exception = new RemoteWorkspaceInitializationException(ePacket.getErrorMessage());
                this.latch.countDown();
                break;
            }
        }
    }

    public IncomeDataContext getContext() {
        return this.context;
    }

    public RemoteWorkspaceInitializationException getException() {
        return this.exception;
    }

    public void onStateChanged(StateEvent event) {
        if (!(this.membrerInited != 2 || event.getMembers().size() != 1 || this.context != null && this.context.isFinished())) {
            this.exception = new RemoteWorkspaceInitializationException("The remote member was disconected");
            this.latch.countDown();
        } else {
            this.membrerInited = event.getMembers().size();
        }
    }
}

