/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CopyMoveTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger(CopyMoveTestCase.class);

    public CopyMoveTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        log.info((Object)"CopyMoveTestCase inited");
    }

    public StringBuffer workspaceCopy(String srcRepoPath, String nodeName, String destNodeName, long contentSize) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempF", "_");
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(i % 127);
            }
            for (long i = 0L; i < contentSize / 1024L; ++i) {
                fos.write(buf);
            }
            fos.write(buf, 0, (int)(contentSize % 1024L));
            fos.close();
            Node srcNode = this.addNodePath(srcRepoPath).addNode(nodeName, "nt:file");
            Node contentNode = srcNode.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(tempFile));
            contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            contentNode.setProperty("jcr:lastModified", this.session.getValueFactory().createValue(Calendar.getInstance()));
            this.session.save();
            String normalizedSrcPath = this.getNormalizePath(srcRepoPath) + "/" + nodeName;
            String normalizedDestPath = this.getNormalizePath(srcRepoPath) + "/" + destNodeName;
            this.session.getWorkspace().copy(normalizedSrcPath, normalizedDestPath);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        catch (IOException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer workspaceMove(String srcRepoPath, String nodeName, String destNodeName, long contentSize) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempF", "_");
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(i % 127);
            }
            for (long i = 0L; i < contentSize / 1024L; ++i) {
                fos.write(buf);
            }
            fos.write(buf, 0, (int)(contentSize % 1024L));
            fos.close();
            Node srcNode = this.addNodePath(srcRepoPath).addNode(nodeName, "nt:file");
            Node contentNode = srcNode.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(tempFile));
            contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            contentNode.setProperty("jcr:lastModified", this.session.getValueFactory().createValue(Calendar.getInstance()));
            this.session.save();
            String normalizedSrcPath = this.getNormalizePath(srcRepoPath) + "/" + nodeName;
            String normalizedDestPath = this.getNormalizePath(srcRepoPath) + "/" + destNodeName;
            this.session.getWorkspace().move(normalizedSrcPath, normalizedDestPath);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        catch (IOException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer sessionMove(String srcRepoPath, String nodeName, String destNodeName, long contentSize) {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempF", "_");
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(i % 127);
            }
            for (long i = 0L; i < contentSize / 1024L; ++i) {
                fos.write(buf);
            }
            fos.write(buf, 0, (int)(contentSize % 1024L));
            fos.close();
            Node srcNode = this.addNodePath(srcRepoPath).addNode(nodeName, "nt:file");
            Node contentNode = srcNode.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(tempFile));
            contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            contentNode.setProperty("jcr:lastModified", this.session.getValueFactory().createValue(Calendar.getInstance()));
            this.session.save();
            String normalizedSrcPath = this.getNormalizePath(srcRepoPath) + "/" + nodeName;
            String normalizedDestPath = this.getNormalizePath(srcRepoPath) + "/" + destNodeName;
            this.session.move(normalizedSrcPath, normalizedDestPath);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        catch (IOException e) {
            log.error((Object)"Can't copy: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer checkCopyMoveNode(String srcRepoPath, String nodeName, String destNodeName, long contentSize) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(srcRepoPath) + "/" + destNodeName;
        try {
            Node ntFile = (Node)this.session.getItem(normalizePath);
            InputStream stream = ntFile.getNode("jcr:content").getProperty("jcr:data").getStream();
            byte[] buf = new byte[1024];
            long length = 0L;
            int lenReads = 0;
            while ((lenReads = stream.read(buf)) > 0) {
                length += (long)lenReads;
            }
            if (length == contentSize) {
                sb.append("ok");
            } else {
                sb.append("fail");
            }
        }
        catch (PathNotFoundException e) {
            log.error((Object)("Can't get node : " + normalizePath), (Throwable)e);
            sb.append("fail");
        }
        catch (RepositoryException e) {
            log.error((Object)"CheckNtFile fail", (Throwable)e);
            sb.append("fail");
        }
        catch (Exception e) {
            log.error((Object)"CheckNtFile fail", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }
}

