/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.ReadOnlyThroughChanges;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;

/**
 * Created by The eXo Platform SAS.
 * 
 * <br/>Date: 15.01.2009
 *
 * @author <a href="mailto:peter.nedonosko@exoplatform.com.ua">Peter Nedonosko</a> 
 * @version $Id: SynchronizerChangesLog.java 27878 2009-02-04 17:16:32Z pnedonosko $
 */
public class SynchronizerChangesLog extends TransactionChangesLog implements ReadOnlyThroughChanges {

  public SynchronizerChangesLog(ChangesStorage<ItemState> changes) {
    super(new ChangesStorageChangesLog(changes));
  }
  
  public SynchronizerChangesLog(PlainChangesLog changesLog) {
    super(changesLog);
  }
  
}
