/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.async.LocalEventListener;
import org.exoplatform.services.jcr.ext.replication.async.RemoteEventListener;
import org.exoplatform.services.jcr.ext.replication.async.SynchronizationLifeCycle;
import org.exoplatform.services.jcr.ext.replication.async.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncChannelManager;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncPacketListener;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncStateEvent;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncStateListener;
import org.exoplatform.services.jcr.ext.replication.async.transport.CancelPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncInitializer
extends SynchronizationLifeCycle
implements AsyncPacketListener,
AsyncStateListener,
LocalEventListener {
    private static final long CHANNEL_CLOSE_TIMEOUT = 1000L;
    private static final Log LOG = ExoLogger.getLogger((String)"ext.AsyncInitializer");
    private final int memberWaitTimeout;
    private final int priority;
    private final boolean cancelMemberNotConnected;
    private final List<Integer> otherParticipantsPriority;
    private boolean isCoordinator;
    private AsyncChannelManager channelManager;
    private List<MemberAddress> currentMembers = new ArrayList<MemberAddress>();
    private List<MemberAddress> mergingMembers = new ArrayList<MemberAddress>();
    private MemberAddress localMember;
    private LastMemberWaiter lastMemberWaiter;
    private FirstMemberWaiter firstMemberWaiter;
    private ChannelCloser closer;
    protected final Set<RemoteEventListener> listeners = new LinkedHashSet<RemoteEventListener>();

    AsyncInitializer(AsyncChannelManager channelManager, int priority, List<Integer> otherParticipantsPriority, int memberWaitTimeout, boolean cancelMemberNotConnected) {
        this.channelManager = channelManager;
        this.priority = priority;
        this.memberWaitTimeout = memberWaitTimeout;
        this.otherParticipantsPriority = otherParticipantsPriority;
        this.cancelMemberNotConnected = cancelMemberNotConnected;
    }

    public MemberAddress getLocalMember() {
        return new MemberAddress(this.localMember.getAddress());
    }

    public List<MemberAddress> getOtherMembers() {
        ArrayList<MemberAddress> mlist = new ArrayList<MemberAddress>(this.currentMembers.size() - 1);
        for (MemberAddress m : this.currentMembers) {
            if (m.equals(this.localMember)) continue;
            mlist.add(new MemberAddress(m.getAddress()));
        }
        return mlist;
    }

    public void addRemoteListener(RemoteEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRemoteListener(RemoteEventListener listener) {
        this.listeners.remove(listener);
    }

    private RemoteEventListener[] listeners() {
        return this.listeners.toArray(new RemoteEventListener[this.listeners.size()]);
    }

    @Override
    public void onStateChanged(AsyncStateEvent event) {
        if (this.isStopped()) {
            LOG.warn((Object)("Channel state changed but initializer was stopped " + event));
            return;
        }
        if (this.currentMembers.size() == 0 && event.getMembers().size() == 1) {
            try {
                LOG.info((Object)"Channel state changed - first member (this) connected to the channel ");
                this.firstMemberWaiter = new FirstMemberWaiter();
                this.firstMemberWaiter.start();
            }
            catch (Throwable e) {
                LOG.error((Object)"First member connection error.", e);
                this.doStop(1000L);
            }
        } else if (event.getMembers().size() > this.currentMembers.size()) {
            try {
                boolean hasAll;
                LOG.info((Object)("Channel state changed - new member connected to the channel " + event.getMembers().size() + " > " + this.currentMembers.size()));
                boolean bl = hasAll = event.getMembers().size() == this.otherParticipantsPriority.size() + 1;
                if (event.getMembers().size() == 2 && event.isCoordinator()) {
                    this.isCoordinator = event.isCoordinator();
                    if (!hasAll) {
                        this.lastMemberWaiter = new LastMemberWaiter();
                        this.lastMemberWaiter.start();
                    }
                }
                if (hasAll && this.isCoordinator) {
                    if (this.lastMemberWaiter != null) {
                        this.lastMemberWaiter.cancel();
                        this.lastMemberWaiter = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Channel state changed - last member waiter canceled (all members connected)");
                        }
                    }
                    LOG.info((Object)"START. All members connected.");
                    this.doStart(event.getMembers());
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Next member connection error.", e);
                this.doStop(1000L);
            }
        } else if (event.getMembers().size() < this.currentMembers.size()) {
            try {
                LOG.info((Object)("onStateChanged - one or more members were disconnected from the channel " + event.getMembers().size() + " < " + this.currentMembers.size()));
                ArrayList<MemberAddress> disconnectedMembers = new ArrayList<MemberAddress>(this.currentMembers);
                disconnectedMembers.removeAll(event.getMembers());
                if (this.isStarted()) {
                    if (!this.isMemberMergeDone(disconnectedMembers)) {
                        LOG.error((Object)"FATAL: member disconnected after the start. Stopping synchronization.");
                        this.doStop(1000L);
                        for (RemoteEventListener rl : this.listeners()) {
                            rl.onCancel();
                        }
                    }
                } else if (event.isCoordinator() && !this.isCoordinator) {
                    this.isCoordinator = event.isCoordinator();
                    LOG.info((Object)"Channel state changed - coordinator was changed to this, last member waiter started.");
                    this.lastMemberWaiter = new LastMemberWaiter();
                    this.lastMemberWaiter.start();
                } else if (event.isCoordinator() && this.isCoordinator && this.lastMemberWaiter != null) {
                    this.lastMemberWaiter.cancel();
                    this.lastMemberWaiter = null;
                    LOG.info((Object)"onStateChanged - last member waiter canceled");
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Member disconnection error.", e);
                this.doStop(5000L);
            }
        } else {
            LOG.info((Object)(">>>>> onStateChanged, members ammount is not changed but channel state was changed " + event));
        }
        try {
            if (event.getMembers().size() > 1 && this.firstMemberWaiter != null) {
                this.firstMemberWaiter.cancel();
                this.firstMemberWaiter = null;
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error of First member waiter stop." + e));
        }
        this.localMember = event.getLocalMember();
        this.currentMembers = event.getMembers();
    }

    private void doStart(List<MemberAddress> members) {
        LOG.info((Object)("START. Members count " + members.size()));
        ArrayList<MemberAddress> mlist = new ArrayList<MemberAddress>(members.size() - 1);
        for (MemberAddress m : members) {
            if (m.equals(this.localMember)) continue;
            mlist.add(new MemberAddress(m.getAddress()));
        }
        this.mergingMembers = new ArrayList<MemberAddress>(mlist);
        for (RemoteEventListener rl : this.listeners()) {
            rl.onStart(mlist);
        }
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneMember(MemberAddress member) {
        List<MemberAddress> list = this.mergingMembers;
        synchronized (list) {
            this.mergingMembers.remove(member);
        }
    }

    private boolean isMemberMergeDone(List<MemberAddress> members) {
        for (MemberAddress dm : members) {
            if (!this.mergingMembers.contains(dm)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void receive(AbstractPacket packet, MemberAddress srcMember) {
        if (this.otherParticipantsPriority.contains(packet.getTransmitterPriority())) {
            if (this.isStopped()) {
                LOG.warn((Object)("Changes received but initializer was stopped " + srcMember));
                return;
            }
            switch (packet.getType()) {
                case 17: {
                    try {
                        LOG.info((Object)("CANCEL. Initiated by " + srcMember));
                        this.doStop(1000L);
                        for (RemoteEventListener rl : this.listeners()) {
                            rl.onCancel();
                        }
                        break;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)"Cancel message handle error.", e);
                        break;
                    }
                }
                case 18: {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Do MERGE (remote) from " + srcMember));
                        }
                        if (this.mergingMembers.contains(srcMember)) {
                            this.doneMember(srcMember);
                            for (RemoteEventListener rl : this.listeners()) {
                                rl.onMerge(srcMember);
                            }
                            break;
                        }
                        LOG.warn((Object)("Skipp MERGE packet from already merged member " + srcMember + ". Packet: " + packet));
                        break;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)"Merge message handle error.", e);
                        this.doStop(1000L);
                    }
                }
            }
        } else {
            LOG.warn((Object)("Skipp packet from not configured participant : received priority = " + packet.getTransmitterPriority() + " ; Other participants priority = " + this.otherParticipantsPriority + "\nMember: " + srcMember + "\nPacket: " + packet));
        }
    }

    @Override
    public void onError(MemberAddress sourceAddress) {
    }

    @Override
    public void onStart(List<MemberAddress> members) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("On START (remote) members count " + members.size()));
        }
        this.mergingMembers = members;
        this.doStart();
    }

    @Override
    public void onCancel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On CANCEL (local)");
        }
        if (this.isStarted()) {
            this.doStop();
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
    }

    @Override
    public void onStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"On STOP (local)");
        }
        if (this.isStarted()) {
            this.doStop(1000L);
        } else {
            LOG.warn((Object)"Not started or already stopped");
        }
    }

    private void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"close");
        }
        this.channelManager.disconnect();
    }

    @Override
    public void doStop() {
        this.doStop(0L);
    }

    private void doStop(long timeout) {
        super.doStop();
        if (this.lastMemberWaiter != null) {
            this.lastMemberWaiter.cancel();
        }
        if (this.firstMemberWaiter != null) {
            this.firstMemberWaiter.cancel();
        }
        if (timeout > 1L) {
            this.closer = new ChannelCloser(timeout);
            this.closer.start();
        } else {
            this.close();
        }
    }

    private class FirstMemberWaiter
    extends LastMemberWaiter {
        private FirstMemberWaiter() {
        }

        public void run() {
            try {
                Thread.sleep(AsyncInitializer.this.memberWaitTimeout);
                if (this.run && AsyncInitializer.this.currentMembers.size() == 1) {
                    LOG.info((Object)"CANCEL. No one member connected.");
                    AsyncInitializer.this.doStop();
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)("FirstMemberWaiter is interrupted : " + e), (Throwable)e);
            }
        }
    }

    private class LastMemberWaiter
    extends Thread {
        protected volatile boolean run = true;

        private LastMemberWaiter() {
        }

        public void run() {
            block9: {
                try {
                    Thread.sleep(AsyncInitializer.this.memberWaitTimeout);
                    if (this.run && AsyncInitializer.this.currentMembers.size() < AsyncInitializer.this.otherParticipantsPriority.size() + 1 && AsyncInitializer.this.currentMembers.size() > 1 && !AsyncInitializer.this.cancelMemberNotConnected) {
                        LOG.info((Object)("START. Synchronize only " + (AsyncInitializer.this.otherParticipantsPriority.size() + 1 - AsyncInitializer.this.currentMembers.size()) + " members."));
                        if (AsyncInitializer.this.isInitialized()) {
                            AsyncInitializer.this.doStart(AsyncInitializer.this.currentMembers);
                        } else {
                            LOG.warn((Object)("Cannot start. " + (AsyncInitializer.this.isStarted() ? "Already started." : "Initializer stopped.")));
                        }
                        break block9;
                    }
                    if (!this.run) break block9;
                    LOG.info((Object)"CANCEL. Not all members were connected.");
                    if (AsyncInitializer.this.isInitialized()) {
                        try {
                            CancelPacket cancelPacket = new CancelPacket(17, AsyncInitializer.this.priority);
                            AsyncInitializer.this.channelManager.sendPacket(cancelPacket);
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Cannot send 'CANCEL' event.", (Throwable)e);
                        }
                        AsyncInitializer.this.doStop();
                        for (RemoteEventListener rl : AsyncInitializer.this.listeners()) {
                            rl.onCancel();
                        }
                        break block9;
                    }
                    LOG.warn((Object)"Cannot cancel. Already started or stopped.");
                }
                catch (InterruptedException e) {
                    LOG.error((Object)("LastMemberWaiter is interrupted : " + e), (Throwable)e);
                }
            }
        }

        public void cancel() {
            this.run = false;
        }
    }

    private class ChannelCloser
    extends Thread {
        private final long timeout;

        ChannelCloser(long timeout) {
            this.timeout = timeout;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
                if (AsyncInitializer.this.channelManager.isConnected()) {
                    AsyncInitializer.this.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot disconnect from JChannel", (Throwable)e);
            }
        }
    }
}

