/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;

public class ItemDataExportVisitor
extends ItemDataTraversingVisitor {
    protected ObjectOutputStream out;
    protected Stack<NodeData> parents;
    protected NodeTypeDataManager ntManager;

    public ItemDataExportVisitor(ObjectOutputStream out, NodeData parent, NodeTypeDataManager nodeTypeManager, ItemDataConsumer dataManager) {
        super(dataManager);
        this.out = out;
        this.ntManager = nodeTypeManager;
        this.parents = new Stack();
        this.parents.add(parent);
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        TransientPropertyData newProperty = new TransientPropertyData(property.getQPath(), property.getIdentifier(), -1, property.getType(), property.getParentIdentifier(), property.isMultiValued());
        List list = property.getValues();
        Iterator it = list.iterator();
        ArrayList<TransientValueData> res = new ArrayList<TransientValueData>();
        while (it.hasNext()) {
            TransientValueData value = ((AbstractValueData)it.next()).createTransientCopy();
            res.add(value);
        }
        newProperty.setValues(res);
        try {
            this.out.writeObject(new ItemState((ItemData)newProperty, 1, false, this.curParent().getQPath(), level != 0));
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        NodeData parent = this.curParent();
        QPath ancestorToSave = parent.getQPath();
        TransientNodeData newNode = new TransientNodeData(node.getQPath(), node.getIdentifier(), -1, node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
        this.parents.push((NodeData)newNode);
        try {
            this.out.writeObject(new ItemState((ItemData)newNode, 1, true, ancestorToSave, level != 0));
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (this.ntManager.isNodeType(Constants.MIX_VERSIONABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            QPathEntry nam;
            String ref;
            PropertyData property = (PropertyData)this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_VERSIONHISTORY, 1));
            try {
                ref = ValueDataConvertor.readString((ValueData)((ValueData)property.getValues().get(0)));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            NodeData verStorage = (NodeData)this.dataManager.getItemData("00exo0jcr0version0storage0uuid00");
            try {
                nam = QPathEntry.parse((String)("[]" + ref + ":1"));
            }
            catch (IllegalNameException e) {
                throw new RepositoryException((Throwable)e);
            }
            NodeData verHistory = (NodeData)this.dataManager.getItemData(verStorage, nam);
            ItemDataExportVisitor vis = new ItemDataExportVisitor(this.out, verStorage, this.ntManager, this.dataManager);
            verHistory.accept((ItemDataVisitor)vis);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    protected NodeData curParent() {
        return this.parents.peek();
    }
}

