/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.storage.AbstractChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemoryChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ReadOnlyIterator;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.SimpleOutputChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageIOException;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedItemStatesStorage<T extends ItemState>
extends AbstractChangesStorage<T>
implements EditableChangesStorage<T> {
    private static final Log LOG = ExoLogger.getLogger((String)"ext.BufferedItemStatesStorage");
    private static final long MAX_BUFFER_SIZE = 0x1000000L;
    protected final File storagePath;
    protected final Member member;
    protected final long maxBufferSize;
    protected final ResourcesHolder resHolder;
    private static Long index = new Long(0L);
    protected ObjectOutputStream currentStream;
    protected EditableChangesFile currentFile;
    protected BAOutputStream currentByteArray;
    protected SoftReference<List<T>> cache = new SoftReference<Object>(null);
    protected int cacheIndex = -1;

    public BufferedItemStatesStorage(File storagePath, Member member, ResourcesHolder resHolder) {
        this.member = member;
        this.storagePath = storagePath;
        this.maxBufferSize = 0x1000000L;
        this.resHolder = resHolder;
    }

    public BufferedItemStatesStorage(File storagePath, Member member, long maxBuffer, ResourcesHolder resHolder) {
        this.member = member;
        this.storagePath = storagePath;
        this.maxBufferSize = maxBuffer;
        this.resHolder = resHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangesFile[] getChangesFile() {
        try {
            this.closeObjectOutputStream();
        }
        catch (IOException e) {
            throw new StorageRuntimeException(e.getMessage() + (this.currentFile != null ? " file: [" + this.currentFile.toString() + "]" : " byte array"), e);
        }
        if (this.currentFile != null) {
            return new ChangesFile[]{this.currentFile};
        }
        if (this.currentByteArray != null) {
            long id;
            Long l = index;
            synchronized (l) {
                Long l2 = index;
                Long l3 = index = Long.valueOf(index + 1L);
                id = l2;
            }
            return new ChangesFile[]{new MemoryChangesFile(new byte[0], id, this.currentByteArray.toByteArray())};
        }
        return new ChangesFile[0];
    }

    @Override
    public void add(T change) throws IOException {
        this.initOutputStream();
        this.currentStream.writeObject(change);
        this.currentStream.flush();
        List<T> list = this.cache.get();
        if (list == null) {
            if (this.cacheIndex >= 0) {
                return;
            }
            list = new ArrayList<T>();
            this.cache = new SoftReference<ArrayList<List<T>>>(list);
        }
        list.add(change);
        ++this.cacheIndex;
    }

    @Override
    public void addAll(ChangesStorage<T> changes) throws IOException {
        this.initOutputStream();
        try {
            List<T> list = this.cache.get();
            if (list == null && this.cacheIndex == -1) {
                list = new ArrayList<T>();
                this.cache = new SoftReference<ArrayList<List<T>>>(list);
            }
            Iterator<T> chi = changes.getChanges();
            while (chi.hasNext()) {
                ItemState change = (ItemState)chi.next();
                this.currentStream.writeObject(change);
                if (list == null) continue;
                list.add(change);
                ++this.cacheIndex;
            }
            this.currentStream.flush();
        }
        catch (ClassCastException e) {
            throw new StorageIOException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new StorageIOException(e.getMessage(), e);
        }
    }

    private void initOutputStream() throws IOException {
        if (this.currentStream == null) {
            this.currentStream = new ObjectOutputStream(new ArrayOrFileOutputStream());
        }
    }

    private void closeObjectOutputStream() throws IOException {
        if (this.currentStream != null) {
            this.currentStream.close();
            this.currentStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableChangesFile createChangesFile() throws IOException {
        long id;
        Long l = index;
        synchronized (l) {
            Long l2 = index;
            Long l3 = index = Long.valueOf(index + 1L);
            id = l2;
        }
        File file = new File(this.storagePath, Long.toString(id));
        if (file.exists()) {
            throw new IOException("File already exists " + file.getAbsolutePath());
        }
        byte[] crc = new byte[]{};
        return new SimpleOutputChangesFile(file, crc, id, this.resHolder);
    }

    @Override
    public Iterator<T> getChanges() throws IOException, ClassCastException, ClassNotFoundException {
        List<T> list;
        if (this.currentStream != null) {
            this.currentStream.flush();
        }
        if ((list = this.cache.get()) == null) {
            list = new ArrayList<T>();
            ItemStateIterator iter = new ItemStateIterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            this.cache = new SoftReference<List<List<T>>>(list);
        }
        return new ReadOnlyIterator<T>(list.iterator());
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public void delete() throws IOException {
        List<T> list = this.cache.get();
        if (list != null) {
            list.clear();
            this.cache.clear();
        }
        if (this.currentFile != null) {
            this.currentFile.delete();
        }
    }

    @Override
    public int size() throws IOException, ClassCastException, ClassNotFoundException {
        Iterator<T> it = this.getChanges();
        List<T> list = this.cache.get();
        if (list != null) {
            return list.size();
        }
        int i = 0;
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemStateIterator<S extends ItemState>
    implements Iterator<S> {
        private ObjectInputStream in = null;
        private S nextItem;

        public ItemStateIterator() throws IOException, ClassCastException, ClassNotFoundException {
            if (BufferedItemStatesStorage.this.currentFile != null) {
                this.in = new ObjectInputStream(BufferedItemStatesStorage.this.currentFile.getInputStream());
            } else if (BufferedItemStatesStorage.this.currentByteArray != null) {
                this.in = new ObjectInputStream(new ByteArrayInputStream(BufferedItemStatesStorage.this.currentByteArray.getBuf(), 0, BufferedItemStatesStorage.this.currentByteArray.size()));
            }
            this.nextItem = this.readNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public S next() {
            if (this.nextItem == null) {
                throw new NoSuchElementException();
            }
            S retVal = this.nextItem;
            try {
                this.nextItem = this.readNext();
            }
            catch (IOException e) {
                throw new StorageRuntimeException(e.getMessage() + (BufferedItemStatesStorage.this.currentFile != null ? " file: [" + BufferedItemStatesStorage.this.currentFile.toString() + "]" : " byte array"), e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageRuntimeException(e.getMessage() + (BufferedItemStatesStorage.this.currentFile != null ? " file: [" + BufferedItemStatesStorage.this.currentFile.toString() + "]" : " byte array"), e);
            }
            catch (ClassCastException e) {
                throw new StorageRuntimeException(e.getMessage() + (BufferedItemStatesStorage.this.currentFile != null ? " file: [" + BufferedItemStatesStorage.this.currentFile.toString() + "]" : " byte array"), e);
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not allowed!");
        }

        private S readNext() throws IOException, ClassNotFoundException, ClassCastException {
            if (this.in != null) {
                try {
                    return (S)((ItemState)this.in.readObject());
                }
                catch (EOFException e) {
                    this.in.close();
                    this.in = null;
                    return null;
                }
                catch (Throwable e) {
                    this.in.close();
                    this.in = null;
                    throw new StorageIOException(e.getMessage(), e);
                }
            }
            return null;
        }
    }

    class BAOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }
    }

    class ArrayOrFileOutputStream
    extends OutputStream {
        private OutputStream currentOut;

        public ArrayOrFileOutputStream() throws IOException {
            if (BufferedItemStatesStorage.this.currentFile != null) {
                throw new StorageIOException("File exists but Object outputStream allready closed.");
            }
            BufferedItemStatesStorage.this.currentByteArray = new BAOutputStream();
            this.currentOut = BufferedItemStatesStorage.this.currentByteArray;
        }

        public void write(int b) throws IOException {
            this.currentOut.write(b);
            this.currentOut.flush();
            if (BufferedItemStatesStorage.this.currentByteArray != null && (long)BufferedItemStatesStorage.this.currentByteArray.size() > BufferedItemStatesStorage.this.maxBufferSize) {
                this.changeBufferToFile();
            }
        }

        public void write(byte[] b) throws IOException {
            this.currentOut.write(b);
            this.currentOut.flush();
            if (BufferedItemStatesStorage.this.currentByteArray != null && (long)BufferedItemStatesStorage.this.currentByteArray.size() > BufferedItemStatesStorage.this.maxBufferSize) {
                this.changeBufferToFile();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.currentOut.write(b, off, len);
            this.currentOut.flush();
            if (BufferedItemStatesStorage.this.currentByteArray != null && (long)BufferedItemStatesStorage.this.currentByteArray.size() > BufferedItemStatesStorage.this.maxBufferSize) {
                this.changeBufferToFile();
            }
        }

        public void close() throws IOException {
            this.currentOut.close();
        }

        private void changeBufferToFile() throws IOException {
            if (BufferedItemStatesStorage.this.currentFile != null) {
                throw new StorageIOException("File exists.");
            }
            BufferedItemStatesStorage.this.currentFile = BufferedItemStatesStorage.this.createChangesFile();
            this.currentOut = BufferedItemStatesStorage.this.currentFile.getOutputStream();
            this.currentOut.write(BufferedItemStatesStorage.this.currentByteArray.getBuf(), 0, BufferedItemStatesStorage.this.currentByteArray.size());
            BufferedItemStatesStorage.this.currentByteArray.close();
            BufferedItemStatesStorage.this.currentByteArray = null;
        }
    }
}

