/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.async.storage.AbstractChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesLogsIterator;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesLogStorage<T extends ItemState>
extends AbstractChangesStorage<T> {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.ChangesLogStorage");
    protected final List<ChangesFile> storage;

    public ChangesLogStorage(List<ChangesFile> storage) {
        this.storage = storage;
    }

    @Override
    public void delete() throws IOException {
        for (ChangesFile cf : this.storage) {
            cf.delete();
        }
    }

    @Override
    public int size() throws IOException, ClassNotFoundException {
        int size = 0;
        ChangesLogsIterator it = new ChangesLogsIterator(this.storage);
        while (it.hasNext()) {
            size += it.next().getSize();
        }
        return size;
    }

    @Override
    public Iterator<T> getChanges() throws IOException, ClassCastException, ClassNotFoundException {
        return new ItemStateIterator(this.storage);
    }

    @Override
    public ChangesFile[] getChangesFile() {
        ChangesFile[] files = new ChangesFile[this.storage.size()];
        this.storage.toArray(files);
        return files;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemStateIterator<C extends ItemState>
    implements Iterator<C> {
        private final ChangesLogsIterator<TransactionChangesLog> logIterator;
        private Iterator<C> currentChangesLog;

        public ItemStateIterator(List<ChangesFile> store) throws IOException, ClassCastException, ClassNotFoundException {
            this.logIterator = new ChangesLogsIterator(store);
            this.currentChangesLog = this.readNextIterator();
        }

        protected Iterator<C> readNextIterator() throws IOException, ClassNotFoundException, ClassCastException {
            if (!this.logIterator.hasNext()) {
                return null;
            }
            TransactionChangesLog curLog = this.logIterator.next();
            return curLog.getAllStates().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentChangesLog == null) {
                return false;
            }
            if (this.currentChangesLog.hasNext()) {
                return true;
            }
            try {
                this.currentChangesLog = this.readNextIterator();
                return this.hasNext();
            }
            catch (IOException e) {
                throw new StorageRuntimeException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public C next() {
            if (this.currentChangesLog == null) {
                throw new NoSuchElementException();
            }
            if (this.currentChangesLog.hasNext()) {
                return (C)((ItemState)this.currentChangesLog.next());
            }
            try {
                this.currentChangesLog = this.readNextIterator();
                return this.next();
            }
            catch (IOException e) {
                throw new StorageRuntimeException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not allowed!");
        }
    }
}

