/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageIOException;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesLogsIterator<L extends TransactionChangesLog>
implements Iterator<L> {
    private static final Log LOG = ExoLogger.getLogger((String)"ext.ChangesLogsIterator");
    private final List<ChangesFile> list;
    private int curFileIndex = 0;
    private ObjectInputStream currentIn = null;
    private L currentChangesLog = null;

    public ChangesLogsIterator(List<ChangesFile> list) throws IOException, ClassNotFoundException {
        this.list = list;
        this.currentChangesLog = this.readNextChangesLog();
    }

    @Override
    public boolean hasNext() {
        return this.currentChangesLog != null;
    }

    @Override
    public L next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            L log = this.currentChangesLog;
            this.currentChangesLog = this.readNextChangesLog();
            return log;
        }
        catch (IOException e) {
            this.releaseResources();
            throw new StorageRuntimeException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            this.releaseResources();
            throw new StorageRuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            this.releaseResources();
            throw new StorageRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported");
    }

    private L readNextChangesLog() throws IOException, ClassCastException, ClassNotFoundException {
        if (this.curFileIndex >= this.list.size() && this.currentIn == null) {
            return null;
        }
        if (this.currentIn == null) {
            this.currentIn = new ObjectInputStream(this.list.get(this.curFileIndex++).getInputStream());
        }
        try {
            return (L)((TransactionChangesLog)this.currentIn.readObject());
        }
        catch (EOFException e) {
            this.currentIn.close();
            this.currentIn = null;
            return this.readNextChangesLog();
        }
        catch (Throwable e) {
            this.currentIn.close();
            this.currentIn = null;
            throw new StorageIOException(e.getMessage(), e);
        }
    }

    private void releaseResources() {
        this.currentChangesLog = null;
        try {
            if (this.currentIn != null) {
                this.currentIn.close();
            }
            this.currentIn = null;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
    }
}

