/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.replication.ReplicationService;
import org.exoplatform.services.jcr.ext.replication.test.CopyMoveTestCase;
import org.exoplatform.services.jcr.ext.replication.test.DeleteTestCase;
import org.exoplatform.services.jcr.ext.replication.test.LockTestCase;
import org.exoplatform.services.jcr.ext.replication.test.NtFileTestCase;
import org.exoplatform.services.jcr.ext.replication.test.VersionTestCase;
import org.exoplatform.services.jcr.ext.replication.test.bandwidth.BandwidthAllocationTestCase;
import org.exoplatform.services.jcr.ext.replication.test.concurrent.ConcurrentModificationTestCase;
import org.exoplatform.services.jcr.ext.replication.test.priority.BasePriorityTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/replication-test/")
@Produces(value={"text/plain"})
public class ReplicationTestService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(ReplicationTestService.class);
    private RepositoryService repositoryService;
    private BackupManager backupManager;

    public ReplicationTestService(RepositoryService repoService, ReplicationService replicationService, BackupManager backupManager, InitParams params) {
        this.repositoryService = repoService;
        this.backupManager = backupManager;
        log.info((Object)"ReplicationTestService inited");
    }

    public ReplicationTestService(RepositoryService repoService, BackupManager backupManager, InitParams params) {
        this(repoService, null, backupManager, params);
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{fileName}/{fileSize}/addNTFile")
    public Response addNTFile(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="fileName") String fileName, @PathParam(value="fileSize") Long fileSize) {
        NtFileTestCase ntFileTestCase = new NtFileTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = ntFileTestCase.addNtFile(repoPath, fileName, fileSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{fileName}/{fileSize}/checkNTFile")
    public Response checkNTFile(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="fileName") String fileName, @PathParam(value="fileSize") Long fileSize) {
        NtFileTestCase ntFileTestCase = new NtFileTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = ntFileTestCase.checkNtFile(repoPath, fileName, fileSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{incementalPeriod}/startBackup")
    public Response startBackup(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="incementalPeriod") Long incementalPeriod) {
        BackupConfig config = new BackupConfig();
        config.setBuckupType(1);
        config.setRepository(repositoryName);
        config.setWorkspace(workspaceName);
        config.setBackupDir(this.backupManager.getBackupDirectory());
        config.setIncrementalJobPeriod(incementalPeriod);
        String result = "ok";
        try {
            this.backupManager.startBackup(config);
        }
        catch (Exception e) {
            result = "fail";
            log.error((Object)"Can't start backup", (Throwable)e);
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/lock")
    public Response lock(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath) {
        LockTestCase lockTestCase = new LockTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = lockTestCase.lock(repoPath);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/checkLock")
    public Response checkLock(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath) {
        LockTestCase lockTestCase = new LockTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = lockTestCase.isLocked(repoPath);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{value}/addVersionNode")
    public Response addVersionNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="value") String value) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.addVersionNode(repoPath, value);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{checkedValue}/checkVersionNode")
    public Response checkVersionNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="checkedValue") String checkedValue) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.checkVersionNode(repoPath, checkedValue);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{newValue}/addNewVersion")
    public Response addNewVersion(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="newValue") String newValue) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.addNewVersion(repoPath, newValue);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/restorePreviousVersion")
    public Response restorePreviousVersion(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.restorePreviousVersion(repoPath);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/restoreBaseVersion")
    public Response restoreBaseVersion(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath) {
        VersionTestCase versionTestCase = new VersionTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = versionTestCase.restoreBaseVersion(repoPath);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{nodeName}/delete")
    public Response delete(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName) {
        DeleteTestCase deleteTestCase = new DeleteTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = deleteTestCase.delete(repoPath, nodeName);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{nodeName}/checkDelete")
    public Response checkDelete(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName) {
        DeleteTestCase deleteTestCase = new DeleteTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = deleteTestCase.checkDelete(repoPath, nodeName);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/workspaceCopy")
    public Response workspaceCopy(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="destNodeName") String destNodeName, @PathParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.workspaceCopy(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath}/{nodeName}/{destNodeName}/{contentSize}/workspaceMove")
    public Response workspaceMove(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="destNodeName") String destNodeName, @PathParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.workspaceMove(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath:.*}/{nodeName}/{destNodeName}/{contentSize}/sessionMove")
    public Response sessionMove(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="destNodeName") String destNodeName, @PathParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.sessionMove(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath:.*}/{nodeName}/{destNodeName}/{contentSize}/checkCopyMoveNode")
    public Response checkCopyMoveNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="destNodeName") String destNodeName, @PathParam(value="contentSize") Long contentSize) {
        CopyMoveTestCase copyMoveTestCase = new CopyMoveTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = copyMoveTestCase.checkCopyMoveNode(srcRepoPath, nodeName, destNodeName, contentSize);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/disconnectClusterNode")
    public Response disconnectClusterNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password) {
        BasePriorityTestCase priorityTestCase = new BasePriorityTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = priorityTestCase.disconnectClusterNode();
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{id}/disconnectClusterNodeById")
    public Response disconnectClusterNodeById(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="id") Integer id) {
        BasePriorityTestCase priorityTestCase = new BasePriorityTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = priorityTestCase.disconnectClusterNode(id);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/allowConnect")
    public Response allowConnect(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password) {
        BasePriorityTestCase priorityTestCase = new BasePriorityTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = priorityTestCase.allowConnect();
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/allowConnectForced")
    public Response allowConnectForced(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password) {
        BasePriorityTestCase priorityTestCase = new BasePriorityTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = priorityTestCase.allowConnectForced();
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/workspaceIsReadOnly")
    public Response workspaceIsReadOnly(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password) {
        BasePriorityTestCase priorityTestCase = new BasePriorityTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = priorityTestCase.isReadOnly(workspaceName);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{fileName}/{iterations}/{simpleContent}/createContent")
    public Response createContent(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="fileName") String fileName, @PathParam(value="iterations") Long iterations, @PathParam(value="simpleContent") String simpleContent) {
        ConcurrentModificationTestCase concurrentModificationTestCase = new ConcurrentModificationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = concurrentModificationTestCase.createContent(repoPath, fileName, iterations, simpleContent);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath:.*}/{srcFileName}/{destRepoPath:.*}/{destFileName}/compareData")
    public Response compareData(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="srcFileName") String srcFileName, @PathParam(value="destRepoPath") String destRepoPath, @PathParam(value="destFileName") String destFileName) {
        ConcurrentModificationTestCase concurrentModificationTestCase = new ConcurrentModificationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = concurrentModificationTestCase.compareData(srcRepoPath, srcFileName, destRepoPath, destFileName);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{srcRepoPath:.*}/{srcFileName}/{destRepoPath:.*}/{destFileName}/{iterations}/startThreadUpdater")
    public Response startThreadUpdater(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="srcRepoPath") String srcRepoPath, @PathParam(value="srcFileName") String srcFileName, @PathParam(value="destRepoPath") String destRepoPath, @PathParam(value="destFileName") String destFileName, @PathParam(value="iterations") Long iterations) {
        ConcurrentModificationTestCase concurrentModificationTestCase = new ConcurrentModificationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = concurrentModificationTestCase.startThreadUpdater(srcRepoPath, srcFileName, destRepoPath, destFileName, iterations);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath}/{nodeName}/createBaseNode")
    public Response createBaseNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName) {
        BandwidthAllocationTestCase bandwidthAllocationTestCase = new BandwidthAllocationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = bandwidthAllocationTestCase.createBaseNode(repoPath, nodeName);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{nodeName}/{iterations}/addEmptyNode")
    public Response addEmptyNode(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="iterations") Long iterations) {
        BandwidthAllocationTestCase bandwidthAllocationTestCase = new BandwidthAllocationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = bandwidthAllocationTestCase.addEmptyNode(repoPath, nodeName, iterations);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{nodeName}/{size}/{iterations}/addEmptyNode")
    public Response addStringPropertyOnly(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="size") Long size, @PathParam(value="iterations") Long iterations) {
        BandwidthAllocationTestCase bandwidthAllocationTestCase = new BandwidthAllocationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = bandwidthAllocationTestCase.addStringPropertyOnly(repoPath, nodeName, size, iterations);
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{userName}/{password}/{repoPath:.*}/{nodeName}/{size}/{iterations}/addBinaryPropertyOnly")
    public Response addBinaryPropertyOnly(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @PathParam(value="password") String password, @PathParam(value="repoPath") String repoPath, @PathParam(value="nodeName") String nodeName, @PathParam(value="size") Long size, @PathParam(value="iterations") Long iterations) {
        BandwidthAllocationTestCase bandwidthAllocationTestCase = new BandwidthAllocationTestCase(this.repositoryService, repositoryName, workspaceName, userName, password);
        StringBuffer sb = bandwidthAllocationTestCase.addBinaryPropertyOnly(repoPath, nodeName, size, iterations);
        return Response.ok((Object)sb.toString()).build();
    }

    public final class Constants {
        public static final String BASE_URL = "/rest/replication-test";

        private Constants() {
        }

        public final class OperationType {
            public static final String ADD_NT_FILE = "addNTFile";
            public static final String CHECK_NT_FILE = "checkNTFile";
            public static final String START_BACKUP = "startBackup";
            public static final String SET_LOCK = "lock";
            public static final String CECK_LOCK = "checkLock";
            public static final String ADD_VERSIONODE = "addVersionNode";
            public static final String CHECK_VERSION_NODE = "checkVersionNode";
            public static final String ADD_NEW_VERSION = "addNewVersion";
            public static final String RESTORE_RPEVIOUS_VERSION = "restorePreviousVersion";
            public static final String RESTORE_BASE_VERSION = "restoreBaseVersion";
            public static final String DELETE = "delete";
            public static final String CHECK_DELETE = "checkDelete";
            public static final String WORKSPACE_COPY = "workspaceCopy";
            public static final String WORKSPASE_MOVE = "workspaceMove";
            public static final String SESSION_MOVE = "sessionMove";
            public static final String CHECK_COPY_MOVE_NODE = "checkCopyMoveNode";
            public static final String DISCONNECT_CLUSTER_NODE = "disconnectClusterNode";
            public static final String DISCONNECT_CLUSTER_NODE_BY_ID = "disconnectClusterNodeById";
            public static final String ALLOW_CONNECT = "allowConnect";
            public static final String ALLOW_CONNECT_FORCED = "allowConnectForced";
            public static final String WORKSPACE_IS_READ_ONLY = "workspaceIsReadOnly";
            public static final String CREATE_CONTENT = "createContent";
            public static final String COMPARE_DATA = "compareData";
            public static final String START_THREAD_UPDATER = "startThreadUpdater";
            public static final String CREATE_BASE_NODE = "createBaseNode";
            public static final String ADD_EMPTY_NODE = "addEmptyNode";
            public static final String ADD_STRING_PROPETY_ONLY = "addStringPropertyOnly";
            public static final String ADD_BINARY_PROPERTY_ONLY = "addBinaryPropertyOnly";

            private OperationType() {
            }
        }
    }
}

