/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.resource.jcr.Handler;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoaderPlugin;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestUpdateListener;
import org.exoplatform.services.jcr.ext.script.groovy.ObservationListenerConfiguration;
import org.exoplatform.services.jcr.ext.script.groovy.XMLGroovyScript2Rest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="script/groovy/{repository}/{workspace}")
public class GroovyScript2RestLoader
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)GroovyScript2RestLoader.class.getName());
    private static final String DEFAULT_NODETYPE = "exo:groovyResourceContainer";
    private static final String SERVICE_NAME = "GroovyScript2RestLoader";
    private InitParams initParams;
    private ResourceBinder binder;
    private GroovyScriptInstantiator groovyScriptInstantiator;
    private RepositoryService repositoryService;
    private ConfigurationManager configurationManager;
    private RegistryService registryService;
    private ThreadLocalSessionProviderService sessionProviderService;
    private ObservationListenerConfiguration observationListenerConfiguration;
    private String nodeType;
    private Map<String, Class<?>> scriptsURL2ClassMap = new HashMap();
    private List<GroovyScript2RestLoaderPlugin> loadPlugins;
    private Handler handler;

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, Handler handler, InitParams params) {
        this(binder, groovyScriptInstantiator, repositoryService, sessionProviderService, configurationManager, null, handler, params);
    }

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, RegistryService registryService, Handler handler, InitParams params) {
        this.binder = binder;
        this.groovyScriptInstantiator = groovyScriptInstantiator;
        this.repositoryService = repositoryService;
        this.handler = handler;
        this.configurationManager = configurationManager;
        this.registryService = registryService;
        this.sessionProviderService = sessionProviderService;
        this.initParams = params;
    }

    public void unloadScript(URL url) {
        this.unloadScript(url.toString());
    }

    public void unloadScript(String key) {
        if (this.scriptsURL2ClassMap.containsKey(key)) {
            if (this.binder.unbind(this.scriptsURL2ClassMap.get(key))) {
                this.scriptsURL2ClassMap.remove(key);
                LOG.info((Object)("Remove groovy script, key " + key));
            } else {
                LOG.warn((Object)("Can't remove groovy script, key " + key));
            }
        } else {
            LOG.warn((Object)("Specified key '" + key + "' does not corresponds to any class name."));
        }
    }

    public boolean isLoaded(String key) {
        return this.scriptsURL2ClassMap.containsKey(key);
    }

    public boolean isLoaded(URL url) {
        return this.isLoaded(url.toString());
    }

    public String getNodeType() {
        if (this.nodeType == null) {
            throw new IllegalStateException("Node type not initialized, yet. ");
        }
        return this.nodeType;
    }

    public void loadScript(URL url) throws IOException {
        Object resource = this.groovyScriptInstantiator.instantiateScript(url);
        if (this.binder.bind(resource)) {
            this.scriptsURL2ClassMap.put(url.toString(), resource.getClass());
            LOG.info((Object)("Add new groovy scripts, URL: " + url));
        } else {
            LOG.warn((Object)("Groovy script was not binded, URL: " + url));
        }
    }

    public void loadScript(String key, InputStream stream) throws IOException {
        Object resource = this.groovyScriptInstantiator.instantiateScript(stream);
        if (this.binder.bind(resource)) {
            this.scriptsURL2ClassMap.put(key, resource.getClass());
            LOG.info((Object)("Add new groovy scripts, script key: " + key));
        } else {
            LOG.warn((Object)("Groovy script was not binded, key: " + key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    LOG.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
        this.addScripts();
        try {
            String repositoryName = this.observationListenerConfiguration.getRepository();
            List<String> workspaceNames = this.observationListenerConfiguration.getWorkspaces();
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            for (String workspaceName : workspaceNames) {
                Session session = repository.getSystemSession(workspaceName);
                String xpath = "//element(*, " + this.getNodeType() + ")[@exo:autoload='true']";
                Query query = session.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    if (node.getPath().startsWith("/jcr:system")) continue;
                    UnifiedNodeReference unifiedNodeReference = new UnifiedNodeReference(repositoryName, workspaceName, node.getPath());
                    this.loadScript(unifiedNodeReference.getURL().toString(), node.getProperty("jcr:data").getStream());
                }
                session.getWorkspace().getObservationManager().addEventListener((EventListener)new GroovyScript2RestUpdateListener(repositoryName, workspaceName, this, session), 28, "/", true, null, new String[]{this.getNodeType()}, false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurs ", (Throwable)e);
        }
        this.binder.bind((Object)this);
    }

    public void stop() {
    }

    public void addPlugin(ComponentPlugin cp) {
        if (cp instanceof GroovyScript2RestLoaderPlugin) {
            if (this.loadPlugins == null) {
                this.loadPlugins = new ArrayList<GroovyScript2RestLoaderPlugin>();
            }
            this.loadPlugins.add((GroovyScript2RestLoaderPlugin)cp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScripts() {
        if (this.loadPlugins == null || this.loadPlugins.size() == 0) {
            return;
        }
        for (GroovyScript2RestLoaderPlugin loadPlugin : this.loadPlugins) {
            if (loadPlugin.getXMLConfigs().size() == 0) continue;
            Session session = null;
            try {
                ManageableRepository repository = this.repositoryService.getRepository(loadPlugin.getRepository());
                String workspace = loadPlugin.getWorkspace();
                session = repository.getSystemSession(workspace);
                String nodeName = loadPlugin.getNode();
                Node node = null;
                try {
                    node = (Node)session.getItem(nodeName);
                }
                catch (PathNotFoundException e) {
                    StringTokenizer tokens = new StringTokenizer(nodeName, "/");
                    node = session.getRootNode();
                    while (tokens.hasMoreTokens()) {
                        String t = tokens.nextToken();
                        if (node.hasNode(t)) {
                            node = node.getNode(t);
                            continue;
                        }
                        node = node.addNode(t, "nt:folder");
                    }
                }
                for (XMLGroovyScript2Rest xg : loadPlugin.getXMLConfigs()) {
                    String scriptName = xg.getName();
                    if (node.hasNode(scriptName)) {
                        LOG.warn((Object)("Node '" + node.getPath() + "/" + scriptName + "' already exists. "));
                        continue;
                    }
                    this.createScript(node, scriptName, xg.isAutoload(), this.configurationManager.getInputStream(xg.getPath()));
                }
                session.save();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed add scripts. ", (Throwable)e);
            }
            finally {
                if (session == null) continue;
                session.logout();
            }
        }
    }

    private Node createScript(Node parent, String name, boolean autoload, InputStream stream) throws Exception {
        Node scriptFile = parent.addNode(name, "nt:file");
        Node script = scriptFile.addNode("jcr:content", this.getNodeType());
        script.setProperty("exo:autoload", autoload);
        script.setProperty("jcr:mimeType", "script/groovy");
        script.setProperty("jcr:lastModified", Calendar.getInstance());
        script.setProperty("jcr:data", stream);
        return scriptFile;
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<<< Read init parametrs from registry service.");
        }
        this.observationListenerConfiguration = new ObservationListenerConfiguration();
        String entryPath = "exo:services/GroovyScript2RestLoader/nodeType";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.nodeType = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/GroovyScript2RestLoader/repository";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.observationListenerConfiguration.setRepository(this.getAttributeSmart(element, "value"));
        entryPath = "exo:services/GroovyScript2RestLoader/workspaces";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        String workspaces = this.getAttributeSmart(element, "value");
        String[] ws = workspaces.split(";");
        ArrayList<String> wsList = new ArrayList<String>();
        for (String w : ws) {
            wsList.add(w);
        }
        this.observationListenerConfiguration.setWorkspaces(wsList);
        LOG.info((Object)("NodeType from RegistryService: " + this.getNodeType()));
        LOG.info((Object)("Repository from RegistryService: " + this.observationListenerConfiguration.getRepository()));
        LOG.info((Object)("Workspaces node from RegistryService: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">>> Save init parametrs in registry service.");
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement("nodeType");
        this.setAttributeSmart(element, "value", this.getNodeType());
        root.appendChild(element);
        StringBuffer sb = new StringBuffer();
        for (String workspace : this.observationListenerConfiguration.getWorkspaces()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(workspace);
        }
        element = doc.createElement("workspaces");
        this.setAttributeSmart(element, "value", sb.toString());
        root.appendChild(element);
        element = doc.createElement("repository");
        this.setAttributeSmart(element, "value", this.observationListenerConfiguration.getRepository());
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        if (this.initParams != null) {
            this.nodeType = this.initParams.getValuesParam("nodetype") != null ? this.initParams.getValueParam("nodetype").getValue() : DEFAULT_NODETYPE;
            ObjectParameter param = this.initParams.getObjectParam("observation.config");
            this.observationListenerConfiguration = (ObservationListenerConfiguration)param.getObject();
        }
        LOG.info((Object)("NodeType from configuration file: " + this.getNodeType()));
        LOG.info((Object)("Repository from configuration file: " + this.observationListenerConfiguration.getRepository()));
        LOG.info((Object)("Workspaces node from configuration file: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    @POST
    @Consumes(value={"script/groovy"})
    @Path(value="{path:.*}/add")
    public Response addScript(InputStream stream, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node node = (Node)ses.getItem(GroovyScript2RestLoader.getPath(path));
            this.createScript(node, GroovyScript2RestLoader.getName(path), false, stream);
            ses.save();
            URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
            Response response = Response.created((URI)location).build();
            return response;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @POST
    @Consumes(value={"script/groovy"})
    @Path(value="{path:.*}/update")
    public Response updateScript(InputStream stream, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node node = (Node)ses.getItem("/" + path);
            node.getNode("jcr:content").setProperty("jcr:data", stream);
            ses.save();
            URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
            Response response = Response.created((URI)location).build();
            return response;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @POST
    @Consumes(value={"multipart/*"})
    @Path(value="{path:.*}/add")
    public Response addScript(Iterator<FileItem> items, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node node = (Node)ses.getItem(GroovyScript2RestLoader.getPath(path));
            InputStream stream = null;
            boolean autoload = false;
            while (items.hasNext()) {
                FileItem fitem = items.next();
                if (fitem.isFormField() && fitem.getFieldName() != null && fitem.getFieldName().equalsIgnoreCase("autoload")) {
                    autoload = Boolean.valueOf(fitem.getString());
                    continue;
                }
                if (fitem.isFormField()) continue;
                stream = fitem.getInputStream();
            }
            this.createScript(node, GroovyScript2RestLoader.getName(path), autoload, stream);
            ses.save();
            URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
            Response response = Response.created((URI)location).build();
            return response;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @POST
    @Consumes(value={"multipart/*"})
    @Path(value="{path:.*}/update")
    public Response updateScripts(Iterator<FileItem> items, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            FileItem fitem = items.next();
            InputStream stream = null;
            if (!fitem.isFormField()) {
                stream = fitem.getInputStream();
            }
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node node = (Node)ses.getItem("/" + path);
            node.getNode("jcr:content").setProperty("jcr:data", stream);
            ses.save();
            URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
            Response response = Response.created((URI)location).build();
            return response;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Produces(value={"script/groovy"})
    @Path(value="{path:.*}/src")
    public InputStream getScript(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node scriptFile = (Node)ses.getItem("/" + path);
            InputStream inputStream = scriptFile.getNode("jcr:content").getProperty("jcr:data").getStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{path:.*}/meta")
    public ScriptMetadata getScriptMetadata(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ScriptMetadata meta;
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
            String unifiedNodePath = new UnifiedNodeReference(repository, workspace, script.getPath()).getURL().toString();
            ScriptMetadata scriptMetadata = meta = new ScriptMetadata(script.getProperty("exo:autoload").getBoolean(), this.isLoaded(unifiedNodePath), script.getProperty("jcr:mimeType").getString(), script.getProperty("jcr:lastModified").getDate().getTimeInMillis());
            return scriptMetadata;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{path:.*}/delete")
    public void deleteScript(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            ses.getItem("/" + path).remove();
            ses.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{path:.*}/autoload")
    public void autoload(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @DefaultValue(value="true") @QueryParam(value="state") boolean state) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
            script.setProperty("exo:autoload", state);
            ses.save();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{path:.*}/load")
    public void load(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @DefaultValue(value="true") @QueryParam(value="state") boolean state) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
            String unifiedNodePath = new UnifiedNodeReference(repository, workspace, script.getPath()).getURL().toString();
            if (this.isLoaded(unifiedNodePath)) {
                this.unloadScript(unifiedNodePath);
            }
            if (state) {
                this.loadScript(unifiedNodePath, script.getProperty("jcr:data").getStream());
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/list")
    public ScriptList list(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @QueryParam(value="name") String name) {
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
            String xpath = "//element(*, exo:groovyResourceContainer)";
            Query query = ses.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<String> scriptList = new ArrayList<String>();
            if (name == null || "".equals(name)) {
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    scriptList.add(node.getParent().getPath());
                }
            } else {
                StringBuffer p = new StringBuffer();
                p.append(".*");
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c == '*' || c == '?') {
                        p.append('.');
                    }
                    if (".()[]^$|".indexOf(c) != -1) {
                        p.append('\\');
                    }
                    p.append(c);
                }
                p.append(".*");
                Pattern pattern = Pattern.compile(p.toString(), 2);
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    String scriptName = node.getParent().getPath();
                    if (!pattern.matcher(scriptName).matches()) continue;
                    scriptList.add(scriptName);
                }
            }
            ScriptList scriptList2 = new ScriptList(scriptList);
            return scriptList2;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private static String getPath(String fullPath) {
        int sl = fullPath.lastIndexOf(47);
        return sl > 0 ? "/" + fullPath.substring(0, sl) : "/";
    }

    private static String getName(String fullPath) {
        int sl = fullPath.lastIndexOf(47);
        return sl >= 0 ? fullPath.substring(sl + 1) : fullPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScriptList {
        private List<String> list;

        public List<String> getList() {
            return this.list;
        }

        public ScriptList(List<String> scriptList) {
            this.list = scriptList;
        }
    }

    public static class ScriptMetadata {
        private final boolean autoload;
        private final boolean load;
        private final String mediaType;
        private final long lastModified;

        public ScriptMetadata(boolean autoload, boolean load, String mediaType, long lastModified) {
            this.autoload = autoload;
            this.load = load;
            this.mediaType = mediaType;
            this.lastModified = lastModified;
        }

        public boolean getAutoload() {
            return this.autoload;
        }

        public boolean getLoad() {
            return this.load;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

