/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test.priority;

import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.ext.replication.ReplicationChannelManager;
import org.exoplatform.services.jcr.ext.replication.WorkspaceDataTransmitter;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BasePriorityTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.BasePriorityTestCase");
    protected WorkspaceDataTransmitter dataTransmitter;

    public BasePriorityTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        WorkspaceContainerFacade wContainer = ((RepositoryImpl)this.repository).getWorkspaceContainer(this.session.getWorkspace().getName());
        this.dataTransmitter = (WorkspaceDataTransmitter)wContainer.getComponent(WorkspaceDataTransmitter.class);
    }

    public StringBuffer disconnectClusterNode() {
        StringBuffer sb = new StringBuffer();
        try {
            ReplicationChannelManager channelManager = this.dataTransmitter.getChannelManager();
            channelManager.setAllowConnect(false);
            channelManager.disconnect();
            channelManager.connect();
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't disconnected node of cluster: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer disconnectClusterNode(int id) {
        StringBuffer sb = new StringBuffer();
        try {
            ReplicationChannelManager channelManager = this.dataTransmitter.getChannelManager();
            channelManager.setAllowConnect(false, id);
            channelManager.disconnect();
            channelManager.connect();
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't disconnected node of cluster: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer allowConnect() {
        StringBuffer sb = new StringBuffer();
        try {
            ReplicationChannelManager channelManager = this.dataTransmitter.getChannelManager();
            channelManager.setAllowConnect(true);
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't allowed connect node of cluster: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer allowConnectForced() {
        StringBuffer sb = new StringBuffer();
        try {
            ReplicationChannelManager channelManager = this.dataTransmitter.getChannelManager();
            channelManager.setAllowConnect(true);
            channelManager.disconnect();
            channelManager.connect();
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't allowed connect node of cluster: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer isReadOnly(String workspaceName) {
        StringBuffer sb = new StringBuffer();
        try {
            WorkspaceContainerFacade wsFacade = ((RepositoryImpl)this.repository).getWorkspaceContainer(workspaceName);
            WorkspaceDataContainer dataContainer = (WorkspaceDataContainer)wsFacade.getComponent(WorkspaceDataContainer.class);
            PersistentDataManager dataManager = (PersistentDataManager)wsFacade.getComponent(PersistentDataManager.class);
            if (!dataManager.isReadOnly()) {
                throw new Exception("The workspace '" + dataContainer.getName() + "' was not read-only");
            }
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Read-only fail ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }
}

