/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.initializer;

import java.io.File;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.initializer.NoMemberToSendException;
import org.exoplatform.services.jcr.ext.initializer.RemoteTransport;
import org.exoplatform.services.jcr.ext.initializer.RemoteWorkspaceInitializationException;
import org.exoplatform.services.jcr.ext.initializer.impl.RemoteTransportImpl;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/jcr-remote-workspace-initializer/")
@Produces(value={"text/plain"})
public class RemoteWorkspaceInitializationService
implements ResourceContainer {
    private static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.RemoteWorkspaceInitializationService");
    private final RepositoryService repositoryService;
    private final BackupManager backupManager;
    private final ThreadLocalSessionProviderService sessionProviderService;
    private final String dataSourceUrl;
    private final String bindIpAddress;
    private final String channelConfig;
    private final String channelName;
    private final File tempDir;

    public RemoteWorkspaceInitializationService(RepositoryService repoService, BackupManager backupManager, ThreadLocalSessionProviderService sessionProviderService, InitParams params) {
        this.repositoryService = repoService;
        this.backupManager = backupManager;
        this.sessionProviderService = sessionProviderService;
        PropertiesParam pps = params.getPropertiesParam("remote-initializer-properties");
        if (pps == null) {
            throw new RuntimeException("remote-initializer-properties not specified");
        }
        if (pps.getProperty("remote-source-url") == null) {
            throw new RuntimeException("remote-source-url not specified");
        }
        this.dataSourceUrl = pps.getProperty("remote-source-url");
        if (pps.getProperty("bind-ip-address") == null) {
            throw new RuntimeException("bind-ip-address not specified");
        }
        this.bindIpAddress = pps.getProperty("bind-ip-address");
        if (pps.getProperty("channel-config") == null) {
            throw new RuntimeException("channel-config not specified");
        }
        this.channelConfig = pps.getProperty("channel-config");
        if (pps.getProperty("channel-name") == null) {
            throw new RuntimeException("channel-name not specified");
        }
        this.channelName = pps.getProperty("channel-name");
        if (pps.getProperty("temp-dir") == null) {
            throw new RuntimeException("temp-dir not specified");
        }
        String tempD = pps.getProperty("temp-dir");
        this.tempDir = new File(tempD);
        if (!PrivilegedFileHelper.exists((File)this.tempDir)) {
            PrivilegedFileHelper.mkdirs((File)this.tempDir);
        }
        log.info((Object)"RemoteWorkspaceInitializerService");
    }

    public File getWorkspaceData(String repository, String workspace) throws RemoteWorkspaceInitializationException {
        String id = IdGenerator.generate();
        ChannelManager channelManager = new ChannelManager(this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIpAddress), this.channelName + "_" + repository + "_" + workspace + "_" + id, 2);
        RemoteTransportImpl remoteTransport = new RemoteTransportImpl(channelManager, this.tempDir, this.dataSourceUrl);
        try {
            remoteTransport.init();
            File file = remoteTransport.getWorkspaceData(repository, workspace, id);
            return file;
        }
        catch (Throwable t) {
            throw new RemoteWorkspaceInitializationException("Can't get workspace data", t);
        }
        finally {
            remoteTransport.close();
        }
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/{id}/getWorkspaceData")
    public Response startFullBackup(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="id") String id) {
        String result = "OK";
        ChannelManager channelManager = new ChannelManager(this.channelConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIpAddress), this.channelName + "_" + repositoryName + "_" + workspaceName + "_" + id, 2);
        RemoteTransportImpl remoteTransport = new RemoteTransportImpl(channelManager, this.tempDir, this.dataSourceUrl);
        try {
            remoteTransport.init();
            BackupConfig config = new BackupConfig();
            config.setBackupType(0);
            config.setRepository(repositoryName);
            config.setWorkspace(workspaceName);
            config.setBackupDir(this.backupManager.getBackupDirectory());
            try {
                this.validateRepositoryName(repositoryName);
                this.validateWorkspaceName(repositoryName, workspaceName);
                BackupChain backupChain = this.backupManager.startBackup(config);
                WorkspaceDataPublisher publisher = new WorkspaceDataPublisher(backupChain, remoteTransport);
                publisher.start();
            }
            catch (Exception e) {
                result = "FAIL\n" + e.getMessage();
                log.error((Object)"Can't start backup", (Throwable)e);
                remoteTransport.close();
            }
        }
        catch (RemoteWorkspaceInitializationException e1) {
            result = "FAIL\n" + e1.getMessage();
            log.error((Object)"Can't initialization transport", (Throwable)e1);
        }
        return Response.ok((Object)result).build();
    }

    private void validateRepositoryName(String repositoryName) {
        try {
            this.repositoryService.getRepository(repositoryName);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Can not get repository '" + repositoryName + "'", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RuntimeException("Can not get repository '" + repositoryName + "'", e);
        }
    }

    private void validateWorkspaceName(String repositoryName, String workspaceName) {
        try {
            Session ses = this.sessionProviderService.getSessionProvider(null).getSession(workspaceName, this.repositoryService.getRepository(repositoryName));
            ses.logout();
        }
        catch (LoginException e) {
            throw new RuntimeException("Can not loogin to workspace '" + workspaceName + "'", e);
        }
        catch (NoSuchWorkspaceException e) {
            throw new RuntimeException("Can not get workspace '" + workspaceName + "'", e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Can not get workspace '" + workspaceName + "'", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RuntimeException("Can not get workspace '" + workspaceName + "'", e);
        }
    }

    class WorkspaceDataPublisher
    extends Thread {
        private static final int BACKUP_WAIT_INTERVAL = 50;
        private BackupChain backupChain;
        private RemoteTransport transport;

        public WorkspaceDataPublisher(BackupChain chain, RemoteTransport transport) {
            super("WorkspaceDataPublisher");
            this.backupChain = chain;
            this.transport = transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    while (this.backupChain.getFullBackupState() != 4) {
                        Thread.yield();
                        Thread.sleep(50L);
                    }
                    String path = this.backupChain.getBackupJobs().get(0).getStorageURL().getPath();
                    RemoteWorkspaceInitializationService.this.backupManager.stopBackup(this.backupChain);
                    this.transport.sendWorkspaceData(new File(path));
                    Thread.sleep(30000L);
                }
                catch (RemoteWorkspaceInitializationException e) {
                    try {
                        this.transport.sendError("Can not send the workspace data : " + e.getMessage());
                    }
                    catch (RemoteWorkspaceInitializationException e1) {
                        log.error((Object)("Can not send error message : " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (BackupOperationException e) {
                    try {
                        this.transport.sendError("Can not send the workspace data : " + e.getMessage());
                    }
                    catch (RemoteWorkspaceInitializationException e1) {
                        log.error((Object)("Can not send error message : " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    try {
                        this.transport.sendError("Can not send the workspace data : " + e.getMessage());
                    }
                    catch (RemoteWorkspaceInitializationException e1) {
                        log.error((Object)("Can not send error message : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (NoMemberToSendException e) {
                log.error((Object)("Can not send the data  : " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.transport.close();
                }
                catch (RemoteWorkspaceInitializationException e) {
                    log.error((Object)("Can not close the transport : " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static final class Constants {
        public static final String BASE_URL = "/rest/jcr-remote-workspace-initializer";

        private Constants() {
        }

        public static final class OperationType {
            public static final String GET_WORKSPACE = "getWorkspaceData";

            private OperationType() {
            }
        }
    }
}

