/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Context;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddMetadataAction
implements Action {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.AddMetadataAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws Exception {
        PropertyImpl property = (PropertyImpl)ctx.get((Object)"currentItem");
        NodeImpl parent = property.getParent();
        if (!parent.isNodeType("nt:resource")) {
            throw new Exception("incoming node is not nt:resource type");
        }
        InputStream data = null;
        try {
            DocumentReaderService readerService;
            int evt2;
            String mimeType;
            if (property.getInternalName().equals((Object)Constants.JCR_DATA)) {
                data = ((ValueData)((PropertyData)property.getData()).getValues().get(0)).getAsStream();
                try {
                    mimeType = parent.getProperty("jcr:mimeType").getString();
                }
                catch (PathNotFoundException e) {
                    boolean bl = false;
                    if (data != null) {
                        data.close();
                    }
                    return bl;
                }
            } else if (property.getInternalName().equals((Object)Constants.JCR_MIMETYPE)) {
                evt2 = (Integer)ctx.get((Object)InvocationContext.EVENT);
                if (evt2 != 4) {
                    boolean bl = false;
                    return bl;
                }
                mimeType = property.getString();
                try {
                    PropertyImpl propertyImpl = (PropertyImpl)parent.getProperty("jcr:data");
                    data = ((ValueData)((PropertyData)propertyImpl.getData()).getValues().get(0)).getAsStream();
                }
                catch (PathNotFoundException e) {
                    boolean bl = false;
                    if (data != null) {
                        data.close();
                    }
                    return bl;
                }
            } else {
                boolean evt2 = false;
                return evt2;
            }
            if (data.available() == 0) {
                evt2 = 0;
                return evt2 != 0;
            }
            if (!parent.isNodeType("dc:elementSet")) {
                parent.addMixin("dc:elementSet");
            }
            if ((readerService = (DocumentReaderService)((ExoContainer)ctx.get((Object)"exocontainer")).getComponentInstanceOfType(DocumentReaderService.class)) == null) {
                throw new IllegalArgumentException("No DocumentReaderService configured for current container");
            }
            Properties props = new Properties();
            try {
                props = readerService.getDocumentReader(mimeType).getProperties(data);
            }
            catch (HandlerNotFoundException e) {
                LOG.debug((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + e.getMessage()));
            }
            catch (DocumentReadException e) {
                this.printWarning(property, (Exception)((Object)e));
            }
            catch (IOException e) {
                this.printWarning(property, e);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                QName qname = (QName)entry.getKey();
                JCRName jcrName = property.getSession().getLocationFactory().createJCRName(new InternalQName(qname.getNamespace(), qname.getName()));
                PropertyDefinitionDatas pds = parent.getSession().getWorkspace().getNodeTypesHolder().getPropertyDefinitions(jcrName.getInternalName(), ((NodeData)parent.getData()).getPrimaryTypeName(), ((NodeData)parent.getData()).getMixinTypeNames());
                if (pds.getDefinition(true) != null) {
                    Value[] values = new Value[]{this.createValue(entry.getValue(), (ValueFactory)property.getSession().getValueFactory())};
                    parent.setProperty(jcrName.getAsString(), values);
                    continue;
                }
                parent.setProperty(jcrName.getAsString(), this.createValue(entry.getValue(), (ValueFactory)property.getSession().getValueFactory()));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    private void printWarning(PropertyImpl property, Exception exception) throws RepositoryException {
        if (PropertyManager.isDevelopping()) {
            LOG.warn((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + exception.getMessage()), (Throwable)exception);
        } else {
            LOG.warn((Object)("Binary value reader error, content by path " + property.getPath() + ", property id " + property.getData().getIdentifier() + " : " + exception.getMessage()));
        }
    }

    private Value createValue(Object obj, ValueFactory factory) throws ValueFormatException {
        if (obj instanceof String) {
            return factory.createValue((String)obj);
        }
        if (obj instanceof Calendar) {
            return factory.createValue((Calendar)obj);
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return factory.createValue(cal);
        }
        throw new ValueFormatException("Unsupported value type " + obj.getClass());
    }
}

