/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.groovy.DefaultGroovyResourceLoader;

public class JcrGroovyResourceLoader
extends DefaultGroovyResourceLoader {
    private static final Log LOG = ExoLogger.getLogger(JcrGroovyResourceLoader.class);

    private static URL[] normalizeJcrURL(URL[] src) throws MalformedURLException {
        URL[] res = new URL[src.length];
        for (int i = 0; i < src.length; ++i) {
            if ("jcr".equals(src[i].getProtocol())) {
                String ref = src[i].getRef();
                if (ref == null) {
                    ref = "/";
                } else if (ref.charAt(ref.length() - 1) != '/') {
                    ref = ref + "/";
                }
                res[i] = new URL(src[i], "#" + ref);
                continue;
            }
            res[i] = src[i];
        }
        return res;
    }

    public JcrGroovyResourceLoader(URL[] roots) throws MalformedURLException {
        super(JcrGroovyResourceLoader.normalizeJcrURL(roots));
    }

    public JcrGroovyResourceLoader(URL root) throws MalformedURLException {
        this(new URL[]{root});
    }

    protected URL getResource(String filename) throws MalformedURLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Process file: " + filename));
        }
        return super.getResource(filename);
    }

    protected URL createURL(URL root, String filename) throws MalformedURLException {
        return "jcr".equals(root.getProtocol()) ? new URL(root, "#" + root.getRef() + filename) : new URL(root, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkResource(URL resource) {
        URLConnection connection = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Try to load resource from URL : " + resource));
            }
            connection = resource.openConnection();
            connection.getInputStream().close();
            boolean bl = true;
            Object var6_5 = null;
            if (connection != null && resource != null && "jcr".equals(resource.getProtocol())) {
                ((JcrURLConnection)connection).disconnect();
            }
            return bl;
        }
        catch (IOException e) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Can't open URL : " + resource));
                }
                boolean bl = false;
                Object var6_6 = null;
                if (connection != null && resource != null && "jcr".equals(resource.getProtocol())) {
                    ((JcrURLConnection)connection).disconnect();
                }
                return bl;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var6_7 = null;
                    if (connection == null || resource == null || !"jcr".equals(resource.getProtocol())) break block8;
                    ((JcrURLConnection)connection).disconnect();
                }
                throw throwable;
            }
        }
    }
}

