/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PendingChangesLog;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

public abstract class AbstractWorkspaceDataReceiver
implements RequestHandler {
    protected static Log log = ExoLogger.getLogger((String)"ext.AbstractWorkspaceDataReceiver");
    private String systemId;
    private MessageDispatcher disp;
    private HashMap<String, PendingChangesLog> mapPendingChangesLog;
    protected ItemDataKeeper dataKeeper;
    private FileCleaner fileCleaner = new FileCleaner(30030L);

    public AbstractWorkspaceDataReceiver() throws RepositoryConfigurationException {
        this.mapPendingChangesLog = new HashMap();
    }

    public void init(MessageDispatcher messageDispatcher, String systemId) {
        this.systemId = systemId;
        this.disp = messageDispatcher;
        this.disp.setRequestHandler((RequestHandler)this);
    }

    public void receive(ItemStateChangesLog changesLog_) throws Exception {
        TransactionChangesLog changesLog = (TransactionChangesLog)changesLog_;
        if (changesLog.getSystemId() == null) {
            throw new Exception("Invalid or same systemId " + changesLog.getSystemId());
        }
        if (!changesLog.getSystemId().equals(this.systemId)) {
            if (log.isDebugEnabled()) {
                ChangesLogIterator logIterator = changesLog.getLogIterator();
                while (logIterator.hasNextLog()) {
                    PlainChangesLog pcl = logIterator.nextLog();
                    log.info((Object)pcl.dump());
                }
            }
            this.dataKeeper.save((ItemStateChangesLog)changesLog);
        }
    }

    public Object handle(Message msg) {
        try {
            Packet packet = Packet.getAsPacket(msg.getBuffer());
            switch (packet.getPacketType()) {
                case 1: {
                    TransactionChangesLog changesLog = PendingChangesLog.getAsItemDataChangesLog(packet.getByteArray());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received-->ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of received packet --> " + packet.getByteArray().length));
                        log.debug((Object)("Size of ItemStates          --> " + changesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                    }
                    this.receive((ItemStateChangesLog)changesLog);
                    break;
                }
                case 2: {
                    TransactionChangesLog changesLog = PendingChangesLog.getAsItemDataChangesLog(packet.getByteArray());
                    PendingChangesLog container = new PendingChangesLog(changesLog, packet.getIdentifier(), 2, this.fileCleaner);
                    this.mapPendingChangesLog.put(packet.getIdentifier(), container);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Item DataChangesLog of type 'ItemDataChangesLog first whith stream'");
                    break;
                }
                case 10: {
                    PendingChangesLog bigChangesLogWhithStream = new PendingChangesLog(packet.getIdentifier(), (int)packet.getSize());
                    bigChangesLogWhithStream.putData((int)packet.getOffset(), packet.getByteArray());
                    this.mapPendingChangesLog.put(packet.getIdentifier(), bigChangesLogWhithStream);
                    break;
                }
                case 11: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    break;
                }
                case 12: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    TransactionChangesLog tempChangesLog = PendingChangesLog.getAsItemDataChangesLog(container.getData());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Recive-->Big ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of recive damp --> " + container.getData().length));
                        log.debug((Object)("ItemStates          --> " + tempChangesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                        log.debug((Object)"Item big DataChangesLog of type 'ItemDataChangesLog only'");
                    }
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    container = new PendingChangesLog(tempChangesLog, packet.getIdentifier(), 2, this.fileCleaner);
                    this.mapPendingChangesLog.put(packet.getIdentifier(), container);
                    break;
                }
                case 3: {
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.getFixupStreams().add(packet.getFixupStream());
                    File f = File.createTempFile("tempFile" + packet.getIdentifier() + IdGenerator.generate(), ".tmp");
                    container.getListFile().add(f);
                    container.getListRandomAccessFiles().add(new RandomAccessFile(f, "rw"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"First pocket of stream");
                    }
                    break;
                }
                case 4: {
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getFixupStream());
                    if (randomAccessFile != null) {
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Pocket of stream : " + packet.getByteArray().length + " bytes"));
                    }
                    break;
                }
                case 5: {
                    if (!this.mapPendingChangesLog.containsKey(packet.getIdentifier())) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    RandomAccessFile randomAccessFile = container.getRandomAccessFile(packet.getFixupStream());
                    if (randomAccessFile != null) {
                        randomAccessFile.seek(packet.getOffset());
                        randomAccessFile.write(packet.getByteArray());
                        randomAccessFile.close();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Last pocket of stream : " + packet.getByteArray().length + " bytes"));
                    }
                    break;
                }
                case 6: {
                    TransactionChangesLog dataChangesLog;
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) != null) {
                        this.mapPendingChangesLog.get(packet.getIdentifier()).restore();
                    }
                    if ((dataChangesLog = this.mapPendingChangesLog.get(packet.getIdentifier()).getItemDataChangesLog()) == null) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Send-->ItemDataChangesLog_with_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("ItemStates   --> " + dataChangesLog.getAllStates().size()));
                        log.debug((Object)("Streams      --> " + this.mapPendingChangesLog.get(packet.getIdentifier()).getInputStreams().size()));
                        log.debug((Object)"---------------------");
                    }
                    this.receive((ItemStateChangesLog)dataChangesLog);
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                    break;
                }
                case 7: {
                    PendingChangesLog bigChangesLog = new PendingChangesLog(packet.getIdentifier(), (int)packet.getSize());
                    bigChangesLog.putData((int)packet.getOffset(), packet.getByteArray());
                    this.mapPendingChangesLog.put(packet.getIdentifier(), bigChangesLog);
                    break;
                }
                case 8: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    break;
                }
                case 9: {
                    if (this.mapPendingChangesLog.get(packet.getIdentifier()) == null) break;
                    PendingChangesLog container = this.mapPendingChangesLog.get(packet.getIdentifier());
                    container.putData((int)packet.getOffset(), packet.getByteArray());
                    TransactionChangesLog tempChangesLog = PendingChangesLog.getAsItemDataChangesLog(container.getData());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Recive-->Big ItemDataChangesLog_without_Streams-->");
                        log.debug((Object)"---------------------");
                        log.debug((Object)("Size of recive damp --> " + container.getData().length));
                        log.debug((Object)("ItemStates          --> " + tempChangesLog.getAllStates().size()));
                        log.debug((Object)"---------------------");
                        log.debug((Object)"Item big DataChangesLog of type 'ItemDataChangesLog only'");
                    }
                    this.receive((ItemStateChangesLog)tempChangesLog);
                    this.mapPendingChangesLog.remove(packet.getIdentifier());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String("Success !");
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }
}

