/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.resource.jcr.Handler;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestUpdateListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ResourceBinder;
import org.exoplatform.services.rest.container.InvalidResourceDescriptorException;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;
import org.picocontainer.Startable;

public class GroovyScript2RestLoader
implements Startable {
    public static final String DEFAULT_NODETYPE = "exo:groovyResourceContainer";
    private static final Log Log = ExoLogger.getLogger((String)"jcr.script.GroovyScript2RestLoader");
    private ResourceBinder binder;
    private GroovyScriptInstantiator groovyScriptInstantiator;
    private Handler handler;
    private RepositoryService repositoryService;
    private ObservationListenerConfiguration observationListenerConfiguration;
    private String nodeType;
    private Map<String, String> scriptsURL2ClassName = new HashMap<String, String>();

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, Handler handler, RepositoryService repositoryService, InitParams params) {
        this.binder = binder;
        this.groovyScriptInstantiator = groovyScriptInstantiator;
        this.repositoryService = repositoryService;
        this.handler = handler;
        if (params != null) {
            this.nodeType = params.getValuesParam("nodetype") != null ? params.getValueParam("nodetype").getValue() : DEFAULT_NODETYPE;
            ObjectParameter param = params.getObjectParam("observation.config");
            if (param != null) {
                this.observationListenerConfiguration = (ObservationListenerConfiguration)param.getObject();
            }
        }
    }

    public void unloadScript(URL url) {
        this.unloadScript(url.toString());
    }

    public void unloadScript(String key) {
        if (!this.scriptsURL2ClassName.containsKey(key)) {
            throw new IllegalArgumentException("Specified key '" + key + "' does not corresponds to any class name.");
        }
        this.binder.unbind(this.scriptsURL2ClassName.get(key));
        this.scriptsURL2ClassName.remove(key);
    }

    public void loadScript(URL url) throws InvalidResourceDescriptorException, IOException {
        ResourceContainer resourceContainer = (ResourceContainer)this.groovyScriptInstantiator.instantiateScript(url);
        this.binder.bind(resourceContainer);
        this.scriptsURL2ClassName.put(url.toString(), resourceContainer.getClass().getName());
        Log.info((Object)("Add new groovy scripts, URL: " + url));
    }

    public void loadScript(String key, InputStream stream) throws InvalidResourceDescriptorException, IOException {
        ResourceContainer resourceContainer = (ResourceContainer)this.groovyScriptInstantiator.instantiateScript(stream);
        this.binder.bind(resourceContainer);
        this.scriptsURL2ClassName.put(key, resourceContainer.getClass().getName());
        Log.info((Object)("Add new groovy scripts, script key: " + key));
    }

    public void start() {
        if (this.observationListenerConfiguration == null) {
            return;
        }
        try {
            String repositoryName = this.observationListenerConfiguration.getRepository();
            List<String> workspaceNames = this.observationListenerConfiguration.getWorkspaces();
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            for (String workspaceName : workspaceNames) {
                Session session = repository.getSystemSession(workspaceName);
                session.getWorkspace().getObservationManager().addEventListener((EventListener)new GroovyScript2RestUpdateListener(repositoryName, workspaceName, this, session), 20, "/", true, null, new String[]{this.nodeType}, false);
                String xpath = "//element(*, " + this.nodeType + ")[@exo:autoload='true']";
                Query query = session.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    if (node.getPath().startsWith("/jcr:system")) continue;
                    UnifiedNodeReference unifiedNodeReference = new UnifiedNodeReference(repositoryName, workspaceName, node.getPath());
                    this.loadScript(unifiedNodeReference.getURL().toString(), node.getProperty("jcr:data").getStream());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObservationListenerConfiguration {
        private String repository;
        private List<String> workspaces;

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public List<String> getWorkspaces() {
            return this.workspaces;
        }

        public void setWorkspaces(List<String> workspaces) {
            this.workspaces = workspaces;
        }
    }
}

