/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.jcr;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.picocontainer.Startable;

public class Handler
extends URLStreamHandler
implements Startable {
    private static final String protocolPathPkg = "org.exoplatform.services.jcr.ext.resource";
    private static Authenticator authenticator_;
    private static RepositoryService repositoryService_;
    private static NodeRepresentationService nodeRepresentationService_;
    private static ThreadLocal<SessionProvider> sessionProviderKeeper;

    public Handler(Authenticator authenticator, RepositoryService repositoryService, NodeRepresentationService nodeRepresentationService) {
        authenticator_ = authenticator;
        repositoryService_ = repositoryService;
        nodeRepresentationService_ = nodeRepresentationService;
    }

    public Handler() {
    }

    protected URLConnection openConnection(URL url) throws IOException {
        try {
            String repositoryName;
            UnifiedNodeReference nodeReference = new UnifiedNodeReference(url);
            SessionProvider sp = sessionProviderKeeper.get();
            ConversationState conversationState = ConversationState.getCurrent();
            if (sp == null && conversationState != null) {
                sp = (SessionProvider)conversationState.getAttribute("JCRsessionProvider");
            }
            if (sp == null) {
                Credential[] cred = Handler.parseCredentials(nodeReference.getUserInfo());
                if (cred == null) {
                    sp = conversationState == null ? SessionProvider.createAnonimProvider() : new SessionProvider(conversationState);
                } else {
                    String userId = authenticator_.validateUser(cred);
                    sp = new SessionProvider(new ConversationState(authenticator_.createIdentity(userId)));
                }
            }
            ManageableRepository repository = (repositoryName = nodeReference.getRepository()) != null || repositoryName.length() > 0 ? repositoryService_.getRepository(repositoryName) : sp.getCurrentRepository();
            String workspaceName = nodeReference.getWorkspace();
            if (workspaceName == null || workspaceName.length() == 0) {
                workspaceName = sp.getCurrentWorkspace();
            }
            Session ses = sp.getSession(workspaceName, repository);
            JcrURLConnection conn = new JcrURLConnection(nodeReference, ses, nodeRepresentationService_);
            return conn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!");
        }
    }

    public void start() {
        String existingProtocolPathPkgs = System.getProperty("java.protocol.handler.pkgs");
        if (existingProtocolPathPkgs == null) {
            System.setProperty("java.protocol.handler.pkgs", protocolPathPkg);
        } else if (existingProtocolPathPkgs.indexOf(protocolPathPkg) == -1) {
            System.setProperty("java.protocol.handler.pkgs", existingProtocolPathPkgs + "|" + protocolPathPkg);
        }
    }

    public void stop() {
    }

    public void setSessionProvider(SessionProvider sessionProvider) {
        sessionProviderKeeper.set(sessionProvider);
    }

    public void removeSessionProvider() {
        sessionProviderKeeper.get().close();
        sessionProviderKeeper.remove();
    }

    private static Credential[] parseCredentials(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        int colon = userInfo.indexOf(58);
        if (colon > 0) {
            return new Credential[]{new UsernameCredential(userInfo.substring(0, colon)), new PasswordCredential(userInfo.substring(colon + 1))};
        }
        if (colon < 0) {
            return new Credential[]{new UsernameCredential(userInfo)};
        }
        return null;
    }

    static {
        sessionProviderKeeper = new ThreadLocal();
    }
}

