/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.logging.Log;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationFactory;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRepresentationService
implements Startable {
    private Map<String, NodeRepresentationFactory> factories = new HashMap<String, NodeRepresentationFactory>();
    ExoContainerContext containerContext;
    private static final Log log = ExoLogger.getLogger((String)"jcr.ext.resource.NodeRepresentationService");

    public NodeRepresentationService(ExoContainerContext containerContext) {
        this.containerContext = containerContext;
    }

    public void addNodeRepresentationFactory(String nodeType, NodeRepresentationFactory representationFactory) {
        this.factories.put(nodeType, representationFactory);
    }

    public NodeRepresentation getNodeRepresentation(Node node, String mediaTypeHint) throws RepositoryException {
        NodeRepresentationFactory factory = this.factory(node);
        if (factory != null) {
            return factory.createNodeRepresentation(node, mediaTypeHint);
        }
        return new DocViewNodeRepresentation(node);
    }

    public Collection<String> getNodeTypes() {
        return this.factories.keySet();
    }

    public void start() {
        ExoContainer container = this.containerContext.getContainer();
        List list = container.getComponentInstancesOfType(NodeRepresentationFactory.class);
        for (NodeRepresentationFactory f : list) {
            this.addNodeRepresentationFactory(f.getNodeType(), f);
        }
    }

    public void stop() {
    }

    private NodeRepresentationFactory factory(Node node) throws RepositoryException {
        NodeRepresentationFactory f = this.factories.get(node.getPrimaryNodeType().getName());
        if (f == null) {
            for (String nt : this.factories.keySet()) {
                if (!node.isNodeType(nt)) continue;
                f = this.factories.get(nt);
                break;
            }
        }
        if (f == null) {
            for (NodeType mixin : node.getMixinNodeTypes()) {
                f = this.factories.get(mixin.getName());
                if (f == null) continue;
                return f;
            }
        }
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocViewNodeRepresentation
    implements NodeRepresentation {
        private Node node;

        public DocViewNodeRepresentation(Node node) {
            this.node = node;
        }

        @Override
        public String getContentEncoding() {
            return "UTF-8";
        }

        @Override
        public long getContentLenght() throws RepositoryException {
            return -1L;
        }

        @Override
        public String getMediaType() throws RepositoryException {
            return "text/xml";
        }

        @Override
        public long getLastModified() throws RepositoryException {
            return 0L;
        }

        @Override
        public HierarchicalProperty getProperty(String name) throws RepositoryException {
            return null;
        }

        @Override
        public Collection<String> getPropertyNames() throws RepositoryException {
            return new ArrayList<String>();
        }

        @Override
        public InputStream getInputStream() throws IOException, RepositoryException {
            PipedInputStream pin = new PipedInputStream();
            final PipedOutputStream pout = new PipedOutputStream(pin);
            try {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            DocViewNodeRepresentation.this.node.getSession().exportDocumentView(DocViewNodeRepresentation.this.node.getPath(), (OutputStream)pout, false, false);
                        }
                        catch (Exception e) {
                        }
                        finally {
                            try {
                                pout.flush();
                                pout.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }.start();
                return pin;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("can't get input stream");
            }
        }

        @Override
        public Node getNode() {
            return this.node;
        }
    }
}

