/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.services.jcr.ext.replication.FixupStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packet
implements Externalizable {
    private static final long serialVersionUID = -238898618077133064L;
    public static final int MAX_PACKET_SIZE = 16384;
    private byte[] buffer_;
    private long size_;
    private int type_;
    private long offset_;
    private String identifier;
    private FixupStream fixupStream;
    private String ownName = new String(" ");
    private Calendar timeStamp = Calendar.getInstance();
    private String fileName = new String(" ");
    private String systemId = new String(" ");
    private List<String> fileNameList = new ArrayList<String>();

    public Packet() {
    }

    public Packet(int type, long size, byte[] buffer, String identifier_) {
        this.identifier = identifier_;
        this.type_ = type;
        this.size_ = size;
        this.buffer_ = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            this.buffer_[i] = buffer[i];
        }
        this.fixupStream = new FixupStream();
    }

    public Packet(int type, String identifier_) {
        this.type_ = type;
        this.identifier = identifier_;
        this.buffer_ = new byte[1];
        this.fixupStream = new FixupStream();
    }

    public Packet(int type, String identifier_, String ownName_) {
        this.type_ = type;
        this.identifier = identifier_;
        this.buffer_ = new byte[1];
        this.fixupStream = new FixupStream();
        this.ownName = ownName_;
    }

    public Packet(int type, String identifier_, String ownName_, String fileName) {
        this(type, identifier_, ownName_);
        this.fileName = fileName;
    }

    public Packet(int type, String identifier_, String ownName_, List<String> fileNameList) {
        this(type, identifier_, ownName_);
        this.fileNameList = fileNameList;
    }

    public Packet(int type, FixupStream fs, String identifier_) {
        this.type_ = type;
        this.fixupStream = fs;
        this.identifier = identifier_;
        this.buffer_ = new byte[1];
    }

    public Packet(int type, FixupStream fs, String identifier_, byte[] buf) {
        this.type_ = type;
        this.fixupStream = fs;
        this.identifier = identifier_;
        this.buffer_ = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            this.buffer_[i] = buf[i];
        }
    }

    public Packet(int type, String identifier_, String ownName, Calendar timeStamp) {
        this(type, identifier_, ownName);
        this.timeStamp = timeStamp;
    }

    public Packet(int type, String ownName, long size, String identifier) {
        this(type, identifier, ownName);
        this.size_ = size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.buffer_.length);
        out.write(this.buffer_);
        out.writeLong(this.size_);
        out.writeInt(this.type_);
        out.writeLong(this.offset_);
        out.writeInt(this.identifier.getBytes().length);
        out.write(this.identifier.getBytes());
        out.writeInt(this.fixupStream.getItemSateId());
        out.writeInt(this.fixupStream.getValueDataId());
        out.writeInt(this.ownName.getBytes().length);
        out.write(this.ownName.getBytes());
        out.writeLong(this.timeStamp.getTimeInMillis());
        out.writeInt(this.fileName.getBytes().length);
        out.write(this.fileName.getBytes());
        out.writeInt(this.fileNameList.size());
        for (String fName : this.fileNameList) {
            out.writeInt(fName.getBytes().length);
            out.write(fName.getBytes());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int bufSize = in.readInt();
        this.buffer_ = new byte[bufSize];
        in.readFully(this.buffer_);
        this.size_ = in.readLong();
        this.type_ = in.readInt();
        this.offset_ = in.readLong();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.identifier = new String(buf);
        int item = in.readInt();
        int value = in.readInt();
        this.fixupStream = new FixupStream(item, value);
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.ownName = new String(buf);
        this.timeStamp.setTimeInMillis(in.readLong());
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.fileName = new String(buf);
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.fileNameList.add(new String(buf));
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public byte[] getByteArray() {
        return this.buffer_;
    }

    public long getSize() {
        return this.size_;
    }

    public void setSize(long size) {
        this.size_ = size;
    }

    public int getPacketType() {
        return this.type_;
    }

    public long getOffset() {
        return this.offset_;
    }

    public void setOffset(long offset) {
        this.offset_ = offset;
    }

    public FixupStream getFixupStream() {
        return this.fixupStream;
    }

    public void setFixupStream(FixupStream fs) {
        this.fixupStream = fs;
    }

    public static byte[] getAsByteArray(Packet packet) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(packet);
        byte[] bArray = os.toByteArray();
        return bArray;
    }

    public static Packet getAsPacket(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(is);
        Packet objRead = (Packet)ois.readObject();
        return objRead;
    }

    public String getOwnerName() {
        return this.ownName;
    }

    public void setOwnName(String ownName) {
        this.ownName = ownName;
    }

    public Calendar getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Calendar timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<String> getFileNameList() {
        return this.fileNameList;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public class PacketType {
        public static final int ItemDataChangesLog = 1;
        public static final int First_ItemDataChangesLog_with_Streams = 2;
        public static final int First_Packet_of_Stream = 3;
        public static final int Packet_of_Stream = 4;
        public static final int Last_Packet_of_Stream = 5;
        public static final int Last_ItemDataChangesLog_with_Streams = 6;
        public static final int ItemDataChangesLog_First_Packet = 7;
        public static final int ItemDataChangesLog_Middle_Packet = 8;
        public static final int ItemDataChangesLog_Last_Packet = 9;
        public static final int ItemDataChangesLog_with_Stream_First_Packet = 10;
        public static final int ItemDataChangesLog_with_Stream_Middle_Packet = 11;
        public static final int ItemDataChangesLog_with_Stream_Last_Packet = 12;
        public static final int ADD_OK = 13;
        public static final int GET_ChangesLog_up_to_DATE = 14;
        public static final int BinaryFile_First_Packet = 15;
        public static final int BinaryFile_Middle_Packet = 16;
        public static final int BinaryFile_Last_Packet = 17;
        public static final int ALL_BinaryFile_transferred_OK = 18;
        public static final int ALL_ChangesLog_saved_OK = 19;
        public static final int SYNCHRONIZED_OK = 20;
        public static final int INITED_IN_CLUSTER = 21;
        public static final int ALL_INITED = 22;
        public static final int OLD_ChangesLog_removed_OK = 23;
        public static final int NEED_TRANSFER_COUNTER = 24;
        public static final int REMOVED_OLD_CHANGESLOG_COUNTER = 25;
        public static final int MEMBER_STARTED = 26;
        public static final int BIG_PACKET_FIRST = 27;
        public static final int BIG_PACKET_MIDDLE = 28;
        public static final int BIG_PACKET_LAST = 29;
        public static final int GET_ALL_PRIORITY = 30;
        public static final int OWN_PRIORITY = 31;
    }
}

