/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PacketListener;
import org.exoplatform.services.jcr.ext.replication.priority.MemberListener;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPriorityChecker
implements PacketListener {
    public static int MAX_PRIORITY = 100;
    protected static Log log = ExoLogger.getLogger((String)"ext.PriorityChecker");
    protected final ChannelManager channelManager;
    protected final int ownPriority;
    protected final String ownName;
    protected final List<String> otherPartisipants;
    protected HashMap<String, Integer> currentPartisipants;
    protected String identifier;
    protected MemberListener memberListener;

    public AbstractPriorityChecker(ChannelManager channelManager, int ownPriority, String ownName, List<String> otherParticipants) {
        this.ownPriority = ownPriority;
        this.ownName = ownName;
        this.otherPartisipants = new ArrayList<String>(otherParticipants);
        this.channelManager = channelManager;
        this.channelManager.addPacketListener(this);
        this.currentPartisipants = new HashMap();
    }

    @Override
    public abstract void receive(Packet var1);

    public void informAll() {
        try {
            this.identifier = IdGenerator.generate();
            this.currentPartisipants = new HashMap();
            Packet pktInformer = new Packet(30, this.ownName, this.ownPriority, this.identifier);
            this.channelManager.sendPacket(pktInformer);
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            log.error((Object)"Can not informed the other participants", (Throwable)e);
        }
    }

    protected void printOnlineMembers() {
        log.debug((Object)(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " :"));
        for (String memberName : this.currentPartisipants.keySet()) {
            log.debug((Object)("    " + memberName + ":" + this.currentPartisipants.get(memberName)));
        }
    }

    public void setMemberListener(MemberListener memberListener) {
        this.memberListener = memberListener;
    }

    public abstract boolean isMaxPriority();

    public boolean isMaxOnline() {
        if (this.ownPriority == MAX_PRIORITY) {
            return true;
        }
        for (String nodeName : this.currentPartisipants.keySet()) {
            if (this.currentPartisipants.get(nodeName) != MAX_PRIORITY) continue;
            return true;
        }
        return false;
    }

    public boolean isAllOnline() {
        return this.otherPartisipants.size() == this.currentPartisipants.size();
    }
}

