/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.recovery.FileNameFactory;
import org.exoplatform.services.jcr.ext.replication.recovery.PendingConfirmationChengesLog;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoverySynchronizer;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryWriter;
import org.exoplatform.services.jcr.ext.replication.recovery.WaitConfirmation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryManager {
    protected static Log log = ExoLogger.getLogger((String)"ext.RecoveryManager");
    private FileNameFactory fileNameFactory;
    private RecoveryWriter recoveryWriter;
    private File recoveryDir;
    private FileCleaner fileCleaner;
    private Calendar timeStamp;
    private String ownName;
    private String repoName;
    private String wsName;
    private long waitConformationTimeout;
    private volatile HashMap<String, PendingConfirmationChengesLog> mapPendingConfirmation;
    private RecoverySynchronizer recoverySynchronizer;
    private ItemDataKeeper dataKeeper;
    private ChannelManager channelManager;
    private List<String> participantsClusterList;
    private List<String> initedParticipantsClusterList;
    private boolean isAllInited;

    public RecoveryManager(File recoveryDir, String ownName, String systemId, List<String> participantsClusterList, long waitConformation, String repoName, String wsName, ChannelManager channelManager) throws IOException {
        this.recoveryDir = recoveryDir;
        this.fileCleaner = new FileCleaner();
        this.ownName = ownName;
        this.participantsClusterList = new ArrayList<String>(participantsClusterList);
        log.info((Object)("init : other participants = " + participantsClusterList.size()));
        this.repoName = repoName;
        this.wsName = wsName;
        this.channelManager = channelManager;
        this.fileNameFactory = new FileNameFactory();
        this.recoveryWriter = new RecoveryWriter(recoveryDir, this.fileNameFactory, this.fileCleaner, ownName);
        this.mapPendingConfirmation = new HashMap();
        this.waitConformationTimeout = waitConformation;
        this.recoverySynchronizer = new RecoverySynchronizer(recoveryDir, this.fileNameFactory, this.fileCleaner, channelManager, ownName, this.recoveryWriter, systemId);
        this.initedParticipantsClusterList = new ArrayList<String>();
        this.isAllInited = false;
    }

    public void save(ItemStateChangesLog log, String identifier) throws FileNotFoundException, IOException {
        this.timeStamp = Calendar.getInstance();
        PendingConfirmationChengesLog confirmationChengesLog = new PendingConfirmationChengesLog(log, this.timeStamp, identifier);
        this.mapPendingConfirmation.put(identifier, confirmationChengesLog);
        WaitConfirmation waitConfirmationThread = new WaitConfirmation(this.waitConformationTimeout, this, identifier);
        waitConfirmationThread.start();
    }

    public void confirmationChengesLogSave(Packet packet) {
        PendingConfirmationChengesLog confirmationChengesLog = this.mapPendingConfirmation.get(packet.getIdentifier());
        if (confirmationChengesLog != null) {
            if (!confirmationChengesLog.getConfirmationList().contains(packet.getOwnerName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.ownName + ": Confirmation ChangesLog form : " + packet.getOwnerName()));
                    log.debug((Object)("Beefor: Confirmation list size : " + confirmationChengesLog.getConfirmationList().size()));
                }
                confirmationChengesLog.getConfirmationList().add(packet.getOwnerName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("After: Confirmation list size : " + confirmationChengesLog.getConfirmationList().size()));
                }
            }
        } else {
            try {
                this.recoveryWriter.removeChangesLog(packet.getIdentifier(), packet.getOwnerName());
            }
            catch (IOException e) {
                log.error((Object)"Can't remove : ", (Throwable)e);
            }
        }
    }

    public void removeChangesLog(String identifier, String ownerName) throws IOException {
        this.recoveryWriter.removeChangesLog(identifier, ownerName);
    }

    public String save(String identifier) throws FileNotFoundException, IOException {
        PendingConfirmationChengesLog confirmationChengesLog = this.mapPendingConfirmation.get(identifier);
        String fileName = this.recoveryWriter.save(confirmationChengesLog);
        return fileName;
    }

    public void saveRemovableChangesLog(String fileName) throws IOException {
        this.recoveryWriter.saveRemoveChangesLog(fileName);
    }

    public void remove(String identifier) {
        this.mapPendingConfirmation.remove(identifier);
    }

    public PendingConfirmationChengesLog getPendingConfirmationChengesLogById(String identifier) throws Exception {
        if (this.mapPendingConfirmation.containsKey(identifier)) {
            return this.mapPendingConfirmation.get(identifier);
        }
        throw new Exception("Can't find the PendingConfirmationChengesLog by identifier : " + identifier);
    }

    public int processing(Packet packet, int stat) throws Exception {
        int state = stat;
        switch (packet.getPacketType()) {
            case 13: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                this.confirmationChengesLogSave(packet);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)(this.ownName + " : ADD_OK : " + packet.getOwnerName()));
                break;
            }
            case 14: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 15: {
                if (!this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 16: {
                if (!this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 17: {
                if (!this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 18: {
                if (!this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 19: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 20: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                state = this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 21: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                if (!this.initedParticipantsClusterList.contains(packet.getOwnerName())) {
                    this.initedParticipantsClusterList.add(packet.getOwnerName());
                    this.recoverySynchronizer.updateInitedParticipantsClusterList(this.initedParticipantsClusterList);
                    Packet initedPacket = new Packet(21, IdGenerator.generate(), this.ownName);
                    this.channelManager.sendPacket(initedPacket);
                }
                if (this.initedParticipantsClusterList.size() != this.participantsClusterList.size()) break;
                Packet allInitedPacket = new Packet(22, IdGenerator.generate(), this.ownName);
                this.channelManager.sendPacket(allInitedPacket);
                break;
            }
            case 22: {
                if (!this.ownName.equals(packet.getOwnerName()) || this.isAllInited || state == 1) break;
                stat = 1;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ALL_INITED : start recovery");
                }
                this.isAllInited = true;
                break;
            }
            case 24: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 25: {
                if (this.ownName.equals(packet.getOwnerName())) break;
                this.recoverySynchronizer.processingPacket(packet, state);
                break;
            }
            case 26: {
                if (this.ownName.equals(packet.getOwnerName()) || !this.initedParticipantsClusterList.contains(packet.getOwnerName())) break;
                this.isAllInited = false;
                this.initedParticipantsClusterList.remove(packet.getOwnerName());
            }
        }
        return state;
    }

    public void setDataKeeper(ItemDataKeeper dataKeeper) {
        this.dataKeeper = dataKeeper;
        this.recoverySynchronizer.setDataKeeper(dataKeeper);
    }

    public List<String> getParticipantsClusterList() {
        return this.participantsClusterList;
    }

    public void startRecovery() {
        this.recoverySynchronizer.synchronizRepository();
    }
}

