/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.List;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicPriorityChecker
extends AbstractPriorityChecker {
    private int previousPartisipantsCount;
    private int previousMaxPriority;

    public DynamicPriorityChecker(ChannelManager channelManager, int ownPriority, String ownName, List<String> otherParticipants) {
        super(channelManager, ownPriority, ownName, otherParticipants);
    }

    @Override
    public void receive(Packet packet) {
        if (log.isDebugEnabled()) {
            log.info((Object)(" ------->>> MessageListener.receive(), byte == " + packet.getByteArray()));
        }
        try {
            if (!this.ownName.equals(packet.getOwnerName())) {
                switch (packet.getPacketType()) {
                    case 30: {
                        Packet pktMyPriority = new Packet(31, this.ownName, this.ownPriority, packet.getIdentifier());
                        this.channelManager.sendPacket(pktMyPriority);
                        break;
                    }
                    case 31: {
                        if (this.identifier.equals(packet.getIdentifier())) {
                            this.currentPartisipants.put(packet.getOwnerName(), (int)packet.getSize());
                            if (log.isDebugEnabled()) {
                                log.info((Object)(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " : added member :"));
                                log.info((Object)("   +" + packet.getOwnerName() + ":" + this.currentPartisipants.get(packet.getOwnerName())));
                            }
                            if (this.otherPartisipants.size() == this.currentPartisipants.size()) {
                                this.memberListener.memberRejoin();
                            }
                        }
                        if (!log.isDebugEnabled()) break;
                        this.printOnlineMembers();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"An error in processing packet : ", (Throwable)e);
        }
    }

    @Override
    public void informAll() {
        this.previousPartisipantsCount = this.currentPartisipants.size() + 1;
        this.previousMaxPriority = this.getCurrentMaxPriority();
        super.informAll();
    }

    private int getCurrentMaxPriority() {
        int max = Integer.MIN_VALUE;
        for (String nodeName : this.currentPartisipants.keySet()) {
            if ((Integer)this.currentPartisipants.get(nodeName) <= max) continue;
            max = (Integer)this.currentPartisipants.get(nodeName);
        }
        if (this.ownPriority > max) {
            max = this.ownPriority;
        }
        return max == Integer.MIN_VALUE ? this.ownPriority : max;
    }

    @Override
    public boolean isMaxPriority() {
        if (this.otherPartisipants.size() == 1) {
            return this.ownPriority == MAX_PRIORITY;
        }
        if (this.otherPartisipants.size() > 1 && this.currentPartisipants.size() == 0 && this.ownPriority == MAX_PRIORITY) {
            return false;
        }
        return this.otherPartisipants.size() <= 1 || this.currentPartisipants.size() != 0 || this.previousMaxPriority == this.ownPriority || this.previousPartisipantsCount <= 1;
    }
}

