/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.app;

import java.util.concurrent.CountDownLatch;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class SessionProviderServiceTest
extends BaseStandaloneTest {
    private SessionProviderService provider;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.provider = new ThreadLocalSessionProviderService();
    }

    @Override
    protected void tearDown() throws Exception {
        this.provider = null;
        super.tearDown();
    }

    public void testGetSystemSesssion() {
        SessionProvider ssp = this.provider.getSystemSessionProvider(null);
        SessionProviderServiceTest.assertNotNull((String)"System session provider must be reachable anyway ", (Object)ssp);
        SessionProviderServiceTest.assertEquals((String)"Same system session provider should be returned to this thread ", (Object)ssp, (Object)this.provider.getSystemSessionProvider(null));
    }

    public void testGetSystemSesssionWithSet() {
        SessionProvider ssp = this.provider.getSystemSessionProvider(null);
        this.provider.setSessionProvider(null, SessionProvider.createAnonimProvider());
        SessionProviderServiceTest.assertEquals((String)"Same system session provider should be returned to this thread ", (Object)ssp, (Object)this.provider.getSystemSessionProvider(null));
    }

    public void testGetSystemSesssionAnotherTrhead() throws InterruptedException {
        SessionProvider ssp = this.provider.getSystemSessionProvider(null);
        final SessionProviderService provider = this.provider;
        final SessionProvider[] atSSP = new SessionProvider[]{ssp};
        final CountDownLatch testerLatch = new CountDownLatch(1);
        Thread tester = new Thread(){

            @Override
            public void run() {
                atSSP[0] = provider.getSystemSessionProvider(null);
                testerLatch.countDown();
            }
        };
        tester.start();
        testerLatch.await();
        SessionProviderServiceTest.assertNotSame((String)"Another thread should obtain another system session provider from the service", (Object)ssp, (Object)atSSP[0]);
    }
}

