/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RESTRegistryService;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.security.ConversationState;

public class RESTRegistryTest
extends BaseStandaloneTest {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.RESTRegistryTest");
    private SessionProviderService sessionProviderService;
    private static final String SERVICE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><exo_service xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" jcr:primaryType=\"exo:registryEntry\"/>";
    private RESTRegistryService restRegService;
    private ResourceBinder binder;
    private RequestHandler handler;
    private URI baseUri;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sessionProviderService = (SessionProviderService)this.container.getComponentInstanceOfType(SessionProviderService.class);
        this.sessionProviderService.setSessionProvider(null, new SessionProvider(ConversationState.getCurrent()));
        this.restRegService = (RESTRegistryService)this.container.getComponentInstanceOfType(RESTRegistryService.class);
        this.binder = (ResourceBinder)this.container.getComponentInstanceOfType(ResourceBinder.class);
        this.handler = (RequestHandler)this.container.getComponentInstanceOfType(RequestHandler.class);
        this.baseUri = new URI("http://localhost:8080/rest");
    }

    public void testRESTRegservice() throws Exception {
        RESTRegistryTest.assertNotNull((Object)this.restRegService);
        RESTRegistryTest.assertNotNull((Object)this.binder);
        RESTRegistryTest.assertNotNull((Object)this.handler);
        this.repositoryService.setCurrentRepositoryName("db1");
        DummyContainerResponseWriter wr = new DummyContainerResponseWriter();
        URI reqUri = new URI(this.baseUri.toString() + "/registry/");
        ContainerResponse cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)200, (int)cres.getStatus());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/exo_service");
        cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)404, (int)cres.getStatus());
        RESTRegistryTest.assertNull((Object)wr.getBody());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services");
        cres = RESTRegistryTest.request(this.handler, wr, "POST", reqUri, this.baseUri, SERVICE_XML.getBytes(), new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)201, (int)cres.getStatus());
        RESTRegistryTest.assertEquals((Object)new URI(reqUri + "/exo_service"), (Object)wr.getHeaders().getFirst((Object)"Location"));
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/exo_service");
        cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)200, (int)cres.getStatus());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services");
        cres = RESTRegistryTest.request(this.handler, wr, "PUT", reqUri, this.baseUri, SERVICE_XML.getBytes(), new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)201, (int)cres.getStatus());
        RESTRegistryTest.assertEquals((Object)new URI(reqUri + "/exo_service"), (Object)wr.getHeaders().getFirst((Object)"Location"));
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/exo_service");
        cres = RESTRegistryTest.request(this.handler, wr, "DELETE", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)204, (int)cres.getStatus());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/exo_service");
        cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)404, (int)cres.getStatus());
        RESTRegistryTest.assertNull((Object)wr.getBody());
    }

    public void testCreateGetEntry() throws Exception {
        DummyContainerResponseWriter wr = new DummyContainerResponseWriter();
        InputStream in = new RegistryEntry("test").getAsInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rd = -1;
        while ((rd = in.read()) != -1) {
            out.write(rd);
        }
        byte[] data = out.toByteArray();
        this.repositoryService.setCurrentRepositoryName("db1");
        URI reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/group/test");
        ContainerResponse cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)404, (int)cres.getStatus());
        RESTRegistryTest.assertNull((Object)wr.getBody());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/group/");
        cres = RESTRegistryTest.request(this.handler, wr, "POST", reqUri, this.baseUri, data, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)201, (int)cres.getStatus());
        RESTRegistryTest.assertEquals((Object)new URI(reqUri + "test"), (Object)wr.getHeaders().getFirst((Object)"Location"));
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/group/test");
        cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)200, (int)cres.getStatus());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/group/");
        cres = RESTRegistryTest.request(this.handler, wr, "DELETE", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)204, (int)cres.getStatus());
        wr.reset();
        reqUri = new URI(this.baseUri.toString() + "/registry/exo:services/group/test");
        cres = RESTRegistryTest.request(this.handler, wr, "GET", reqUri, this.baseUri, null, new InputHeadersMap((Map)new MultivaluedMapImpl()));
        RESTRegistryTest.assertEquals((int)404, (int)cres.getStatus());
        RESTRegistryTest.assertNull((Object)wr.getBody());
    }

    private static ContainerResponse request(RequestHandler handler, ContainerResponseWriter wr, String method, URI reqUri, URI baseUri, byte[] data, InputHeadersMap headers) throws Exception {
        ByteArrayInputStream in = data != null ? new ByteArrayInputStream(data) : null;
        ContainerRequest creq = new ContainerRequest(method, reqUri, baseUri, (InputStream)in, (MultivaluedMap)headers);
        ContainerResponse cres = new ContainerResponse(wr);
        handler.handleRequest((GenericContainerRequest)creq, (GenericContainerResponse)cres);
        return cres;
    }

    public static class DummyContainerResponseWriter
    implements ContainerResponseWriter {
        private byte[] body;
        private MultivaluedMap<String, Object> headers;

        public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Object entity = response.getEntity();
            if (entity != null) {
                entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
                this.body = out.toByteArray();
            }
        }

        public void writeHeaders(GenericContainerResponse response) throws IOException {
            this.headers = response.getHttpHeaders();
        }

        public byte[] getBody() {
            return this.body;
        }

        public MultivaluedMap<String, Object> getHeaders() {
            return this.headers;
        }

        public void reset() {
            this.body = null;
            this.headers = null;
        }
    }
}

