/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository;

import java.net.URI;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.AbstractBackupTestCase;
import org.exoplatform.services.jcr.ext.backup.ExtendedBackupManager;
import org.exoplatform.services.jcr.ext.repository.NamesList;
import org.exoplatform.services.jcr.ext.repository.RepositoryServiceConf;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;

public class RestRepositoryServiceTest
extends AbstractBackupTestCase {
    private String REST_REPOSITORY_SERVICE_PATH = "/jcr-service";

    public void testRepositoriesList() throws Exception {
        AbstractBackupTestCase.TesterContainerResponce cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/repositories"));
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        NamesList repositories = (NamesList)this.getObject(NamesList.class, cres.responseWriter.getBody());
        RestRepositoryServiceTest.assertNotNull((Object)repositories);
        RestRepositoryServiceTest.assertEquals((int)this.repositoryService.getConfig().getRepositoryConfigurations().size(), (int)repositories.getNames().size());
    }

    public void testWorkspacesList() throws Exception {
        String repoName = this.repositoryService.getConfig().getDefaultRepositoryName();
        AbstractBackupTestCase.TesterContainerResponce cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/workspaces/" + repoName + "/"));
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        NamesList workspaces = (NamesList)this.getObject(NamesList.class, cres.responseWriter.getBody());
        RestRepositoryServiceTest.assertNotNull((Object)workspaces);
        RestRepositoryServiceTest.assertEquals((int)this.repositoryService.getConfig().getRepositoryConfiguration(repoName).getWorkspaceEntries().size(), (int)workspaces.getNames().size());
    }

    public void testGetDefaultWorkspaceConfig() throws Exception {
        String repoName = this.repositoryService.getConfig().getDefaultRepositoryName();
        AbstractBackupTestCase.TesterContainerResponce cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/default-ws-config/" + repoName + "/"));
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        WorkspaceEntry workspaceEntry = (WorkspaceEntry)this.getObject(WorkspaceEntry.class, cres.responseWriter.getBody());
        RestRepositoryServiceTest.assertNotNull((Object)workspaceEntry);
        RestRepositoryServiceTest.assertEquals((String)this.repositoryService.getConfig().getRepositoryConfiguration(repoName).getDefaultWorkspaceName(), (String)workspaceEntry.getName());
    }

    public void testGetRepositoryServiceConfiguration() throws Exception {
        AbstractBackupTestCase.TesterContainerResponce cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/repository-service-configuration"));
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RepositoryServiceConf repositoryConf = (RepositoryServiceConf)this.getObject(RepositoryServiceConf.class, cres.responseWriter.getBody());
        RestRepositoryServiceTest.assertNotNull((Object)repositoryConf);
        RestRepositoryServiceTest.assertEquals((String)this.repositoryService.getConfig().getDefaultRepositoryName(), (String)repositoryConf.getDefaultRepositoryName());
        RestRepositoryServiceTest.assertEquals((int)this.repositoryService.getConfig().getRepositoryConfigurations().size(), (int)repositoryConf.getRepositories().size());
    }

    public void testCreateRepository() throws Exception {
        RepositoryEntry rEntry = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null, null);
        AbstractBackupTestCase.TesterContainerResponce cres = this.makePostRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/create-repository"), rEntry);
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RestRepositoryServiceTest.assertTrue((boolean)this.isRepositoryExists(rEntry.getName()));
    }

    public void testCreateRepositoryWithInvalidChars() throws Exception {
        String wsName = "ws_over:?//\\__rest!!_1";
        String rName = "repo:?//\\_over:_re??st";
        RepositoryEntry rEntry = this.helper.createRepositoryEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, wsName, null);
        rEntry.setName(rName);
        AbstractBackupTestCase.TesterContainerResponce cres = this.makePostRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/create-repository"), rEntry);
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RestRepositoryServiceTest.assertTrue((boolean)this.isRepositoryExists(rEntry.getName()));
    }

    public void testCreateWorkspace() throws Exception {
        WorkspaceEntry wEntry = this.helper.createWorkspaceEntry(JDBCDataContainerConfig.DatabaseStructureType.MULTI, null);
        AbstractBackupTestCase.TesterContainerResponce cres = this.makePostRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/create-workspace/db1"), wEntry);
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RestRepositoryServiceTest.assertTrue((boolean)this.isWorkspaceExists("db1", wEntry.getName()));
    }

    public void testRemoveWorkspace() throws Exception {
        AbstractBackupTestCase.RepoInfo rInfo = this.createRepositoryAndGetSession();
        AbstractBackupTestCase.TesterContainerResponce cres = this.makePostRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/remove-workspace/" + rInfo.rName + "/" + rInfo.wsName + "/false/"), "");
        RestRepositoryServiceTest.assertEquals((int)409, (int)cres.getStatus());
        cres = this.makePostRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/remove-workspace/" + rInfo.rName + "/" + rInfo.wsName + "/true/"), "");
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RestRepositoryServiceTest.assertFalse((boolean)this.isWorkspaceExists(rInfo.rName, rInfo.wsName));
    }

    public void testRemoveRepository() throws Exception {
        AbstractBackupTestCase.RepoInfo rInfo = this.createRepositoryAndGetSession();
        AbstractBackupTestCase.TesterContainerResponce cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/remove-repository/" + rInfo.rName + "/false/"));
        RestRepositoryServiceTest.assertEquals((int)409, (int)cres.getStatus());
        cres = this.makeGetRequest(new URI(this.REST_REPOSITORY_SERVICE_PATH + "/remove-repository/" + rInfo.rName + "/true/"));
        RestRepositoryServiceTest.assertEquals((int)200, (int)cres.getStatus());
        RestRepositoryServiceTest.assertFalse((boolean)this.isRepositoryExists(rInfo.rName));
    }

    @Override
    protected ExtendedBackupManager getBackupManager() {
        return this.getJCRBackupManager();
    }
}

