/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.script.groovy.XMLGroovyScript2Rest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GroovyScript2RestLoaderPlugin
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.GroovyScript2RestLoaderPlugin");
    private final RepositoryService repositoryService;
    private List<XMLGroovyScript2Rest> l = new ArrayList<XMLGroovyScript2Rest>();
    private String repository;
    private String workspace;
    private String node;

    public GroovyScript2RestLoaderPlugin(InitParams params, RepositoryService repoServiceo) {
        this.repositoryService = repoServiceo;
        this.repository = params.containsKey((Object)"repository") ? params.getValueParam("repository").getValue() : null;
        this.workspace = params.getValueParam("workspace").getValue();
        this.node = params.getValueParam("node").getValue();
        Iterator iterator = params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam p = (PropertiesParam)iterator.next();
            String name = p.getName();
            boolean autoload = Boolean.valueOf(p.getProperty("autoload"));
            String path = p.getProperty("path");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Read new script configuration " + name));
            }
            this.l.add(new XMLGroovyScript2Rest(name, path, autoload));
        }
    }

    public List<XMLGroovyScript2Rest> getXMLConfigs() {
        return this.l;
    }

    public String getRepository() {
        if (this.repository == null) {
            try {
                return this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Can not get current repository and repository name was not configured", e);
            }
        }
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getNode() {
        return this.node;
    }
}

