/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.repository.creation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreator;
import org.exoplatform.services.database.creator.DBCreatorException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.repository.creation.DBCreationProperties;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationException;
import org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationService;
import org.exoplatform.services.jcr.ext.repository.creation.StorageCreationProperties;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jdbc.impl.CloseableDataSource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.picocontainer.Startable;

public class RepositoryCreationServiceImpl
implements RepositoryCreationService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryCreationService");
    private static final String FACTORY_CLASSS_NAME_PARAM = "factory-class-name";
    private static final String DEFAULT_DATA_SOURCE_FACTORY = "org.apache.commons.dbcp.BasicDataSourceFactory";
    private String factoryClassName = "org.apache.commons.dbcp.BasicDataSourceFactory";
    private final RepositoryService repositoryService;
    private final RPCService rpcService;
    private final BackupManager backupManager;
    private ExoContainerContext context;
    private final InitialContextInitializer initialContextInitializer;
    private final Map<String, String> pendingRepositories = new ConcurrentHashMap<String, String>();
    private static final SecureRandom tokenGenerator = new SecureRandom();
    private RemoteCommand reserveRepositoryName;
    private RemoteCommand createRepository;
    private RemoteCommand startRepository;
    private RemoteCommand removeRepository;
    private RemoteCommand canRemoveRepository;

    public RepositoryCreationServiceImpl(InitParams initParams, RepositoryService repositoryService, BackupManager backupManager, ExoContainerContext context, InitialContextInitializer initialContextInitializer) {
        this(initParams, repositoryService, backupManager, context, initialContextInitializer, null);
    }

    public RepositoryCreationServiceImpl(InitParams initParams, final RepositoryService repositoryService, BackupManager backupManager, ExoContainerContext context, InitialContextInitializer initialContextInitializer, final RPCService rpcService) {
        if (initParams != null) {
            this.factoryClassName = initParams.getValueParam(FACTORY_CLASSS_NAME_PARAM).getValue();
        }
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.rpcService = rpcService;
        this.context = context;
        this.initialContextInitializer = initialContextInitializer;
        if (rpcService != null) {
            this.reserveRepositoryName = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-reserveRepositoryName";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    String repositoryName = (String)((Object)args[0]);
                    return RepositoryCreationServiceImpl.this.reserveRepositoryNameLocally(repositoryName);
                }
            });
            this.createRepository = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-createRepository";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Serializable execute(Serializable[] args) throws Throwable {
                    String backupId = (String)((Object)args[0]);
                    String stringRepositoryEntry = (String)((Object)args[1]);
                    String rToken = (String)((Object)args[2]);
                    DBCreationProperties creationProps = (DBCreationProperties)args[3];
                    try {
                        RepositoryEntry rEntry = (RepositoryEntry)RepositoryCreationServiceImpl.this.getObject(RepositoryEntry.class, stringRepositoryEntry.getBytes("UTF-8"));
                        RepositoryCreationServiceImpl.this.createRepositoryLocally(backupId, rEntry, rToken, creationProps);
                        Serializable serializable = null;
                        return serializable;
                    }
                    finally {
                        RepositoryCreationServiceImpl.this.pendingRepositories.remove(rToken);
                    }
                }
            });
            this.startRepository = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-startRepository";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    if (!rpcService.isCoordinator()) {
                        String stringRepositoryEntry = (String)((Object)args[0]);
                        RepositoryEntry rEntry = (RepositoryEntry)RepositoryCreationServiceImpl.this.getObject(RepositoryEntry.class, stringRepositoryEntry.getBytes("UTF-8"));
                        DBCreationProperties creationProps = (DBCreationProperties)args[1];
                        RepositoryCreationServiceImpl.this.startRepository(rEntry, creationProps);
                    }
                    return null;
                }
            });
            this.removeRepository = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-removeRepository";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    String repositoryName = (String)((Object)args[0]);
                    Boolean forceRemove = (Boolean)args[1];
                    RepositoryCreationServiceImpl.this.removeRepositoryLocally(repositoryName, forceRemove);
                    return null;
                }
            });
            this.canRemoveRepository = rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.ext.repository.creation.RepositoryCreationServiceImpl-checkRepositoryInUse";
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    String repositoryName = (String)((Object)args[0]);
                    return Boolean.valueOf(repositoryService.canRemoveRepository(repositoryName));
                }
            });
        } else {
            LOG.warn((Object)"RepositoryCreationService initialized without RPCService, so other cluser nodes will not be notified about new repositories.");
        }
    }

    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry) throws RepositoryConfigurationException, RepositoryCreationException {
        String rToken = this.reserveRepositoryName(rEntry.getName());
        this.createRepositoryInternally(backupId, rEntry, rToken, null);
    }

    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry, StorageCreationProperties creationProps) throws RepositoryConfigurationException, RepositoryCreationException {
        String rToken = this.reserveRepositoryName(rEntry.getName());
        if (!(creationProps instanceof DBCreationProperties)) {
            throw new RepositoryCreationException("creationProps should be the instance of DBCreationProperties");
        }
        this.createRepositoryInternally(backupId, rEntry, rToken, (DBCreationProperties)creationProps);
    }

    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry, String rToken) throws RepositoryConfigurationException, RepositoryCreationException {
        this.createRepositoryInternally(backupId, rEntry, rToken, null);
    }

    @Override
    public void createRepository(String backupId, RepositoryEntry rEntry, String rToken, StorageCreationProperties creationProps) throws RepositoryConfigurationException, RepositoryCreationException {
        if (!(creationProps instanceof DBCreationProperties)) {
            throw new RepositoryCreationException("creationProps should be the instance of DBCreationProperties");
        }
        this.createRepositoryInternally(backupId, rEntry, rToken, (DBCreationProperties)creationProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRepositoryInternally(String backupId, RepositoryEntry rEntry, String rToken, DBCreationProperties creationProps) throws RepositoryConfigurationException, RepositoryCreationException {
        if (this.rpcService != null) {
            String stringRepositoryEntry = null;
            try {
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                JsonValue json = generatorImpl.createJsonObject((Object)rEntry);
                stringRepositoryEntry = json.toString();
            }
            catch (JsonException e) {
                throw new RepositoryCreationException("Can not serialize repository entry: " + e.getMessage(), e);
            }
            try {
                Object result = this.rpcService.executeCommandOnCoordinator(this.createRepository, true, new Serializable[]{backupId, stringRepositoryEntry, rToken, creationProps});
                if (result != null) {
                    if (result instanceof Throwable) {
                        throw new RepositoryCreationException("Can't create repository " + rEntry.getName(), (Throwable)result);
                    }
                    throw new RepositoryCreationException("createRepository command returned uknown result type.");
                }
            }
            catch (RPCException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryCreationException) {
                    throw (RepositoryCreationException)cause;
                }
                if (cause instanceof RepositoryConfigurationException) {
                    throw (RepositoryConfigurationException)cause;
                }
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            try {
                List results = this.rpcService.executeCommandOnAllNodes(this.startRepository, true, new Serializable[]{stringRepositoryEntry, creationProps});
                for (Object result : results) {
                    if (result == null) continue;
                    if (result instanceof Throwable) {
                        throw new RepositoryCreationException("Repository " + rEntry.getName() + " created on coordinator, but can not be started at other cluster nodes", (Throwable)result);
                    }
                    throw new RepositoryCreationException("startRepository command returns uknown result type");
                }
            }
            catch (RPCException e) {
                throw new RepositoryCreationException("Repository " + rEntry.getName() + " created on coordinator, can not be started at other cluster node: " + e.getMessage(), e);
            }
        }
        try {
            this.createRepositoryLocally(backupId, rEntry, rToken, creationProps);
        }
        finally {
            this.pendingRepositories.remove(rToken);
        }
    }

    @Override
    public String reserveRepositoryName(String repositoryName) throws RepositoryCreationException {
        if (this.rpcService != null) {
            try {
                Object result = this.rpcService.executeCommandOnCoordinator(this.reserveRepositoryName, true, new Serializable[]{repositoryName});
                if (result instanceof String) {
                    return (String)result;
                }
                if (result instanceof Throwable) {
                    throw new RepositoryCreationException("Can't reserve repository " + repositoryName, (Throwable)result);
                }
                throw new RepositoryCreationException("ReserveRepositoryName command returns unknown type result.");
            }
            catch (RPCException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryCreationException) {
                    throw (RepositoryCreationException)cause;
                }
                throw new RepositoryCreationException("Can not reserve repository name " + repositoryName + " since: " + e.getMessage(), e);
            }
        }
        return this.reserveRepositoryNameLocally(repositoryName);
    }

    protected String reserveRepositoryNameLocally(String repositoryName) throws RepositoryCreationException {
        block5: {
            try {
                if (this.repositoryService.getRepository(repositoryName) != null) {
                    throw new RepositoryCreationException("Repository " + repositoryName + " already exists.");
                }
            }
            catch (RepositoryConfigurationException e) {
                throw new RepositoryCreationException("Can not check does repository " + repositoryName + " exists: " + e.getMessage(), e);
            }
            catch (RepositoryException e) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        if (!this.pendingRepositories.containsValue(repositoryName)) {
            String rToken = repositoryName + tokenGenerator.nextLong();
            this.pendingRepositories.put(rToken, repositoryName);
            return rToken;
        }
        throw new RepositoryCreationException("Repository name " + repositoryName + " already reserved.");
    }

    protected void createRepositoryLocally(String backupId, RepositoryEntry rEntry, String rToken, DBCreationProperties creationProps) throws RepositoryConfigurationException, RepositoryCreationException {
        if (!this.pendingRepositories.containsKey(rToken)) {
            throw new RepositoryCreationException("Token " + rToken + " does not registered.");
        }
        Set<String> dataSourceNames = this.extractDataSourceNames(rEntry, true);
        for (String string : dataSourceNames) {
            Map refAddr = null;
            try {
                String dbName = rEntry.getName() + (String)(dataSourceNames.size() == 1 ? "" : "_" + string);
                DBCreator dbCreator = this.getDBCreator(creationProps);
                DBConnectionInfo dbConnectionInfo = dbCreator.createDatabase(dbName);
                refAddr = dbConnectionInfo.getProperties();
            }
            catch (DBCreatorException e) {
                throw new RepositoryCreationException("Can not create new database for " + rEntry.getName() + " repository.", e);
            }
            catch (ConfigurationException e) {
                throw new RepositoryCreationException("Can not get instance of DBCreator", e);
            }
            try {
                this.initialContextInitializer.getInitialContextBinder().bind(string, "javax.sql.DataSource", this.factoryClassName, null, refAddr);
            }
            catch (NamingException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
            catch (XMLStreamException e) {
                throw new RepositoryCreationException(e.getMessage(), e);
            }
        }
        RepositoryBackupChainLog backupChain = null;
        for (RepositoryBackupChainLog chainLog : this.backupManager.getRepositoryBackupsLogs()) {
            if (!chainLog.getBackupId().equals(backupId)) continue;
            backupChain = chainLog;
            break;
        }
        if (backupChain == null) {
            throw new RepositoryCreationException("BackupChain by id " + backupId + " does not exists.");
        }
        File file = new File(backupChain.getLogFilePath());
        if (file != null && file.exists()) {
            try {
                this.backupManager.restore(backupChain, rEntry, false, true);
            }
            catch (BackupOperationException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
            catch (BackupConfigurationException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
            catch (RepositoryException e) {
                throw new RepositoryCreationException(e.getLocalizedMessage(), e);
            }
        } else {
            throw new RepositoryCreationException("Backup log file by id " + backupId + (String)(file != null ? " and file path=" + file.getAbsolutePath() : "") + " do not exists.");
        }
    }

    protected void startRepository(RepositoryEntry repositoryEntry, DBCreationProperties creationProps) throws RepositoryCreationException {
        try {
            Set<String> dataSourceNames = this.extractDataSourceNames(repositoryEntry, false);
            for (String dataSource : dataSourceNames) {
                Map refAddr = null;
                try {
                    String dbName = repositoryEntry.getName() + (String)(dataSourceNames.size() == 1 ? "" : "_" + dataSource);
                    DBCreator dbCreator = this.getDBCreator(creationProps);
                    DBConnectionInfo dbConnectionInfo = dbCreator.getDBConnectionInfo(dbName);
                    refAddr = dbConnectionInfo.getProperties();
                }
                catch (DBCreatorException e) {
                    throw new RepositoryCreationException("Can not fetch database information associated with " + repositoryEntry.getName() + " repository and " + dataSource + " datasource.", e);
                }
                catch (ConfigurationException e) {
                    throw new RepositoryCreationException("Can't get instance of DBCreator", e);
                }
                try {
                    this.initialContextInitializer.getInitialContextBinder().bind(dataSource, "javax.sql.DataSource", this.factoryClassName, null, refAddr);
                }
                catch (NamingException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
                catch (XMLStreamException e) {
                    throw new RepositoryCreationException(e.getMessage(), e);
                }
            }
            this.repositoryService.createRepository(repositoryEntry);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryCreationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new RepositoryCreationException(e.getMessage(), e);
        }
    }

    private Set<String> extractDataSourceNames(RepositoryEntry repositoryEntry, boolean checkDataSourceExistance) throws RepositoryConfigurationException, RepositoryCreationException {
        HashSet<String> dataSourceNames = new HashSet<String>();
        for (WorkspaceEntry wsEntry : repositoryEntry.getWorkspaceEntries()) {
            boolean isMultiDB = JDBCDataContainerConfig.DatabaseStructureType.valueOf((String)wsEntry.getContainer().getParameterValue("db-structure-type").toUpperCase()).isMultiDatabase();
            String dbSourceName = wsEntry.getContainer().getParameterValue("source-name");
            if (isMultiDB && dataSourceNames.contains(dbSourceName)) {
                throw new RepositoryCreationException("RepositoryEntry for new " + repositoryEntry.getName() + " repository contains workspaces that marked as multiDB but have same datasource " + dbSourceName + ".");
            }
            if (checkDataSourceExistance) {
                try {
                    DataSource ds = (DataSource)this.initialContextInitializer.getInitialContext().lookup(dbSourceName);
                    if (ds != null) {
                        throw new RepositoryConfigurationException("RepositoryEntry for new " + repositoryEntry.getName() + " repository contains already binded datasource " + dbSourceName + ".");
                    }
                }
                catch (NameNotFoundException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                catch (NamingException e) {
                    throw new RepositoryConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            dataSourceNames.add(dbSourceName);
        }
        return dataSourceNames;
    }

    private Object getObject(Class cl, byte[] data) throws Exception {
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        JsonParserImpl jsonParser = new JsonParserImpl();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        return new BeanBuilder().createObject(cl, jsonValue);
    }

    public void start() {
    }

    public void stop() {
        if (this.rpcService != null) {
            this.rpcService.unregisterCommand(this.reserveRepositoryName);
            this.rpcService.unregisterCommand(this.createRepository);
            this.rpcService.unregisterCommand(this.startRepository);
            this.rpcService.unregisterCommand(this.removeRepository);
            this.rpcService.unregisterCommand(this.canRemoveRepository);
        }
    }

    @Override
    public void removeRepository(String repositoryName, boolean forceRemove) throws RepositoryCreationException {
        if (this.rpcService != null) {
            try {
                List results;
                if (!forceRemove) {
                    results = this.rpcService.executeCommandOnAllNodes(this.canRemoveRepository, true, new Serializable[]{repositoryName});
                    for (Object result : results) {
                        if (result == null) continue;
                        if (result instanceof Throwable) {
                            throw new RepositoryCreationException("It is not possible to check is repository " + repositoryName + " in usage or not", (Throwable)result);
                        }
                        if (result instanceof Boolean) {
                            if (((Boolean)result).booleanValue()) continue;
                            throw new RepositoryCreationException("Can't remove repository " + repositoryName + ". The repository in use.");
                        }
                        throw new RepositoryCreationException("checkRepositoryInUse command returned uknown result type");
                    }
                }
                results = this.rpcService.executeCommandOnAllNodes(this.removeRepository, true, new Serializable[]{repositoryName, Boolean.valueOf(forceRemove)});
                for (Object result : results) {
                    if (result == null) continue;
                    if (result instanceof Throwable) {
                        throw new RepositoryCreationException("Can't remove repository " + repositoryName, (Throwable)result);
                    }
                    throw new RepositoryCreationException("removeRepository command returned uknown result type");
                }
            }
            catch (RPCException e) {
                throw new RepositoryCreationException("Can't remove repository " + repositoryName, e);
            }
        }
        if (!forceRemove) {
            try {
                if (!this.repositoryService.canRemoveRepository(repositoryName)) {
                    throw new RepositoryCreationException("Can't remove repository " + repositoryName + ". The repository in use.");
                }
            }
            catch (RepositoryException e) {
                throw new RepositoryCreationException("It is not possible to check is repository " + repositoryName + " in usage or not", e);
            }
        }
        this.removeRepositoryLocally(repositoryName, forceRemove);
    }

    protected void removeRepositoryLocally(String repositoryName, boolean forceRemove) throws RepositoryCreationException {
        try {
            ManageableRepository repositorty = this.repositoryService.getRepository(repositoryName);
            Set<String> datasources = this.extractDataSourceNames(repositorty.getConfiguration(), false);
            for (String workspaceName : repositorty.getWorkspaceNames()) {
                WorkspaceContainerFacade wc = repositorty.getWorkspaceContainer(workspaceName);
                SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
                sessionRegistry.closeSessions(workspaceName);
            }
            this.repositoryService.removeRepository(repositoryName, forceRemove);
            this.repositoryService.getConfig().retain();
            for (String dsName : datasources) {
                try {
                    DataSource ds = (DataSource)this.initialContextInitializer.getInitialContext().lookup(dsName);
                    this.initialContextInitializer.getInitialContextBinder().unbind(dsName);
                    if (!(ds instanceof CloseableDataSource)) continue;
                    ((CloseableDataSource)ds).close();
                }
                catch (NamingException e) {
                    LOG.error((Object)("Can't unbind datasource " + dsName), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)("Can't unbind datasource " + dsName), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    LOG.error((Object)("Can't unbind datasource " + dsName), (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryCreationException("Can't remove repository", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryCreationException("Can't remove repository", e);
        }
    }

    private DBCreator getDBCreator(DBCreationProperties creationProps) throws ConfigurationException {
        if (creationProps == null) {
            return (DBCreator)this.context.getContainer().getComponentInstanceOfType(DBCreator.class);
        }
        ConfigurationManager cm = (ConfigurationManager)this.context.getContainer().getComponentInstanceOfType(ConfigurationManager.class);
        return new DBCreator(creationProps.getServerUrl(), creationProps.getConnProps(), creationProps.getDBScriptPath(), creationProps.getDBUserName(), creationProps.getDBPassword(), cm);
    }
}

