/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionHistoryUtils {
    protected static final Log log = ExoLogger.getLogger(VersionHistoryUtils.class);
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_MAX = 0;
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_EXPIRED = 0;
    public static final String NT_FILE = "nt:file";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    private static String maxAllowVersionProp = "jcr.documents.versions.max";
    private static String expirationTimeProp = "jcr.documents.versions.expiration";
    private static int maxAllowVersion;
    private static long maxLiveTime;

    public static void createVersion(Node nodeVersioning) throws Exception {
        if (!nodeVersioning.isNodeType(NT_FILE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Version history is not impact with non-nt:file documents, there'is not any version created.");
            }
            return;
        }
        if (!nodeVersioning.isNodeType(MIX_VERSIONABLE)) {
            if (nodeVersioning.canAddMixin(MIX_VERSIONABLE)) {
                nodeVersioning.addMixin(MIX_VERSIONABLE);
                nodeVersioning.save();
            }
            return;
        }
        if (!nodeVersioning.isCheckedOut()) {
            nodeVersioning.checkout();
        } else {
            nodeVersioning.checkin();
            nodeVersioning.checkout();
        }
        if (maxAllowVersion != 0 || maxLiveTime != 0L) {
            VersionHistoryUtils.removeRedundant(nodeVersioning);
        }
        nodeVersioning.save();
    }

    private static void removeRedundant(Node nodeVersioning) throws Exception {
        VersionHistory versionHistory = nodeVersioning.getVersionHistory();
        String baseVersion = nodeVersioning.getBaseVersion().getName();
        String rootVersion = versionHistory.getRootVersion().getName();
        Date now = new Date();
        HashMap<Long, String> versionTimestampToName = new HashMap<Long, String>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        VersionIterator versions = versionHistory.getAllVersions();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            String versionName = version.getName();
            if (rootVersion.equals(versionName) || baseVersion.equals(versionName)) continue;
            long created = version.getCreated().getTimeInMillis();
            if (maxLiveTime != 0L && now.getTime() - created > maxLiveTime) {
                versionHistory.removeVersion(versionName);
                continue;
            }
            versionTimestampToName.put(created, versionName);
            timestamps.add(created);
        }
        if (maxAllowVersion != 0 && timestamps.size() >= maxAllowVersion) {
            Collections.sort(timestamps);
            VersionHistoryUtils.removeExpiredVersions(versionHistory, timestamps, versionTimestampToName, rootVersion, baseVersion, true);
            if (timestamps.size() >= maxAllowVersion) {
                VersionHistoryUtils.removeExpiredVersions(versionHistory, timestamps, versionTimestampToName, rootVersion, baseVersion, false);
            }
        }
    }

    private static void removeExpiredVersions(VersionHistory versionHistory, List<Long> timestamps, Map<Long, String> map, String rootVersion, String baseVersion, boolean skipLabeled) throws Exception {
        int i = 1;
        while (timestamps.size() >= maxAllowVersion && i < timestamps.size()) {
            String[] labels;
            boolean hasLabel;
            long ts = timestamps.get(i);
            String name = map.get(ts);
            Version version = versionHistory.getVersion(name);
            if (rootVersion.equals(name) || baseVersion.equals(name)) {
                ++i;
                continue;
            }
            if (skipLabeled && (hasLabel = Arrays.stream(labels = versionHistory.getVersionLabels(version)).anyMatch(StringUtils::isNotEmpty))) {
                ++i;
                continue;
            }
            versionHistory.removeVersion(name);
            timestamps.remove(i);
        }
    }

    static {
        try {
            maxAllowVersion = Integer.parseInt(System.getProperty(maxAllowVersionProp));
            maxLiveTime = Integer.parseInt(System.getProperty(expirationTimeProp));
            if (maxAllowVersion < 0) {
                maxAllowVersion = 0;
            }
            if (maxLiveTime < 0L) {
                maxLiveTime = 0L;
            }
        }
        catch (NumberFormatException nex) {
            maxAllowVersion = 0;
            maxLiveTime = 0L;
        }
        maxLiveTime = maxLiveTime * 24L * 60L * 60L * 1000L;
    }
}

