/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.data;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.services.ftp.client.FtpClientSession;

public class FtpTimeStampedOutputStream
extends OutputStream {
    private OutputStream nativeOutputStream;
    private FtpClientSession clientSession;

    public FtpTimeStampedOutputStream(OutputStream nativeOutputStream, FtpClientSession clientSession) {
        this.nativeOutputStream = nativeOutputStream;
        this.clientSession = clientSession;
    }

    @Override
    public void write(int dataByte) throws IOException {
        this.clientSession.refreshTimeOut();
        this.nativeOutputStream.write(dataByte);
    }

    @Override
    public void write(byte[] dataBytes) throws IOException {
        this.write(dataBytes, 0, dataBytes.length);
    }

    @Override
    public void write(byte[] dataBytes, int offset, int len) throws IOException {
        int allWrited = 0;
        int curOffset = offset;
        this.clientSession.refreshTimeOut();
        while (allWrited < len) {
            int curBlockSize = 2048;
            if (curBlockSize + allWrited > len) {
                curBlockSize = len - allWrited;
            }
            this.nativeOutputStream.write(dataBytes, curOffset, curBlockSize);
            this.clientSession.refreshTimeOut();
            allWrited += curBlockSize;
            curOffset += curBlockSize;
        }
    }

    @Override
    public void flush() throws IOException {
        this.nativeOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.nativeOutputStream.close();
    }
}

